<?php

namespace Website\Tool\Console\Command;

use Pimcore\Console\AbstractCommand;
use Symfony\Component\Console\Input\InputArgument;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Input\InputOption;
use Symfony\Component\Console\Output\OutputInterface;

class TemplatorSkadooshCommand extends AbstractCommand
{
	protected $supportedFrameworks = ['pimcore'];

	private function getSupportedFrameworks()
	{
		return $this->supportedFrameworks;
	}

	protected function configure()
	{
		$this
			->setName('templator:skadoosh')
			->setDescription('Explodes the templates made by Porta CSS ninjas into MVC ready layout. Use your Mushi finger hold on the Enter key to produce better results.')
			->addArgument(
				'input',
				InputArgument::REQUIRED,
				'The static templates input directory'
			)
			->addArgument(
				'output',
				InputArgument::REQUIRED,
				'The MVC generated templates output directory'
			)
			->addOption(
				'framework', 'f',
				InputOption::VALUE_REQUIRED,
				sprintf('Specify a framework [%s]', implode('|', $this->getSupportedFrameworks())),
				current($this->getSupportedFrameworks())
			)
			->addOption(
				'copy-static', 'c',
				InputOption::VALUE_NONE,
				'Copy static files (css, js, etc.)',
				null
			)
			->addOption(
				'php-min', null,
				InputOption::VALUE_NONE,
				'Generate CSS and JS includes via Zend minification helpers.',
				null
			);
	}

	protected function execute(InputInterface $input, OutputInterface $output)
	{
		//get input
		$inputDir = rtrim($input->getArgument('input'), DIRECTORY_SEPARATOR);
		$outputDir = rtrim($input->getArgument('output'), DIRECTORY_SEPARATOR);
		$framework = $input->getOption('framework');
		$phpMin = $input->getOption('php-min');
		$copyStatic = $input->getOption('copy-static');

		//check input
		if (!in_array($framework, $this->getSupportedFrameworks())) {
			$this->writeError(sprintf('Framework [%s] is not supported.', $framework));
			exit;
		}

		if ($framework == 'pimcore') {
			$generator = new \Website\Tool\Templator\Pimcore($inputDir, $outputDir);
		} else {
			$output->writeLn(sprintf('Framework [%s] not implemented yet.', $framework));
			exit;
		}

		$result = $generator->run($copyStatic, $phpMin);

		if ($result === 0) {
			$output->writeln('Done.');
		} else {
			$output->writeln($result);
		}
	}
}
