<?php

/**
 * @author Martin Kuric <martin.kuric@portadesign.cz>
 */

namespace Website\Controller\Action\Helper;

class AjaxResponseBuilder extends \Zend_Controller_Action_Helper_Abstract
{

	protected $snippets;
	protected $controller = null;

	public function direct()
	{
		return $this;
	}

	public function init()
	{
		parent::init();

		$this->controller = $this->getActionController();
		$this->clearSnippets();
	}

	public function addFlashMessages()
	{
		return $this->addElement('#flash-messages', 'snippets/flash-messages.php');
	}

	public function addElement($selector, $body, $rendered = false, $append = false)
	{
		$this->snippets[$selector] = [
			'type' => ($append) ? 'element-append' : 'element',
			(($rendered) ? 'body' : 'render') => $body
		];

		return $this;
	}

	public function addPopup($body, $rendered = false)
	{
		$this->snippets['popup'] = [
			'type' => 'popup',
			(($rendered) ? 'body' : 'render') => $body
		];

		return $this;
	}

	public function closePopup()
	{
		$this->snippets['popup-close'] = ['type' => 'popup-close'];

		return $this;
	}

	public function removeElement($selector, $body)
	{
		$this->snippets[$selector] = ['type' => 'remove', 'body' => $body];

		return $this;
	}

	public function hideElement($selector, $body)
	{
		$this->snippets[$selector] = ['type' => 'hide', 'body' => $body];

		return $this;
	}

	public function showElement($selector, $body)
	{
		$this->snippets[$selector] = ['type' => 'show', 'body' => $body];

		return $this;
	}

	public function addRedirect($url, $ajax = false)
	{
		if (!isset($this->snippets[$url])) {
			$this->snippets[$url] = [
				'type' => ($ajax) ? 'redirect-ajax' : 'redirect',
				'body' => $url
			];
		}

		return $this;
	}

	public function addEval($script)
	{
		if (!isset($this->snippets['eval'])) {
			$this->snippets['eval'] = ['type' => 'eval', 'body' => ''];
		}
		$this->snippets['eval']['body'] .= $script;

		return $this;
	}

	public function removeSnippet($key)
	{
		unset($this->snippets[$key]);

		return $this;
	}

	public function clearSnippets()
	{
		$this->snippets = [];

		return $this;
	}

	public function checkPost()
	{
		if (!$this->getRequest()->isPost()) {
			$this->controller->addErrorMsg($this->controller->translate('msg_invalid_request'));
			$this->clearSnippets()->addRedirect($this->controller->view->docUrl(
				'/'.\Website\Tool\Utils::$defaultLanguage)
			)->sendResponse();
		}
	}

	public function sendResponse()
	{
		if (!$this->controller->isAjax()) {
			$this->controller->gotoUrl($this->controller->view->docUrl(
				'/'.\Website\Tool\Utils::$defaultLanguage)
			);
		} else {
			\Zend_Controller_Action_HelperBroker::getStaticHelper('json')
				->sendJson($this->buildResponse());
		}
	}

	private function buildResponse()
	{
		$response = ['status' => 'success', 'snippets' => []];

		foreach($this->snippets as $selector => $snippet)
		{
			$body = true;
			switch ($snippet['type']) {
				case 'element': case 'element-append': case 'remove': case 'hide':
				case 'show': case 'popup': case 'popup-close': {
					if (isset($snippet['body'])) {
						$body = $snippet['body'];
					} elseif (isset($snippet['render'])) {
						$body = $this->controller->view->render($snippet['render']);
					}
				} break;
				case 'redirect': case 'redirect-ajax': case 'eval': {
					$body = $snippet['body'];
				} break;
			}

			if ($selector) {
				$response['snippets'][$selector] = [
					'type' => $snippet['type'], 'body' => $body
				];
			}

		}

		return $response;
	}

}
