<?php
set_time_limit(60000);
include_once(__DIR__."../../../../pimcore/cli/startup.php");
//execute in admin mode
define("PIMCORE_ADMIN", true);
fputs(STDOUT, "\n");


// check new class definitions files and try to create classes out of them
foreach(glob(PIMCORE_WEBSITE_VAR.'/classes/*.psf') as $definitionFilePath) {
	// parse class Id from definition file name
	list(, $classId) = explode('_', substr(basename($definitionFilePath), 0, -4));
	// check if the definition exists or try to create it
	$classDefinition = \Pimcore\Model\Object\ClassDefinition::getById($classId);
	if (!$classDefinition) createClassDefinition($classId);
}

// save all classes
$classList = new \Pimcore\Model\Object\ClassDefinition\Listing();
$classList->load();
foreach($classList->getClasses() as $classDefinition){
    $classDefinition->save();
	fputs(STDOUT, sprintf("Class %s saved.\n", str_pad($classDefinition->getName(), 20, ' ', STR_PAD_RIGHT)));
}

// save all object bricks
$objectBrickList = new \Pimcore\Model\Object\Objectbrick\Definition\Listing();
foreach($objectBrickList->load() as $brickDefinition) {
    $brickDefinition->save();
	fputs(STDOUT, sprintf("ObjectBrick %s saved.\n", str_pad($brickDefinition->getKey(), 20, ' ', STR_PAD_RIGHT)));
}

// save all fieldcollections
$fieldCollectionList = new \Pimcore\Model\Object\Fieldcollection\Definition\Listing();
foreach ($fieldCollectionList->load() as $collectionDefinition) {
    $collectionDefinition->save();
	fputs(STDOUT, sprintf("FieldColleciton %s saved.\n", str_pad($collectionDefinition->getKey(), 20, ' ', STR_PAD_RIGHT)));
}

\Pimcore\Cache::clearAll();


function createClassDefinition($id)
{
	// parse class name from main layout panel name
	fputs(STDOUT, sprintf("Creating new class with ID [%d]... ", $id));
	$layoutDefinition = unserialize(file_get_contents(PIMCORE_WEBSITE_VAR.'/classes/definition_'.$id.'.psf'));
	if (!$layoutDefinition->childs || !$layoutDefinition->childs[0]->name || $layoutDefinition->childs[0]->name == 'Layout') {
		fputs(STDOUT, sprintf("ERROR - could not parse class name from layout.\n"));
		return false;
	}
	$className = $layoutDefinition->childs[0]->name;
	if (\Pimcore\Model\Object\ClassDefinition::getByName($className)) {
		fputs(STDOUT, sprintf("ERROR - class with name [%s] already exists.\n", $className));
		return false;
	}

	// create new class definition
	$classDefinition = new \Pimcore\Model\Object\ClassDefinition();
	$classDefinition->setId($id);
	$classDefinition->setName($className);
	$classDefinition->setCreationDate(time());
	$classDefinition->setModificationDate(time());
	$classDefinition->setUserOwner(2);
	$classDefinition->setUserModification(2);
	$classDefinition->setAllowInherit(false);
	$classDefinition->setAllowVariants(false);
	$classDefinition->setShowVariants(false);
	$classDefinition->setPreviewUrl('');
	$classDefinition->setPropertyVisibility([
		'grid' => [
			'id' => true,
			'path' => false,
			'published' => true,
			'modificationDate' => false,
			'creationDate' => true 
		],
		'search' => [
			'id' => true,
			'path' => true,
			'published' => true,
			'modificationDate' => true,
			'creationDate' => true
		]
	]);
	$classDefinition->setLayoutDefinitions($layoutDefinition);

	// save
	$db = \Pimcore\Db::get();
	try {
		//we have to insert a row to `classes` table manually before saving the definition
        if (!$db->insert('classes', ['name' => $classDefinition->getName(), 'id' => $classDefinition->getId()])) {
			throw new Exception('could not insert row into `classes` table.');
		}
		$classDefinition->save();
	} catch (Exception $e) {
		fputs(STDOUT, sprintf("ERROR - %s\n", $e->getMessage()));
		exit;
	}

	//check the ID checks out
	if ($classDefinition->getId() != $id) {
		fputs(STDOUT, sprintf("ERROR - ID mismatch [%d]\n", $classDefinition->getId()));
	}

	fputs(STDOUT, sprintf(" class [%s] created.\n", $classDefinition->getName()));
	return true;
}
