<?php

namespace Website\View\Helper;

class Editable extends \Zend_View_Helper_Abstract
{	
	public $view;
	protected $containerWidth = 940;

	protected function _run()
	{
	}
	
	public function editable($key, $method, $config = [])
	{
		$defaultConfigs = [
			'input' => [
				'width' => $this->containerWidth,
				'htmlspecialchars' => true
			],
			'numeric' => [
				'width' => $this->containerWidth,
				'minValue' => 0
			],
			'textarea' => [
				'width' => $this->containerWidth,
				'height' => 100,
				'nl2br' => true,
				'htmlspecialchars' => true
			],
			'wysiwyg' => [
				'width' => $this->containerWidth,
				'height' => 100,
				'inline' => true,
				'enterMode' => 1,
				'customConfig' => '/plugins/Backend/static/js/cke_config_document_loader.js'
			],
			'image' => [
				'hidetext' => true,
				'reload' => false, 
				'thumbnail' => 'ArticleGalleryThumbnail',
				'uploadPath' => '/dokumenty'
			],
			'multihref' => [
				'width' => $this->containerWidth,
				'uploadPath' => '/dokumenty',
				'thumbnail' => null
			],
			'href' => [
				'width' => $this->containerWidth
			],
			'checkbox' => [
				'reload' => false
			],
			'date' => [
				'format' => 'd.m.Y'
			],
			'select' => [
				'reload' => false,
				'store' => [['dummy', 'dummy']]
			],
			'table' => [
				'width' => $this->containerWidth,
				'defaults' => ['cols' => 1, 'rows' => 1, 'data' => [['dummy']]]
			],
			'multiselect' => [
				'width' => $this->containerWidth,
				'store' => [['dummy', 'dummy']]
			]
		];
		if ($method == 'image' && $this->view->editmode) {
			$defaultConfigs['image']['width'] = $this->containerWidth;
		}

		if (array_key_exists($method, $defaultConfigs)) {
			if ($this->view->editmode || $method == 'image') { // test on image, because we do not want to throw away the thumbnail key in frontend
				return $this->view->$method($key, $this->replaceConfigDefaults($defaultConfigs[$method], $config));
			} else {
				return $this->view->$method($key);
			}
		}
	}

	public function setView(\Zend_View_Interface $view) {
		parent::setView($view);
		
		$this->view = $view;
	}

	private function replaceConfigDefaults($defaultConfig, $config = [])
	{
		// replace existing keys from $config or global $this->view
		foreach (array_keys($defaultConfig) as $key) {
			if (isset($config[$key])) {
				if ($config[$key]) $defaultConfig[$key] = $config[$key];
				else unset($defaultConfig[$key]);
			} elseif (isset($this->view->$key)) {
				if ($this->view->$key) $defaultConfig[$key] = $this->view->$key;
				else unset($defaultConfig[$key]);
			}
		}

		// add new keys from $config
		foreach($config as $key => $value) {
			if (!isset($defaultConfig[$key])) {
				$defaultConfig[$key] = $value;
			}
		}

		return $defaultConfig;
	}
}
