# Pimweb
***
Simple, ready-to-use website skeleton built on top of our customized version of Pimcore (https://github.com/chix/pimcore).

## Installation
+ inside your project foler run `composer create-project portabucket/pimweb --repository-url=http://packages.portadesign.cz . version` (see http://packages.portadesign.cz for available versions)
+ read https://www.pimcore.org/wiki/display/PIMCORE/Installation+and+Upgrade
+ install pimcore from the browser
+ remove website/lib/Tool/Setup* installation extension files

## Help (may be outdated)
+ Generating URLs:
    - when generating URLs do not use Zend or Pimcore helpers, but Website_Tool::url and Website_Tool::docUrl methods
    - the skeleton is prepared to work both with domain based or request uri based language setup (pimweb.cz, pimweb.sk or cs.pimweb.com, sk.pimweb.com vs pimweb.com/cs, pimweb.com/sk) and for each setup it provides language switching without request uri loss (pimweb.com/cs/prihlaseni <=> pimweb.com/sk/prihlasenie)
  
    - the default setup is request uri based, in order to switch it to domain based create sites from root documents (cs, sk...) and modify static routes by applying sites to routes with "-lang" suffixes and by removing the laguage part from the request uri

+ Adding a new language mutation:
    - add the language in system settings
    - create a new document tree by copying the base language document tree root and pasting it on the root document with inheritance, recursively, updating references
    - update staticroutes, if using sites apply new site to the new tree
    - prepare the content and when ready add the new language in website settings

+ About auto-generated sitemap.xml and robots.txt
    - sitemap.xml is separete for each domain with domain based language setup
    - robots.txt is the same for each domain, because we have to place the robots.txt file in document root, otherwise pimcore throws 404, event with an explicit static route (some internal stuff overrides it)

+ About CKE editor and CSS unification with documents and objects 
    - there are some hacks in the Backend plugin for this purpose with one hard-coded dependency for main fronend CSS file, which is set to /static/css/bootstrap.min.css by default and you should change it with custom templates

+ About the built in file uploader
    - allows to set up form file upload input elements from class/object and upload them into href, image and multihref pimcore components which start with the prefix 'upload'
    - for configuration see the code :) (some configuration is pulled from field definitions and some can be set during form definition)
    - just call initFileUploads(className/object) either with a class name parameter (for new objects) or with and existing object (this allows reuploads - e.g. a photo on a user profile)
    - on fronent a file upload widget is used (one ore more files per pimcore component) and can be created via the form builder method element('uploadComponentName')
    - after validation and object creation call handleFileUploads(object) method which receives requires files, validates, creates the assets and set them to the object - it does not save the object, because errors may occur...

+ Reflecting DB schema changes done via pimcore GUI
    - basically, in website/var/classes there are .psf files which define the structure of pimcore objects, fieldcollections and objectbricks
    - so to reflect changes just move the .psf to another environment and save the class/fieldcollection/objectbrick via GUI or programaticaly

+ Reflecting DB data changes
    - this is difficult, do not put yourself in a position where you need to do this :)
    - but dumping and importing the whole DB is fine... just watch the DEFINER on views

+ Synchronizating your development environment with a running production instance
    - in website/lib/Website/Tool/Deployment there is a bash script for that
    - it is compatible with vagrant, so you can also run it from there
    - usage: set up remote.conf; set up public key base auth on the remote machine (because the script uses ssh and otherwise you would have to input your credentials several times) and you are good to go
    - vagrant will sync the ~/.ssh folder so you do not have to copy your private key

+ Migrating the whole web to another server manually
    - git clone the source
    - dump and import the DB
    - scp -r website/var/assets/* user@new.server.com:/path/to/website_root/website/var/assets/
    - scp -r website/var/classes/Object/* user@new.server.com:/path/to/website_root/website/var/classes/Object/*
    - scp website/var/config/cache.xml user@new.server.com:/path/to/website_root/website/var/config/
    - scp website/var/config/system.xml user@new.server.com:/path/to/website_root/website/var/config/ 
    - scp .htaccess user@new.server.com:/path/to/website_root/
