/* 
 * 
 * PROJECT NAME
 * Author: Martin Winkler @ PORTA DESIGN
 * url: http://www.portadesign.cz/
 * 
 */

/****************************************************************************************************************************************************************************************
DOCUMENT READY
****************************************************************************************************************************************************************************************/

var disableHashChange = false;

$(document).ready(function($){
	
/**********************************************
VARIOUS
**********************************************/
	
	// Typekit asynchronous load
	/*(function() {
   		var config = {
      		kitId: 'kitIdhere'
    	};
	    var d = false;
	    var tk = document.createElement('script');
	    tk.src = '//use.typekit.net/' + config.kitId + '.js';
	    tk.type = 'text/javascript';
	    tk.async = 'true';
	    tk.onload = tk.onreadystatechange = function() {
	      	var rs = this.readyState;
	      	if (d || rs && rs != 'complete' && rs != 'loaded') return;
	      	d = true;
	      	try { Typekit.load(config); } catch (e) {}
	    };
	    var s = document.getElementsByTagName('script')[0];
	    s.parentNode.insertBefore(tk, s);
  	})();*/

	// Gmap
	if ($.isFunction(window.initGmap)) {
		if ($('.gmap').length) {
			initGmap();
		}
	}
	
	// Scrollování ke kotvě
	$('.to-anchor').scrollToAnchor();
	
	// liteTabs
	$('.tabs').liteTabs();

	// Uniform
	$(window).on('load resizeEnd',function() {
		$('.uf').uniform();	
	});
	
	// Hints
	$('.hint').qtip({
		position: {
			my: 'bottom left',
			at: 'bottom right',
			adjust: {
				x: -20,
				y: -30
			}
		},
		style: {
			tip: {				
				width: 15,
				height: 15
			}
		}
	});

	// Show/hide
	$('.sh-trig').toggler();

/**********************************************
RESIZE END / SCROLL END
**********************************************/

	var resizeEnd;
	$(window).on('resize', function() {
		clearTimeout(resizeEnd);
		resizeEnd = setTimeout(function() {
			$(window).trigger('resizeEnd');
		}, 100);
	});

	var scrollEnd;
	$(window).on('scroll', function() {
		clearTimeout(scrollEnd);
		scrollEnd = setTimeout(function() {
			$(window).trigger('scrollEnd');
		}, 100);
	});

/**********************************************
SCROLLSPY NAVIGATION
**********************************************/

	// Fix navigation
	$(function () {
		var topMenu = $(".scrollspy");
		
		if ( topMenu.length ) {
			// Cache selectors
			var lastId,
				topMenuHeight = topMenu.outerHeight(),
				
				// All list items
				menuItems = topMenu.find("a"),
				
				// Anchors corresponding to menu items
				scrollItems = menuItems.map(function(){
					var item = $($(this).attr("href"));
					if (item.length) { return item; console.log(item) }
				});

			// Bind to scroll
			$(window).bind('load scroll', function(){
				// Get container scroll position
				var fromTop = $(this).scrollTop() + topMenuHeight + 50;
			   
				// Get id of current scroll item
				var cur = scrollItems.map(function(){
					if ($(this).offset().top < fromTop)
					return this;
				});
				// Get the id of the current element
				cur = cur[cur.length-1];
				var id = cur && cur.length ? cur[0].id : "";
			   
				if (lastId !== id) {
					lastId = id;
					// Set/remove active class
					menuItems
					.parent().removeClass("active")
					.end().filter("[href=#"+id+"]").parent().addClass("active");
				}
			});
		}
	});

/**********************************************
FLASH MESSAGES
**********************************************/
	
	// Close flash messages
	closeFM();
	
/**********************************************
FANCYBOX
**********************************************/

	defaultFancyboxConfig = {		
		width: 600,
		height: 230,
		padding: 0,
		autoSize: true,
		autoHeight: true,
		autoWidth: true,
		fitToView: false,
		openMethod: 'dropIn',
		openSpeed: 250,
		closeMethod: 'dropOut',
		closeSpeed: 150,
		tpl: {
			wrap: '<div class="fancybox-wrap" tabIndex="-1"><div class="fancybox-skin"><div class="fancybox-outer"><div class="fancybox-inner"></div></div></div></div>'
		}
	};
	
	// Fancybox
	if ($.fn.fancybox) {
		
		// Standard fancybox
		$('.fancybox').fancybox();
		
		// Custom animations
		(function ($, F) {
			// Opening animation - fly from the top
			F.transitions.dropIn = function() {
				var endPos = F._getPosition(true);

				endPos.top = (parseInt(endPos.top, 10) - 500) + 'px';
				endPos.opacity = 0;
				
				F.wrap.css(endPos).show().animate({
					top: '+=500px',
					opacity: 1
				}, {
					duration: F.current.openSpeed,
					complete: F._afterZoomIn
				});
			};

			// Closing animation - fly to the top
			F.transitions.dropOut = function() {
				F.wrap.removeClass('fancybox-opened').animate({
					top: '-=500px',
					opacity: 0
				}, {
					duration: F.current.closeSpeed,
					complete: F._afterZoomOut
				});
			};
			
			// Next gallery item - fly from left side to the center
			F.transitions.slideIn = function() {
				var endPos = F._getPosition(true);

				endPos.left = (parseInt(endPos.left, 10) - 200) + 'px';
				endPos.opacity = 0;
				
				F.wrap.css(endPos).show().animate({
					left: '+=200px',
					opacity: 1
				}, {
					duration: F.current.nextSpeed,
					complete: F._afterZoomIn
				});
			};
			
			// Current gallery item - fly from center to the right
			F.transitions.slideOut = function() {
				F.wrap.removeClass('fancybox-opened').animate({
					left: '+=200px',
					opacity: 0
				}, {
					duration: F.current.prevSpeed,
					complete: function () {
						$(this).trigger('onReset').remove();
					}
				});
			};

		}(jQuery, jQuery.fancybox));
		
		// Modal box		
		$('.modal-trigger').fancybox(defaultFancyboxConfig);
		
		// Configurable hijack popups
		$('a.configurable-hijack-trigger').each(function() {
			var active = $(this).attr('data-active');
			var hijackName = $(this).attr('data-hijack-name');
			var lastModification = $(this).attr('data-last-modification');
			var expireDays = parseInt($(this).attr('data-expire-days'));
			var delay = parseInt($(this).attr('data-delay')) * 1000;
			var cookie = hijackName + lastModification;
			var selector = this;
			
			if ( window.location.search.indexOf(hijackName) >= 0 || (active == '1' && $.cookie(cookie) != 'true') ) {
				setTimeout(function() {
					var fancyboxConfig = {};
					jQuery.extend(true, fancyboxConfig, defaultFancyboxConfig, {
						beforeClose: function() {
							if (expireDays > 0) $.cookie(cookie, 'true', { path: '/', expires: expireDays });
							else $.cookie(cookie, 'false');
						}
					});
					$(selector).fancybox(fancyboxConfig).trigger('click');
				}, delay);
			}
				
			$('.fancybox-overlay, .modal-box a').on('click', function(e) {			
				if (expireDays > 0) $.cookie(cookie, 'true', { path: '/', expires: expireDays });
				else $.cookie(cookie, 'false');

				$.fancybox.close();
			});
		});
	}
	
/**********************************************
SLIDERS
**********************************************/
	
	// Sudo slider
	if ($.fn.sudoSlider) {
		
		// Teaser slider
		$(function() {
			var i = $('.teaser-slider .panel').length;	
			if ( i > 1 ) {
				$('.teaser-slider > .slider').sudoSlider({ 
					effect: 'fade',
					vertical: false,
					auto: false,
					autowidth: false,
					continuous: true,
					prevNext: true,
					numeric: false,
					slideCount: 1,
					customLink: 'a.customLink',
					prevHtml: '<a href="#" class="prev"></a>',
					nextHtml: '<a href="#" class="next"></a>'
				});
			}
		});
	}

/**********************************************
INIT UPLOAD WIDGET (uncomment when needed)
**********************************************/
	//set up upload widget listeners
	/*
	$('body').on("change", ".upload-widget input[type=hidden][name^='edit_']", function() {
		if ($(this).val() == 1) {
			$(this).nextAll('.part-edit:first').hide();
			$(this).nextAll('.part-input:first').show();
		} else {
			$(this).nextAll('.part-input:first').hide();
			$(this).nextAll('.part-edit:first').show();
		}
	});
	$('body').on("click", ".upload-widget .edit-upload", function() {
		var edit_switch = $("input[type=hidden][name^='edit_']", $(this).closest(".upload-part"));
		edit_switch.val(1);
		edit_switch.change();
	});
	$('body').on('click', '.upload-widget .add-upload', function() {
		var widget = $(this).closest('.upload-widget');
		var first = $(".part-optional:hidden:first", widget);
		if (first.length > 0) {
			var edit_switch = $("input[type=hidden][name^='edit_']", first);
			edit_switch.val(1);
			edit_switch.change();
			var remove_switch = $("input[type=hidden][name^='remove_']", first);
			remove_switch.val(0);
			remove_switch.change();
			first.show();
			$('input[type=file]', first).click();
		}
		widget.updateUploadAddRemove();
	});
	$('body').on('click', '.upload-widget .remove-upload', function() {
		var widget = $(this).closest('.upload-widget');
		var last = $(".part-optional:visible:last", widget);
		if (last.length > 0) {
			last.hide();
			var edit_switch = $("input[type=hidden][name^='edit_']", last);
			edit_switch.val(0);
			edit_switch.change();
			var remove_switch = $("input[type=hidden][name^='remove_']", last);
			remove_switch.val(1);
			remove_switch.change();
			$("input[type=file]", last).val('');
		}
		widget.updateUploadAddRemove();
	});
	initUploadWidgets();
	*/

/**********************************************
INIT JS VALIDATION
**********************************************/

	initJsValidation();

/**********************************************
INIT AJAX 
**********************************************/

	$('body').on('click', 'a.ajax', function() {
		$(this).myAjax($(this).attr('data-to-inject'));
		return false;
	});
	$('body').on('submit', 'form.ajax', function() {
		$(this).myAjax($(this).attr('data-to-inject'));
		return false;
	});
	
/**********************************************
AFTER AJAX
**********************************************/
	
	$('body').bind('ajaxComplete', function(e, xhr, settings){
		afterAjax();
    });

/**********************************************
AUTO POPULATE FORMS
**********************************************/

	$('form[data-populate]').each(function(){
		$(this).values();
	});

/**********************************************
HASHCHANGE
**********************************************/

	$(window).hashchange( function(){
		var hash = location.hash;
		if (!disableHashChange && hash) {
			var formData = $.deparam(hash.substr(1));
			if (formData && formData.formId && $('#'+formData.formId).length) {
				$('#'+formData.formId).values(formData);
				$('#'+formData.formId).submitForm();
			} else if ($(hash).length) {
				$(hash).click();
			}
		}
		if (disableHashChange) {
			disableHashChange = false;
		}
	});
	 
	$(window).hashchange();
	
});

/****************************************************************************************************************************************************************************************
FUNCTIONS
****************************************************************************************************************************************************************************************/

// Close Flash message
function closeFM() {
	$('body').delegate('.flash-message .close', 'click', function() {
		$(this).closest('.flash-message').fadeOut();
		return false;
	});

	if ( $('.flash-message').length ) {
		setTimeout(function() {
			$('.flash-message' + '[data-hide="fade"]').fadeOut();
			$('.flash-message' + '[data-hide="slide"]').animate({'top': '-100'}, 200, function() {
				$('.flash-message' + '[data-hide="slide"]').hide();
			});
		}, 5000 );
	}
}

// Univerzální show/hide 
(function($) {
	$.fn.toggler = function (settings) {
		
		settings = jQuery.extend({
			showSpeed: 100,
			hideSpeed: 100,
			hideTrigger: false,
			slide: false,
			scrollToContent: false,
			offsetScroll: 0,
			hideOnDocumentClick: false,
			documentClickElement: '',
			hideOnEscape: false
		}, settings);

		$(this).each(function() {

			var trigger = $(this),
				content = $('#' + trigger.data('content'));
			
			// Radio nebo checkbox
			if ( trigger.is(':radio') || trigger.is(':checkbox') ) {
				var name = trigger.attr('name');

				$('[name=' + name + ']').on('change', function() {
					content.hide();
				});
				trigger.on('change', function() {
					if ( $(this).is(':checked') ) {						
						content.fadeIn(settings.showSpeed);
					}
					else {
						content.hide();
					}
				});
				$(window).on('load',function() {
					if ( trigger.is(':checked') ) {						
						content.fadeIn(settings.showSpeed);
					}
				});
			}
			// Standardní element
			else {
				function scrollToContent() {
					var offset = 0;
					if ( settings.offsetScroll ) {
						offset = settings.offsetScroll
					}
					$("html:not(:animated),body:not(:animated)").animate({ scrollTop: $(content).offset().top + offset }, 500, function() {
						//window.location.hash = content.attr('id');
					});
				}

				function scrollToTrigger() {
					var offset = 0;
					if ( settings.offsetScroll ) {
						offset = settings.offsetScroll + 200
					}
					$("html:not(:animated),body:not(:animated)").animate({ scrollTop: $('[data-content=' + trigger.attr('data-content') + ']').offset().top + offset }, 500, function() {
						//window.location.hash = content.attr('id');
					});
				}

				trigger.on('click',function() {
					if ( content.is(':hidden') ) {
						if ( settings.slide ) {
							content.slideDown(settings.showSpeed,function() {
								if ( settings.scrollToContent ) {
									scrollToContent();
								};
							});
						}
						else {
							content.fadeIn(settings.showSpeed,function() {
								if ( settings.scrollToContent ) {
									scrollToContent();
								};
							});
						}

						$(this).addClass('active').find('.text').text( $(this).attr('data-less') );
						
						if ( settings.hideTrigger ) {
							trigger.hide();
						}
					}
					else {
						if ( settings.slide ) {
							content.slideUp(settings.hideSpeed,function() {
								if ( settings.scrollToContent ) {
									scrollToTrigger();
								};
							});							
						}
						else {
							content.fadeOut(settings.hideSpeed,function() {
								if ( settings.scrollToContent ) {
									scrollToTrigger();
								};
							});							
						}
						$(this).removeClass('active').find('.text').text( $(this).attr('data-more') );

						if ( settings.hideTrigger ) {
							$('[data-content=' + trigger.attr('data-content') + ']').fadeIn(settings.hideSpeed);
						}
					}
					return false;			
				});
			}
			// Hide on document click
			if ( settings.hideOnDocumentClick ) {
				$(document).bind('click',function(e) {
					if ( ! $(settings.documentClickElement).is(e.target) && $(settings.documentClickElement).has(e.target).length === 0) {
						content.fadeOut();
					}
				});
			}
			// Escape button
			if ( settings.hideOnEscape ) {
				$(document).keyup(function(e){
					if (e.keyCode === 27) {
						content.fadeOut();
					}
				});
			}
		});
	}
})(jQuery);

// Lite tabs (záložkové menu)
(function($) {

	$.fn.liteTabs = function(options) {
	    
	    return this.each(function() {

    		var defaults = {
    			borders : false,
    			boxed : false,
    			fadeIn : false,
    			height : 'auto',
    			hideHash : false,
    			hashTag : true,
    			selectedTab : 1,
    			width : 500		
    		},
		
    		// merge defaults with options in new settings object
    		settings = $.extend({}, defaults, options),
				
    		// define key variables
    		$this = $(this),
    		$ul = $this.find('.tab-nav').first(),
    		$tab = $ul.find('a'),
    		$tabSwitch = $this.find('.tab-switch'),
    		$div = $this.find('.tab-content').first().find('.tab');

    		// option: set overall height
    		$div.css({
    			position : 'absolute',
    			left : -9999
    		});			
			
			// on tab click...
    		$tab.click(function(e) {
    			var selectedPanel = $div.filter('[name=' + this.hash + ']');
    			var filterHash = $div.removeClass('selected').filter('[name=' + this.hash + ']');
			
    			// defaults: add selected class to tab
    			$tab.removeClass('selected').filter(this).addClass('selected');
    			
    			// Rodičovská záložka zůstane otevřená při kliku na vnořené záložky v záložce
    			var parentId = $tab.filter(this).closest('.tab').attr('name');
    			$('.tab[name="' + parentId + '"]').addClass('selected');    			
    			$('.tab-nav a[href="' + parentId + '"]').addClass('selected');

    			if ($tab.parents('.tabs').length > 1 ) {
    				e.preventDefault();
    			} 

				// Otevře první vnořenou záložku
				selectedPanel.find('.tab-nav').find('li').first().find('a').click();				

    			// option: fade in divs
    			(settings.fadeIn) ? filterHash.hide().addClass('selected').fadeIn() : filterHash.addClass('selected');

    			// option: hide hash change
    			if (settings.hideHash) {
    				e.preventDefault();
    			}    			
    		});	
			
			$tabSwitch.click(function(e) {
    			var filterHash = $div.removeClass('selected').filter('[name=' + this.hash + ']');
			
    			// defaults: add selected class to tab
    			$tabSwitch.removeClass('selected').filter(this).addClass('selected');

    			// option: fade in divs
    			(settings.fadeIn) ? filterHash.hide().addClass('selected').fadeIn() : filterHash.addClass('selected');

    			// option: hide hash change
    			settings.hideHash && e.preventDefault();
    		});	

    		// option: set selected tab
    		if (settings.selectedTab) {
    		 	$tab.eq(settings.selectedTab - 1).addClass('selected');
    		 	$div.eq(settings.selectedTab - 1).addClass('selected');
    		}
			
			// If hash tag..
			var hash = window.location.hash.substring(1);
			$('[href="#' + hash + '"]').click();			
	    });
		
	};

})(jQuery);

// Plynulý scroll ke kotvě
(function($) {
	$.fn.scrollToAnchor = function(settings) {

		settings = jQuery.extend({
			speed : 500
		}, settings);	
		
		return this.each(function(){
			var caller = this
			$(caller).click(function (event) {	
				event.preventDefault()
				var locationHref = window.location.href
				var elementClick = $(caller).attr("href")
				
				var destination = $(elementClick).offset().top;
				
				$("html:not(:animated),body:not(:animated)").animate({ scrollTop: destination}, settings.speed, function() {				
					history.pushState(null, null, elementClick)
				});
				return false;
			});
		});
	}
})(jQuery);

// Loader counter
$(function() {
	var total =  $('.counter').data('total'),
		subscribed =  $('.counter').data('subscribed'),
		elW = (subscribed/total)*100;
	
	$('.counter').find('.load').animate(
		{width: elW+'%'}, {
			duration: 2000,
			step: function(now, fx) {
			   if(fx.prop == 'width') {
				   $(this).find('.num').html(Math.round(now / 100 * total));
				   $('.counter .remains').html(Math.round(total - (now / 100 * total)));
			   }
			}
		}
	);
});

// Zobrazení elementu ve viewportu
function inViewport(el) {
	var elH = $(el).height(),
		elTop = $(el).offset().top;
		scrollTop = $(window).scrollTop(),
		winH = $(window).height();
		fixedHeaderH = 0; // výška fixní hlavičky
		
	return ( (elTop + elH) > (scrollTop + fixedHeaderH ) && (scrollTop - elH) > (elTop - winH) );	
}

// Timer od 0
(function($) {
    $.fn.countTo = function(options) {
        options = $.extend({}, $.fn.countTo.defaults, options || {});
		
        var loops = Math.ceil(options.speed / options.refreshInterval)
		
		$(this).each(function() {
            var _this = this,
                loopCount = 0,
                value = options.from,
                interval = setInterval(updateTimer, options.refreshInterval),
				amount = $(this).data('amount'),
				increment = (amount - options.from) / loops,
				plus = ''
				if ( $(this).data('plus') == true ) {
					var plus = '<span class="plus">+</span>'
				}

            function updateTimer() {
                value += increment;
                loopCount++;
                $(_this).html(value.toFixed(options.decimals) + plus);

                if (typeof(options.onUpdate) == 'function') {
                    options.onUpdate.call(_this, value);
                }

                if (loopCount >= loops) {
                    clearInterval(interval);
                    value = amount;

                    if (typeof(options.onComplete) == 'function') {
                        options.onComplete.call(_this, value);
                    }
                }
            }
        });
    };

    $.fn.countTo.defaults = {
        from: 0,        
        speed: 1000,
        refreshInterval: 100,
        decimals: 0,
        onUpdate: null,
        onComplete: null
    };
})(jQuery);

//submit form via JS, allows injection or change of values
$.fn.submitForm = function(toInject) {
	if (typeof toInject === 'object') {
		for (var key in toInject) {
			//change a value if element exits
			if ($("input[name='"+key+"']", this).length > 0) {
				$("input[name='"+key+"']", this).val(toInject[key]);
			} else {//or insert a new one if it doesn't
				if (toInject.hasOwnProperty(key)) {
					$('<input>').attr({
						type: 'hidden',
						id: key,
						name: key,
						value: toInject[key]
					}).appendTo(this);
				}
			}
		}
	}

	//remove empty parameters on get submission
	if ($(this).attr('method').toLowerCase() == 'get') {
		//remove empty fields
		$('input, select', this).map(function() {
			if (!$(this).val()) {
				$(this).attr('disabled', 'disabled');
			}
		});
		//remove zend checkbox shadow
		$('input[type=hidden][value="0"]', this).attr("disabled", "disabled");
	}

	$(this).submit();
};

/* jQuery.values: get or set all of the name/value pairs from child input controls   
 * @argument data {array} If included, will populate all child controls.
 * @argument inputPrefix {string} If included, will prefix all inputs and uppercase the first char
 * @returns element if data was provided, or array of values if not
*/
$.fn.values = function(data, inputPrefix) {
	var els = $(this).find(':input').get();

	//if data and inputPrefix are not passed we try to read them from the data-populate and data-populate-prefix attributes
	if (typeof data != 'undefined') {
		if (typeof data != 'object') {
			data = JSON.parse(data);
		}
	} else {
		var dataAttr = $(this).attr('data-populate');
		if (typeof dataAttr != "undefined") {
			data = JSON.parse(dataAttr);
			if (typeof data != 'object') {
				data = JSON.parse(data);
			}
		}
	}
	if (typeof inputPrefix == 'undefined') {
		inputPrefix = $(this).attr('data-populate-prefix');
	}

	if(typeof data == 'undefined') {
		// return all data
		data = {};

		$.each(els, function() {
			//var inputName = (typeof inputPrefix == 'string') ? (inputPrefix + this.name.charAt(0).toUpperCase() + this.name.slice(1)) : this.name;
			var multiCheckbox = (this.type == 'checkbox' && this.name.indexOf("[]") > -1);
			if (this.name && !this.disabled && (this.checked || /select|textarea/i.test(this.nodeName) || /text|hidden|password/i.test(this.type))) {
				if (multiCheckbox) {
					if (data[this.name] == undefined) data[this.name] = [];
					data[this.name].push($(this).val());
				} else {
					data[this.name] = $(this).val();
				}
			}
		});
		return data;
	} else {
		$.each(els, function() {
			var key = this.name;
			var isMultiCheckbox = (this.type == 'checkbox' && key.indexOf("[]") > -1);
			if (isMultiCheckbox) {
				key = key.replace("[]", '');
			}
			if (typeof inputPrefix == 'string') {
				key = key.replace(inputPrefix, '');
				key = key.charAt(0).toLowerCase() + key.slice(1);
			}
			if (this.name && data[key]) {
				if (isMultiCheckbox) {
					$(this).attr("checked", ($.inArray($(this).val(), data[key]) >= 0));
				} else if (this.type == 'checkbox' || this.type == 'radio') {
						$(this).attr("checked", (data[key] == $(this).val()));
				} else {
					$(this).val(data[key]);
				}
			}
		});
		return $(this);
	}
};

/*
  jQuery deparam is an extraction of the deparam method from Ben Alman's jQuery BBQ
  http://benalman.com/projects/jquery-bbq-plugin/
*/
(function ($) {
  $.deparam = function (params, coerce) {
    var obj = {},
        coerce_types = { 'true': !0, 'false': !1, 'null': null };
      
    // Iterate over all name=value pairs.
    $.each(params.replace(/\+/g, ' ').split('&'), function (j,v) {
      var param = v.split('='),
          key = decodeURIComponent(param[0]),
          val,
          cur = obj,
          i = 0,
            
          // If key is more complex than 'foo', like 'a[]' or 'a[b][c]', split it
          // into its component parts.
          keys = key.split(']['),
          keys_last = keys.length - 1;
        
      // If the first keys part contains [ and the last ends with ], then []
      // are correctly balanced.
      if (/\[/.test(keys[0]) && /\]$/.test(keys[keys_last])) {
        // Remove the trailing ] from the last keys part.
        keys[keys_last] = keys[keys_last].replace(/\]$/, '');
          
        // Split first keys part into two parts on the [ and add them back onto
        // the beginning of the keys array.
        keys = keys.shift().split('[').concat(keys);
          
        keys_last = keys.length - 1;
      } else {
        // Basic 'foo' style key.
        keys_last = 0;
      }
        
      // Are we dealing with a name=value pair, or just a name?
      if (param.length === 2) {
        val = decodeURIComponent(param[1]);
          
        // Coerce values.
        if (coerce) {
          val = val && !isNaN(val)              ? +val              // number
              : val === 'undefined'             ? undefined         // undefined
              : coerce_types[val] !== undefined ? coerce_types[val] // true, false, null
              : val;                                                // string
        }
          
        if ( keys_last ) {
          // Complex key, build deep object structure based on a few rules:
          // * The 'cur' pointer starts at the object top-level.
          // * [] = array push (n is set to array length), [n] = array if n is 
          //   numeric, otherwise object.
          // * If at the last keys part, set the value.
          // * For each keys part, if the current level is undefined create an
          //   object or array based on the type of the next keys part.
          // * Move the 'cur' pointer to the next level.
          // * Rinse & repeat.
          for (; i <= keys_last; i++) {
            key = keys[i] === '' ? cur.length : keys[i];
            cur = cur[key] = i < keys_last
              ? cur[key] || (keys[i+1] && isNaN(keys[i+1]) ? {} : [])
              : val;
          }
            
        } else {
          // Simple key, even simpler rules, since only scalars and shallow
          // arrays are allowed.
            
          if ($.isArray(obj[key])) {
            // val is already an array, so push on the next value.
            obj[key].push( val );
              
          } else if (obj[key] !== undefined) {
            // val isn't an array, but since a second value has been specified,
            // convert val into an array.
            obj[key] = [obj[key], val];
              
          } else {
            // val is a scalar.
            obj[key] = val;
          }
        }
          
      } else if (key) {
        // No value was defined, so set something meaningful.
        obj[key] = coerce
          ? undefined
          : '';
      }
    });
      
    return obj;
  };
})(jQuery);

//send form or href click via ajax
//on forms allows injection or change of values
$.fn.myAjax = function(toInject) {
	var url = null;
	var requestData = null;
	var form = null;
	if (this.prop('tagName').toLowerCase() == 'form') {
		form = this.closest('form')
		url = form.attr('action');
		if (typeof toInject === 'object') {
			for (var key in toInject) {
				//change a value if element exits
				if ($("input[name='"+key+"']", form).length > 0) {
					$("input[name='"+key+"']", form).val(toInject[key]);
				} else {//or insert a new one if it doesn't
					if (toInject.hasOwnProperty(key)) {
						$('<input>').attr({
							type: 'hidden',
							id: key,
							name: key,
							value: toInject[key]
						}).appendTo(form);
					}
				}
			}
		}
		requestData = form.serializeArray();
		if (form.prop('enctype') == 'multipart/form-data') {
			var formData = new FormData();
			for (var p in requestData) {
				formData.append(requestData[p].name, requestData[p].value);
			}
			jQuery.each($('input[type=file]', form), function(i, input) {
				if (input.files.length) {
					formData.append(input.name, input.files[0]);
				}
			});	
			requestData = formData;
		}
		if (this.attr('data-persist-to-hash')) {
			disableHashChange = true;
			//remove empty fields
			$('input, select', this).map(function() {
				if (!$(this).val()) {
					$(this).attr('disabled', 'disabled');
				}
			});
			//remove zend checkbox shadow
			$('input[type=hidden][value="0"]', this).attr("disabled", "disabled");
			//add formId element with id value
			$('<input>').attr({type: 'hidden', name: 'formId', value:this.attr('id')}).appendTo(form);

			window.location.hash = '#'+$.param($('#'+this.attr('id')).values());
		}
	} else {
		url = this.attr('href');
		requestData = toInject;
		if (this.attr('data-persist-to-hash') && this.attr('id')) {
			disableHashChange = true;
			window.location.hash = '#'+this.attr('id');
		}
	}

	$('.loader-overlay').show();

	var ajaxOptions = {
		url: url,
		type: (form == null) ? 'GET' : 'POST',
		data: requestData
	}
	if (form && form.prop('enctype') == 'multipart/form-data') {
		ajaxOptions.contentType = false;
		ajaxOptions.processData = false;
		ajaxOptions.cache = false;
	}

	var hideLoader = true;
	$.ajax(ajaxOptions).done(function(responseData) {
		//handle snippets
		var popup = null;
		for(var key in responseData.snippets) {
			switch(responseData.snippets[key].type) {
				case 'element': {
					$(key).html(responseData.snippets[key].body);
				} break;
				case 'element-append': {
					$(key).append(responseData.snippets[key].body);
				} break;
				case 'popup': {
					popup = responseData.snippets[key].body;
				} break;
				case 'popup-close': {
					$.fancybox.close();	
				} break;
				case 'redirect': {
					document.location.href = responseData.snippets[key].body;
					hideLoader = false;
				} break;
				case 'redirect-ajax': {
					var url = responseData.snippets[key].body;
					var trigger = $('<a href="'+url+'" class="ajax"></a>').appendTo('body');
					trigger.click();
					trigger.remove();
					hideLoader = false;
				} break;
				case 'remove': {
					if (typeof responseData.snippets[key].body === 'object') {
						for (var index in responseData.snippets[key].body) {
							$(responseData.snippets[key].body[index]).remove();
						}
					} else {
						$(responseData.snippets[key].body).remove();
					}
				} break;
				case 'populate': {
					if ($(key).length && $(key).is('form')) {
						$(key).values(responseData.snippets[key].body['data'], responseData.snippets[key].body['prefix']);
						if ($(key).attr('data-js-validation')) {
							$(key).valid();
						}
					}
				} break;
			}
			//reload on null snippet
			//if (responseData[key] == null) window.location.reload();
		}
		//check if there was a popup
		if (popup != null) {
			$('.loader-overlay').hide();
			var tmp = $.fancybox.open(popup, defaultFancyboxConfig);
		}
	}).fail(function() {
		alert('That is an error.');
	}).always(function() {
		afterAjax();
		if (hideLoader) {
			$('.loader-overlay').hide();
		}
	});
}

//initializes validate.js rules from Zend backend validation rules in data attributes
function initJsValidation()
{
	$('form').each(function() {
		if ($(this).attr('data-validation-initialized')) return;

		if ($(this).attr('data-js-validation')) {
			var messages = {};
			var errorWrapperSelector = $(this).attr('data-error-wrapper-selector');
			var errorWrapperClass = $(this).attr('data-error-wrapper-class');
			$('input[data-error-messages], textarea[data-error-messages], checkbox[data-error-messages], select[data-error-messages]', this).each(function() {
				messages[$(this).attr('name')] = JSON.parse($(this).attr('data-error-messages'));
			});
			//additional rules
			var rules = {};
			$('*', this).filter(':input').each(function() {
				if ($(this).attr('id') == undefined) return;
				var depends = $(this).attr('depends');
				if (depends != undefined)
					depends = JSON.parse(depends);
				else return;
				
				var dependentValSelectors = [];
				if (!Array.isArray(depends.key)) depends.key = [depends.key];

				for (var i in depends.key) {
					var key = depends.key[i];
					var dependentElement = $('*[name="'+key+'"]:visible'); //visible because of zend checkboxes...
					var dependentValSelector = (dependentElement.attr('type') == 'radio') ? 'input[name="'+key+'"]:checked' : '#'+key;
					dependentValSelectors.push(dependentValSelector);
				}
				var elementId = $(this).attr('id');
				rules[elementId] = {
					required: {
						depends: function() {
							for (var i in dependentValSelectors) {
								if ($(dependentValSelectors[i]).val() == depends.value) return true;
							}
							return false;
						}
					}
				};
				if (depends.hasOwnProperty('additionalValidators')) {
					for (var i in depends.additionalValidators) {
						rules[elementId][i] = depends.additionalValidators[i];
					}
				}
			});
			$(this).validate({
				'errorClass': $(this).attr('data-error-class'),
				'errorElement': $(this).attr('data-error-element'),
				errorPlacement: function(error, element) {
					$('.error-placement-wrapper[data-element-id=' + element.attr('id') + ']').html(error);
				},
				highlight: function(element) {
					if (errorWrapperSelector && errorWrapperClass) {
						$(element).closest(errorWrapperSelector).addClass(errorWrapperClass);
					}
				},
				unhighlight: function(element) {
					if (errorWrapperSelector && errorWrapperClass) {
						$(element).closest(errorWrapperSelector).removeClass(errorWrapperClass);
					}
					$('.error-placement-wrapper[data-element-id=' + element.id + ']').empty();
				},
				'messages': messages,
				rules: rules,
				submitHandler: function(form) {
					//prevent multiple form submissions
					if (!$(form).attr('data-form-submitted') || $(this).attr('data-allow-multiple-submissions')) {
						$(form).attr('data-form-submitted', '1');
						if ($(form).hasClass('ajax')) {
							$(form).myAjax($(form).attr('data-to-inject'));
						} else {
							form.submit();
						}
					}
				}
			});
			$(this).attr('data-validation-initialized', '1');
		} else {
			//prevent multiple form submissions on no-js-validated forms
			if (!$(this).hasClass('ajax') && !$(this).attr('data-allow-multiple-submissions')) {
				$(this).submit(function() {
					if (!$(this).attr('data-form-submitted')) {
						$(this).attr('data-form-submitted', '1');
						this.submit();
						return true;
					} else {
						return false;
					}
				});
			}
		}
	});
}

//upload widget init functions
$.fn.updateUploadAddRemove = function() {
	if ($('.part-optional:hidden', this).length == 0) {
		$(".add-upload", this).hide();
	} else {
		$(".add-upload", this).show();
	}

	if ($('.part-optional:visible', this).length == 0) {
		$(".remove-upload", this).hide();
	} else {
		$(".remove-upload", this).show();
	}
}
function initUploadWidgets()
{
	//form sections switches init
	$(".upload-widget input[type=hidden][name^='edit_']").each(function() {
		$(this).change();
	});
	$(".upload-widget").each(function() {
		$(this).updateUploadAddRemove();
	});
}

function afterAjax()
{
	//initUploadWidgets();

	initJsValidation();

	// Stejná výška elementů
	$(window).resize();
	
	// Close FM
	closeFM();
}
