<?php

namespace Website\Form;

class PasswordResetForm extends Base {
	
	public function init()
	{
		parent::init();
		$this->setName('password-reset');
		
		//elements
		$email = new \Zend_Form_Element_Text('email');
		$email->setRequired(true)
			->setLabel('label_email')
			->addFilter('StripTags')
			->addFilter('StringTrim')
			->addValidator($this->notEmptyValidator)
			->addValidator($this->emailValidator);
		
		$formName = new \Zend_Form_Element_Hidden('formName');
		$formName->setValue($this->getName());
		
		$submit = new \Zend_Form_Element_Button('send');
		$submit->setLabel('label_reset_password')
			->setAttrib('type', 'submit');
		
		$this->addElements(array(
			$email,
			$formName,
			$submit
		));
				
		//remove decorators
		$this->setElementDecorators(array('ViewHelper'));

		$this->setUpJsValidation();
	}
}
