<?php

namespace Website\Model;

class NewsletterManager
{

	const ROOT_FOLDER_ID = 6;

	public function addNewsletter($data)
	{
		//check if exists
		if (count(\Pimcore\Model\Object\NewsletterForm::getByEmail($data['email']))) {
			return true; //no error msg needed
		}
		$data['unsubscribeCode'] = uniqid();
		//create
		$newsletter = \Pimcore\Model\Object\NewsletterForm::create($data);
		$newsletter->setCreationDate(time());
		$newsletter->setKey(\Pimcore\File::getValidFilename($data['email']));
		$newsletter->setParentId(self::ROOT_FOLDER_ID);
		$newsletter->setPublished(true);
		//crm stuff (not used)
		$newsletter->setFirstname('');
		$newsletter->setLastname('');
		$newsletter->setGender('');
		$newsletter->setNewsletterActive(true);
		$newsletter->setNewsletterConfirmed(true);
		try {
			$newsletter->save();
		} catch (\Exception $e) {
			\Pimcore\Log\Simple::log('exceptions', 'NEWSLETTER SUBSCRIBE - ' . $e->getMessage() . "\n" . $e->getTraceAsString());
			return false;
		}

		$mailManager = new \Website\Model\MailManager();
		$helper = new \Zend_View_Helper_ServerUrl();
		$mailManager->sendMail(
				\Pimcore\Model\Document\Email::getByPath('/' . $data['lang'] . '/notifikace/newsletter'), $data['email'], null, array(
					'unsubscribeUrl' => $helper->serverUrl() . \Website\Tool\Utils::url('newsletter-unsubscribe', array('language' => $data['lang'], 'code' => $data['unsubscribeCode']))
				)
		);

		return true;
	}

	public function unsubscribe($code)
	{
		$object = \Pimcore\Model\Object\NewsletterForm::getByUnsubscribeCode($code)->current();
		if ($object instanceof \Pimcore\Model\Object\NewsletterForm) {
			try {
				$email = $object->getEmail();
				$object->delete();

				return $email;
			} catch (\Exception $e) {
				\Pimcore\Log\Simple::log('exceptions', 'NEWSLETTER UNSUBSCRIBE - ' . $e->getMessage() . "\n" . $e->getTraceAsString());
				$this->addErrorMsg($this->translate('msg_unknown_error'));
			}
		} else {
			return false;
		}

		return null;
	}

}
