<?php

/**
 * pimcore installator extension
 * 
 * @author Martin Kuric <martin.kuric@portadesign.cz>
 */

namespace Website\Tool;

class Setup extends \Pimcore\Model\Tool\Setup 
{
	private $db;

	public function __construct() {
		$this->db = \Pimcore\Db::getConnection();
	}

    public function config($config = array()) {
        // write configuration file
        $settings = array(
            "general" => array(
                "timezone" => "Europe/Prague",
                "php_cli" => "",
                "domain" => "",
                "redirect_to_maindomain" => "",
                "language" => "en",
                "validLanguages" => "cs",
                "fallbackLanguages" => array(
                    "cs" => ""
                ),
                "defaultLanguage" => "",
                "theme" => "",
                "contactemail" => "",
                "extjs6" => "1",
                "loginscreencustomimage" => "",
                "disableusagestatistics" => "",
                "debug" => "1",
                "debug_ip" => "127.0.0.1,90.180.56.75,90.179.155.74",
                "http_auth" => array(
                    "username" => "",
                    "password" => ""
                ),
                "custom_php_logfile" => "1",
                "environment" => "",
                "debugloglevel" => "error",
                "disable_whoops" => "1",
                "debug_admin_translations" => "",
                "devmode" => "",
                "logrecipient" => "",
                "viewSuffix" => "",
                "instanceIdentifier" => "",
                "show_cookie_notice" => ""
            ),
            "database" => array(
                "adapter" => "Mysqli",
                "params" => array(
                    "host" => "localhost",
                    "username" => "root",
                    "password" => "",
                    "dbname" => "",
                    "port" => "3306",
                )
            ),
            "documents" => array(
                "versions" => array(
                    "days" => "",
                    "steps" => "5"
                ),
                "default_controller" => "default",
                "default_action" => "default",
                "error_pages" => array(
                    "default" => "/system/chybova-stranka"
                ),
                "createredirectwhenmoved" => "",
                "allowtrailingslash" => "no",
                "allowcapitals" => "no",
                "generatepreview" => "",
                "wkhtmltoimage" => "",
                "wkhtmltopdf" => ""
            ),
            "objects" => array(
                "versions" => array(
                    "days" => "",
                    "steps" => "5"
                )
            ),
            "assets" => array(
                "webdav" => array(
                      "hostname" => ""
                ),
                "versions" => array(
                    "days" => "",
                    "steps" => "0"
                ),
                "ffmpeg" => "",
                "ghostscript" => "",
                "libreoffice" => "",
                "pngcrush" => "",
                "imgmin" => "",
                "jpegoptim" => "",
                "pdftotext" => "",
                "icc_rgb_profile" => "",
                "icc_cmyk_profile" => "",
                "hide_edit_image" => ""
            ),
            "services" => array(
                "translate" => array(
                    "apikey" => ""
                ),
                "google" => array(
                    "client_id" => "",
                    "email" => "",
                    "simpleapikey" => "",
                    "browserapikey" => ""
                )
            ),
            "cache" => array(
                "enabled" => "",
                "lifetime" => "",
                "excludePatterns" => "",
                "excludeCookie" => ""
            ),
            "outputfilters" => array(
                "less" => "",
                "lesscpath" => ""
            ),
            "webservice" => array(
                "enabled" => ""
            ),
            "httpclient" => array(
                "adapter" => "Zend_Http_Client_Adapter_Socket",
                "proxy_host" => "",
                "proxy_port" => "",
                "proxy_user" => "",
                "proxy_pass" => ""
            ),
            "applicationlog" => array(
                "mail_notification" => array(
                    "send_log_summary" => "",
                    "filter_priority" => "",
                    "mail_receiver" => ""
                ),
                "archive_treshold" => "30",
                "archive_alternative_database" => ""
            ),
            "email" => array(
                "sender" => array(
                    "name" => "",
                    "email" => "noreply@vm3.portadesign.cz"
                ),
                "return" => array(
                    "name" => "",
                    "email" => ""
                ),
                "method" => "sendmail",
                "smtp" => array(
                    "host" => "",
                    "port" => "",
                    "ssl" => "",
                    "name" => "",
                    "auth" => array(
                        "method" => "",
                        "username" => "",
                        "password" => ""
                    )
                ),
                "debug" => array(
                    "emailaddresses" => "noreply@portadesign.cz"
                ),
                "bounce" => array(
                    "type" => "",
                    "maildir" => "",
                    "mbox" => "",
                    "imap" => array(
                        "host" => "",
                        "port" => "",
                        "username" => "",
                        "password" => "",
                        "ssl" => ""
                    )
                )
            ),
            "newsletter" => array(
                "sender" => array(
                    "name" => "",
                    "email" => ""
                ),
                "return" => array(
                    "name" => "",
                    "email" => ""
                ),
                "method" => "",
                "smtp" => array(
                    "host" => "",
                    "port" => "",
                    "ssl" => "",
                    "name" => "",
                    "auth" => array(
                        "method" => "",
                        "username" => "",
                        "password" => ""
                    )
                ),
                "usespecific" => ""
            )
        );

        $settings = array_replace_recursive($settings, $config);

        // create initial /website/var folder structure
        // @TODO: should use values out of startup.php (Constants)
        $varFolders = array("areas","assets","backup","cache","classes","config","email","log","plugins","recyclebin","search","system","tmp","versions","webdav");
        foreach($varFolders as $folder) {
            \Pimcore\File::mkdir(PIMCORE_WEBSITE_VAR . "/" . $folder);
        }

        $config = new \Zend_Config($settings, true);
        $writer = new \Zend_Config_Writer_Xml(array(
            "config" => $config,
            "filename" => PIMCORE_CONFIGURATION_SYSTEM
        ));
        $writer->write();
    }

    public function cacheConfig($config = array())
    {
        $settings = array(
            "frontend" => array(
                "type" => "Core",
                "options" => array(
                    "cache_id_prefix" => "websitename_",
                    "lifetime" => "99999",
                    "automatic_serialization" => "true"
                )
            ),
            "backend" => array(
                "type" => "\Pimcore\Cache\Backend\Redis2",
                "custom" => "true",
                "options" => array(
                    "server" => "127.0.0.1",
                    "port" => "6379",
                    "persistent" => "1",
                    "database" => "1",
                    "use_lua" => "1"
                )
            )
        );

        $settings = array_replace_recursive($settings, $config);

        $config = new \Zend_Config($settings, true);
        $writer = new \Zend_Config_Writer_Xml(array(
            "config" => $config,
            "filename" => PIMCORE_CONFIGURATION_DIRECTORY.'/cache.xml'
        ));
        $writer->write();
    }

    public function databaseExtension()
	{

        $mysqlInstallScript = file_get_contents(PIMCORE_WEBSITE_PATH . "/tools/Setup/install_extension.sql");

        // get every command as single part
        $mysqlInstallScripts = explode(";",$mysqlInstallScript);

        // execute every script with a separate call, otherwise this will end in a PDO_Exception "unbufferd queries, ..." seems to be a PDO bug after some googling
        foreach ($mysqlInstallScripts as $m) {
            $sql = trim($m);
            if(strlen($sql) > 0) {
                $sql .= ";";
                $this->db->query($m);
            }
        }

        // reset the database connection
        \Pimcore\db::reset();
    }

	public function databaseExtensionContents()
	{
		$time = time();

		$dbExtension = array(
			'assets' => array(
				'schema' => array('id', 'parentId', 'type', 'filename', 'path', 'mimetype', 'creationDate', 'modificationDate', 'userOwner', 'userModification', 'customSettings', 'hasMetaData'),
				'data' => array(
					4, 1, 'folder', 'novinky', '/', NULL, $time, $time, 2, 2, 'a:0:{}', 0,
					5, 4, 'folder', 'galerie', '/novinky/', NULL, $time, $time, 2, 2, 'a:0:{}', 0,
					6, 1, 'folder', 'dokumenty', '/', NULL, $time, $time, 2, 2, 'a:0:{}', 0
				)
			),
			'classes' => array(
				'schema' => array('id', 'name', 'description', 'creationDate', 'modificationDate', 'userOwner', 'userModification', 'allowInherit', 'allowVariants', 'parentClass', 'useTraits', 'icon', 'previewUrl', 'propertyVisibility', 'showVariants'),
				'data' => array(
					4, 'News', '', $time, $time, 2, 2, 0, 0, '', NULL, '/pimcore/static/img/icon/newspaper.png', '/cs/aktuality/%o_id-%slug', 'a:2:{s:4:"grid";a:5:{s:2:"id";b:1;s:4:"path";b:1;s:9:"published";b:1;s:16:"modificationDate";b:1;s:12:"creationDate";b:1;}s:6:"search";a:5:{s:2:"id";b:1;s:4:"path";b:1;s:9:"published";b:1;s:16:"modificationDate";b:1;s:12:"creationDate";b:1;}}', 0,
					5, 'ContactForm', '', $time, $time, 2, 2, 0, 0, '', NULL, '/pimcore/static/img/icon/email.png', '', 'a:2:{s:4:"grid";a:5:{s:2:"id";b:0;s:4:"path";b:1;s:9:"published";b:0;s:16:"modificationDate";b:0;s:12:"creationDate";b:1;}s:6:"search";a:5:{s:2:"id";b:0;s:4:"path";b:1;s:9:"published";b:0;s:16:"modificationDate";b:0;s:12:"creationDate";b:1;}}', 0,
					6, 'NewsletterForm', '', $time, $time, 2, 2, 0, 0, '', NULL, '/pimcore/static/img/icon/email.png', '', 'a:2:{s:4:"grid";a:5:{s:2:"id";b:1;s:4:"path";b:1;s:9:"published";b:1;s:16:"modificationDate";b:1;s:12:"creationDate";b:1;}s:6:"search";a:5:{s:2:"id";b:1;s:4:"path";b:1;s:9:"published";b:1;s:16:"modificationDate";b:1;s:12:"creationDate";b:1;}}', 0,
					10, 'User', '', $time, $time, 2, 2, 0, 0, '', NULL, '/pimcore/static/img/icon/user.png', '', 'a:2:{s:4:"grid";a:5:{s:2:"id";b:1;s:4:"path";b:1;s:9:"published";b:1;s:16:"modificationDate";b:1;s:12:"creationDate";b:1;}s:6:"search";a:5:{s:2:"id";b:1;s:4:"path";b:1;s:9:"published";b:1;s:16:"modificationDate";b:1;s:12:"creationDate";b:1;}}', 0
				)
			),
			'documents' => array(
				'schema' => array('id', 'parentId', 'type', 'key', 'path', 'index', 'published', 'creationDate', 'modificationDate', 'userOwner', 'userModification'),
				'data' => array(
					2, 1, 'page', 'cs', '/', 0, 1, $time, $time, 2, 2,
					3, 1, 'folder', 'system', '/', 2, 1, $time, $time, 2, 2,
					5, 2, 'folder', 'notifikace', '/cs/', 11, 1, $time, $time, 2, 2,
					6, 5, 'email', 'newsletter', '/cs/notifikace/', 2, 1, $time, $time, 2, 2,
					7, 3, 'page', 'chybova-stranka', '/system/', 0, 1, $time, $time, 2, 2,
					8, 2, 'page', 'o-nas', '/cs/', 1, 1, $time, $time, 2, 2,
					9, 2, 'page', 'kontakt', '/cs/', 4, 1, $time, $time, 2, 2,
					12, 2, 'page', 'ucet', '/cs/', 7, 1, $time, $time, 2, 2,
					14, 5, 'email', 'registrace', '/cs/notifikace/', 0, 1, $time, $time, 2, 2,
					16, 5, 'email', 'reset-hesla', '/cs/notifikace/', 1, 1, $time, $time, 2, 2,
					21, 2, 'page', 'mapa-stranek', '/cs/', 10, 1, $time, $time, 2, 2,
					22, 2, 'page', 'aktuality', '/cs/', 0, 1, $time, $time, 2, 2,
					24, 5, 'email', 'pro-administratora-novy-kontaktni-formular', '/cs/notifikace/', 3, 1, $time, $time, 2, 2,
					26, 2, 'page', 'prihlaseni', '/cs/', 8, 1, $time, $time, 2, 2,
					27, 12, 'page', 'zmena-hesla', '/cs/ucet/', 1, 1, $time, $time, 2, 2,
					28, 12, 'page', 'profil', '/cs/ucet/', 2, 1, $time, $time, 2, 2,
					29, 2, 'page', 'vysledky-vyhledavani', '/cs/', 9, 1, $time, $time, 2, 2
				)
			),
			'documents_doctypes' => array(
				'schema' => array('id', 'name', 'module', 'controller', 'action', 'template', 'type', 'priority', 'creationDate', 'modificationDate'),
				'data' => array(
					1, 'Simple page', '', 'cms', 'template-simple', '', 'page', 0, $time, $time
				)
			),
			'documents_elements' => array(
				'schema' => array('documentId', 'name', 'type', 'data'),
				'data' => array(
					6, 'email_body', 'wysiwyg', '<p>Dobrý den,</p><p>Děkujeme, že jste se přihlásili k odběru našeho newletteru.</p><p>Jestliže jste se do newsletteru nepřihlásili dobrovolně nebo se v budoucnu budete chtít odhlásit, můžete použít nasledující odkaz k odhlášení:</p><p><a href="%Text(unsubscribeUrl);">%Text(unsubscribeUrl);</a></p><p>Pimweb</p>',
					14, 'email_body', 'wysiwyg', '<p>Dobrý den,</p><p>Děkujeme za registraci na našich stránkách <a href="%Text(siteUrl);">%Text(siteUrl);</a>. Pro dokončení registrace použijte následující odkaz:</p><p><a href="%Text(activationUrl);">%Text(activationUrl);</a></p><p>Pimweb</p>',
					16, 'email_body', 'wysiwyg', '<p>Dobrý den,</p><p>Na Vašem účtu bylo požádáno o resetování hesla. Heslo si můžete změnit přes nasledujúcí odkaz:</p><p><strong>%Text(link);</strong></p><p>Pimweb</p>',
					24, 'email_body', 'wysiwyg', '<p>Dobrý den,</p><p>v systému byl založen nový kontaktní formulář s klíčem <strong><a href="%Text(deeplink);">%Object(form, {"method":"getKey"});</a></strong>. Obsah:</p><p>Jméno: %Object(form, {"method":"getFullName"});</p><p>E-mail: %Object(form, {"method":"getEmail"});</p><p>Telefon: %Object(form, {"method":"getPhone"});</p><p>Zpráva: %Object(form, {"method":"getMessage"});</p><p>Pimweb</p>'
				)
			),
			'documents_email' => array(
				'schema' => array('id', 'module', 'controller', 'action', 'template', 'to', 'from', 'cc', 'bcc', 'subject'),
				'data' => array(
					6, '', 'snippet', 'simple-mail', '', '', 'noreply@vm3.portadesign.cz', '', '', 'Pimweb - přihlášení k odběru newsletteru',
					14, '', 'snippet', 'simple-mail', '', '', 'noreply@vm3.portadesign.cz', '', '', 'Pimweb - dokončení registrace',
					16, '', 'snippet', 'simple-mail', '', '', 'noreply@vm3.portadesign.cz', '', '', 'Pimweb - reset hesla',
					24, '', 'snippet', 'simple-mail', '', 'noreply@vm3.portadesign.cz', 'noreply@vm3.portadesign.cz', '', '', 'Pimweb - notifikace: nový kontaktní formulář'
				)
			),
			'documents_page' => array(
				'schema' => array('id', 'module', 'controller', 'action', 'template', 'title', 'description', 'keywords', 'metaData', 'prettyUrl', 'contentMasterDocumentId', 'css', 'personas'),
				'data' => array(
					2, '', 'default', 'index', NULL, 'Úvod', 'Úvod', '', 'a:0:{}', '', NULL, NULL, NULL,
					7, '', 'default', 'error-page', NULL, 'Chybová stránka', '', '', '', '', NULL, NULL, NULL,
					8, '', 'cms', 'template-simple', NULL, 'O nás', 'O nás', '', 'a:0:{}', '', NULL, NULL, NULL,
					9, '', 'cms', 'contact-us', NULL, 'Kontakt', 'Kontakt', '', 'a:0:{}', '', NULL, NULL, NULL,
					12, '', 'user', 'account', '', 'Účet', 'Účet', '', 'a:0:{}', '', NULL, NULL, NULL,
					21, '', 'cms', 'sitemap', NULL, 'Mapa stránek', 'Mapa stránek', '', 'a:0:{}', '', NULL, '', NULL,
					22, '', 'cms', 'news', NULL, 'Aktuality', 'Aktuality', '', 'a:0:{}', '', NULL, '', NULL,
					26, '', 'user', 'login', NULL, 'Přihlášení', 'Přihlášení', '', 'a:0:{}', '', NULL, '', NULL,
					27, '', 'user', 'change-password', NULL, 'Změna hesla', 'Změna hesla', '', 'a:0:{}', '', NULL, '', '',
					28, '', 'user', 'profile', NULL, 'Profil', 'Profil', '', 'a:0:{}', '', NULL, '', '',
					29, '', 'cms', 'search-results', NULL, 'Výsledky vyhledávání', 'Výsledky vyhledávání', '', 'a:0:{}', '', NULL, '', NULL
				)
			),
			'objects' => array(
				'schema' => array('o_id', 'o_parentId', 'o_type', 'o_key', 'o_path', 'o_index', 'o_published', 'o_creationDate', 'o_modificationDate', 'o_userOwner', 'o_userModification', 'o_classId', 'o_className'),
				'data' => array(
					2, 9, 'folder', 'novinky', '/novinky/', 0, 1, $time, $time, 2, 2, NULL, NULL,
					3, 8, 'folder', 'uzivatele', '/uzivatele/', 0, 1, $time, $time, 2, 2, NULL, NULL,
					4, 1, 'folder', 'kontakt', '/', 0, 1, $time, $time, 2, 2, NULL, NULL,
					5, 4, 'folder', 'kontaktni-formulare', '/kontakt/', 0, 1, $time, $time, 2, 2, NULL, NULL,
					6, 4, 'folder', 'newsletter', '/kontakt/', 0, 1, $time, $time, 2, 2, NULL, NULL,
					7, 3, 'object', 'john.doe_at_example.com', '/uzivatele/uzivatele/', 0, 1, $time, $time, 2, 2, 10, 'User',
					8, 1, 'folder', 'uzivatele', '/', 0, 1, $time, $time, 2, 2, NULL, NULL,
					9, 1, 'folder', 'novinky', '/', 0, 1, $time, $time, 2, 2, NULL, NULL
				)
			),
			//john doe user
			'object_query_10' => array(
				'schema' => array('oo_id', 'oo_classId', 'oo_className', 'email', 'password', 'activationCode', 'lang', 'firstName', 'lastName', 'phone', 'street', 'city', 'zipCode', 'company', 'ico', 'dic'),
				'data' => array(
					7, 10, 'User', 'john.doe@example.com', 'pass', 'not important...', 'cs', 'John', 'Doe', '0987654321', 'Street', 'City', '13456', 'Company', 'ico', 'dic'
				)
			),
			'object_store_10' => array(
				'schema' => array('oo_id', 'email', 'password', 'activationCode', 'lang', 'firstName', 'lastName', 'phone', 'street', 'city', 'zipCode', 'company', 'ico', 'dic'),
				'data' => array(
					7, 'john.doe@example.com', 'pass', 'not important...', 'cs', 'John', 'Doe', '0987654321', 'Street', 'City', '13456', 'Company', 'ico', 'dic'
				)
			),
			'properties' => array(
				'schema' => array('cid', 'ctype', 'cpath', 'name', 'type', 'data', 'inheritable'),
				'data' => array(
					1, 'document', '/', 'language', 'text', 'cs', 1,
					1, 'document', '/', 'titlePostfix', 'text', 'Pimweb', 1,
					1, 'document', '/', 'titleSeparator', 'text', ' - ', 1,
					2, 'document', '/cs', 'language', 'text', 'cs', 1,
					2, 'document', '/cs', 'navigation_name', 'text', 'Úvod', 0,
					2, 'document', '/cs', 'navigation_title', 'text', 'Úvod', 0,
					8, 'document', '/cs/o-nas', 'navigation_name', 'text', 'O nás', 0,
					8, 'document', '/cs/o-nas', 'navigation_title', 'text', 'O nás', 0,
					9, 'document', '/cs/kontakt', 'navigation_name', 'text', 'Kontakt', 0,
					9, 'document', '/cs/kontakt', 'navigation_title', 'text', 'Kontakt', 0,
					12, 'document', '/cs/ucet', 'navigation_name', 'text', 'Účet', 0,
					12, 'document', '/cs/ucet', 'navigation_title', 'text', 'Účet', 0,
					12, 'document', '/cs/ucet', 'elastic_search_exclude', 'bool', '1', 1,
					21, 'document', '/cs/mapa-stranek', 'navigation_name', 'text', 'Mapa stránek', 0,
					21, 'document', '/cs/mapa-stranek', 'navigation_title', 'text', 'Mapa stránek', 0,
					22, 'document', '/cs/aktuality', 'navigation_name', 'text', 'Aktuality', 0,
					22, 'document', '/cs/aktuality', 'navigation_title', 'text', 'Aktuality', 0,
					26, 'document', '/cs/prihlaseni', 'navigation_name', 'text', 'Přihlášení', 0,
					26, 'document', '/cs/prihlaseni', 'navigation_title', 'text', 'Přihlášení', 0,
					27, 'document', '/cs/ucet/zmena-hesla', 'navigation_name', 'text', 'Změna hesla', 1,
					27, 'document', '/cs/ucet/zmena-hesla', 'navigation_title', 'text', 'Změna hesla', 0,
					28, 'document', '/cs/ucet/profil', 'navigation_name', 'text', 'Profil', 0,
					28, 'document', '/cs/ucet/profil', 'navigation_title', 'text', 'Profil', 0,
					29, 'document', '/cs/vysledky-vyhledavani', 'elastic_search_exclude', 'bool', '1', 0,
					29, 'document', '/cs/vysledky-vyhledavani', 'navigation_name', 'text', 'Výsledky vyhledávání', 0,
					29, 'document', '/cs/vysledky-vyhledavani', 'navigation_title', 'text', 'Výsledky vyhledávání', 0
				)
			),
			'properties_predefined' => array(
				'schema' => array('id', 'name', 'description', 'key', 'type', 'data', 'config', 'ctype', 'inheritable', 'creationDate', 'modificationDate'),
				'data' => array(
					1, 'Mail sender name', '', 'emailSender', 'text', NULL, NULL, 'asset', 1, $time, $time,
					2, 'Exclude from Elastic Search', '', 'elastic_search_exclude', 'bool', 'true', '', 'document', 0, $time, $time
				)
			),
			'staticroutes' => array(
				'schema' => array('id', 'name', 'pattern', 'reverse', 'module', 'controller', 'action', 'variables', 'defaults', 'siteId', 'priority', 'creationDate', 'modificationDate'),
				'data' => array(
					1, 'newsletter-subscribe', '#/(cs)/newsletter-subscribe#', '/%language/newsletter-subscribe', '', 'cms', 'newsletter-subscribe', 'language', NULL, NULL, 1, $time, $time,
					2, 'newsletter-unsubscribe', '#/(cs)/newsletter-unsubscribe/([a-z0-9]+)#', '/%language/newsletter-unsubscribe/%code', NULL, 'cms', 'newsletter-unsubscribe', 'language,code', '', NULL, 1, $time, $time,
					4, 'news-cs', '#/cs/aktuality/([0-9]+)-([a-z0-9-]+)#', '/cs/aktuality/%id-%slug', '', 'cms', 'news-detail', 'id,slug', '', NULL, 1, $time, $time,
					5, 'activate-account', '#/(cs)/activate-account/([a-z0-9]+)#', '/%language/activate-account/%code', '', 'user', 'activation', 'language,code', '', NULL, 1, $time, $time,
					6, 'logout', '#/(cs)/logout#', '/%language/logout', '', 'user', 'logout', '', NULL, NULL, 1, $time, $time,
					7, 'password-reset', '#/(cs)/password-reset/([a-z0-9]+)#', '/%language/password-reset/%token', '', 'user', 'password-reset', 'language,token', '', NULL, 2, $time, $time,
					8, 'sitemap-xml', '#/sitemap.xml#', '/sitemap.xml', '', 'default', 'sitemap-xml', '', NULL, NULL, 2, $time, $time,
					9, 'download-asset', '#/download-asset/([0-9]+)#', '/download-asset/%id', '', 'default', 'download-asset', 'language,id', NULL, NULL, 2, $time, $time
				)
			),
			/*
			'tree_locks' => array(
				'schema' => array('id', 'type', 'locked'),
				'data' => array(
					2, 'document', 'self',
					2, 'object', 'self',
					3, 'document', 'self',
					3, 'object', 'self',
					4, 'asset', 'self',
					4, 'object', 'self',
					5, 'asset', 'self',
					5, 'document', 'self',
					5, 'object', 'self',
					6, 'asset', 'self',
					6, 'document', 'self',
					6, 'object', 'self',
					7, 'document', 'self',
					7, 'object', 'self',
					8, 'document', 'self',
					8, 'object', 'self',
					9, 'document', 'self',
					9, 'object', 'self',
					12, 'document', 'self',
					14, 'document', 'self',
					16, 'document', 'self',
					21, 'document', 'self',
					22, 'document', 'self',
					24, 'document', 'self',
					26, 'document', 'self',
					27, 'document', 'self',
					28, 'document', 'self',
					29, 'document', 'self'
				)
			),
			 * 
			 */
			'users' => array(
				'schema' => array('id', 'parentId', 'type', 'name', 'password', 'firstname', 'lastname', 'email', 'language', 'admin', 'active', 'permissions', 'roles', 'welcomescreen', 'closeWarning', 'memorizeTabs', 'docTypes', 'classes', 'apiKey'),
				'data' => array(
					3, 0, 'role', 'editor', NULL, NULL, NULL, NULL, NULL, 0, 1, 'assets,clear_cache,dashboards,documents,objects,recyclebin,emails,translations', NULL, NULL, NULL, NULL, '1', '4,5,6,10', NULL,
					4, 0, 'user', 'editor', '2850ba172924bfb6a64f902ee4a32691', '', '', '', 'cs', 0, 1, '', '3', 0, 1, NULL, null, null, NULL
				)
			),
			'users_workspaces_asset' => array(
				'schema' => array('cid', 'cpath', 'userId', 'list', 'view', 'publish', 'delete', 'rename', 'create', 'settings', 'versions', 'properties'),
				'data' => array(
					1, '/', 3, 1, 1, 1, 1, 1, 1, 1, 1, 1
				)
			),
			'users_workspaces_document' => array(
				'schema' => array('cid', 'cpath', 'userId', 'list', 'view', 'save', 'publish', 'unpublish', 'delete', 'rename', 'create', 'settings', 'versions', 'properties'),
				'data' => array(
					1, '/', 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
					4, '/notifikace', 3, 1, 1, 1, 1, 0, 0, 0, 0, 1, 1, 1
				)
			),
			'users_workspaces_object' => array(
				'schema' => array('cid', 'cpath', 'userId', 'list', 'view', 'save', 'publish', 'unpublish', 'delete', 'rename', 'create', 'settings', 'versions', 'properties', 'lEdit', 'lView', 'layouts'),
				'data' => array(
					4, '/kontakt', 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, NULL, NULL, NULL,
					8, '/uzivatele', 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, NULL, NULL, NULL,
					9, '/novinky', 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, NULL, NULL, NULL
				)
			),
			'translations_website' => array(
				'schema' => array('key', 'language', 'text', 'creationDate', 'modificationDate'),
				'data' => array(
					'msg_unknown_error', 'cs', 'Došlo k neznámé chybě.', $time, $time,
					'msg_invalid_request', 'cs', 'Neplatný požadavek.', $time, $time,
					'msg_invalid_token', 'cs', 'Neplatný token.', $time, $time,
					'msg_no_items_found', 'cs', 'Zadaným kritériím nevyhovují žádné položky.', $time, $time,
					'msg_form_invalid', 'cs', 'Zdá se, že formulář obsahuje chyby. Zkontrolujte a zkuste ho odoslat znovu.', $time, $time,
					'msg_empty_field', 'cs', 'Pole nesmí zůstat prázdné', $time, $time,
					'msg_bad_format', 'cs', 'Údaj má nesprávný formát', $time, $time,
					'msg_bad_format_phone', 'cs', 'Zadejte prosím správné číslo telefonu s předvolbou a bez mezer (napr. +420123456789).', $time, $time,
					'msg_invalid_email', 'cs', 'E-mail má nesprávný formát', $time, $time,
					'msg_select_file', 'cs', 'Vyberte soubor.', $time, $time,
					'msg_not_an_image', 'cs', 'Soubor není obrázkem.', $time, $time,
					'msg_file_too_big', 'cs', 'Soubor je příliš velký.', $time, $time,
					'msg_file_not_uploaded', 'cs', 'Soubor se nepovedlo nahrát na server.', $time, $time,
					'msg_email_registered', 'cs', 'E-mail obsazen', $time, $time,
					'msg_email_registered_for_quick_registration', 'cs', 'Na zadaný e-mail již je vytvořen účet, přihlašte se prosím', $time, $time,
					'msg_agree_with_terms', 'cs', 'Musíte souhlasit s podmínkami', $time, $time,
					'msg_wrong_old_password', 'cs', 'Staré heslo není správné', $time, $time,
					'msg_passwords_do_not_match', 'cs', 'Hesla se neshodují', $time, $time,
					'msg_newsletter_registered', 'cs', 'E-mail %s byl zařazen do newsletteru.', $time, $time,
					'msg_newsletter_already_registered', 'cs', 'Chyba - E-mail %s již je registrován do newsletteru.', $time, $time,
					'msg_newsletter_unsubscribed', 'cs', 'E-mail %s byl odstraněn z newsletteru.', $time, $time,
					'msg_newsletter_code_invalid', 'cs', 'Chyba - neplatný kód pro odhlášení z newsletteru.', $time, $time,
					'msg_contact_form_success', 'cs', 'Kontaktní formulář byl odeslán.', $time, $time,
					'msg_registration_successfull', 'cs', 'Registrace proběhla úspěšně. Na e-mail %s byli odeslány instrukce k aktivaci Vášho účtu.', $time, $time,
					'msg_email_not_registered', 'cs', 'Chyba - E-mail %s není registrován.', $time, $time,
					'msg_account_activated', 'cs', 'Účet %s byl aktivován.', $time, $time,
					'msg_activation_code_invalid', 'cs', 'Chyba - neplatný aktivační kód.', $time, $time,
					'msg_password_reset_successfull', 'cs', 'Na registrační e-mail %s Vám byl zaslán odkaz pro změnu hesla.', $time, $time,
					'msg_password_change_successfull', 'cs', 'Heslo bylo změněno.', $time, $time,
					'msg_address_inserted', 'cs', 'Adresa byla vložena.', $time, $time,
					'msg_address_updated', 'cs', 'Adresa byla změněna.', $time, $time,
					'msg_logout_successful', 'cs', 'Odhlášení proběhlo úspěšně.', $time, $time,
					'msg_authentication_successful', 'cs', 'Přihlášení proběhlo úspěšně.', $time, $time,
					'msg_authentication_error', 'cs', 'Neplatné přihlašovací údaje.', $time, $time,
					'label_registration_address', 'cs', 'Registrační adresa', $time, $time,
					'label_edit', 'cs', 'Upravit', $time, $time,
					'label_first_page', 'cs', 'První stránka', $time, $time,
					'label_last_page', 'cs', 'Poslední stránka', $time, $time,
					'label_previous_page', 'cs', 'Předchozí stránka', $time, $time,
					'label_next_page', 'cs', 'Následující stránka', $time, $time,
					'label_color', 'cs', 'Barva', $time, $time,
					'label_title', 'cs', 'Název', $time, $time,
					'label_first_name', 'cs', 'Jméno', $time, $time,
					'label_last_name', 'cs', 'Příjmení', $time, $time,
					'label_phone', 'cs', 'Telefon', $time, $time,
					'label_email', 'cs', 'E-mail', $time, $time,
					'label_street', 'cs', 'Ulice', $time, $time,
					'label_city', 'cs', 'Město', $time, $time,
					'label_zip_code', 'cs', 'PSČ', $time, $time,
					'label_company', 'cs', 'Firma', $time, $time,
					'label_ic', 'cs', 'IČ', $time, $time,
					'label_dic', 'cs', 'DIČ', $time, $time,
					'label_add', 'cs', 'Přidat', $time, $time,
					'label_submit', 'cs', 'Odeslat', $time, $time,
					'label_message', 'cs', 'Zpráva', $time, $time,
					'label_full_name', 'cs', 'Jméno', $time, $time,
					'label_message_text', 'cs', 'Text zprávy', $time, $time,
					'label_submit_question', 'cs', 'Odeslat dotaz', $time, $time,
					'label_password', 'cs', 'Heslo', $time, $time,
					'label_remember_me', 'cs', 'Zapamatovat', $time, $time,
					'label_login', 'cs', 'Přihlásit', $time, $time,
					'label_password_old', 'cs', 'Staré heslo', $time, $time,
					'label_password_new', 'cs', 'Nové heslo', $time, $time,
					'label_password_new_again', 'cs', 'Nove heslo znova', $time, $time,
					'label_change', 'cs', 'Změnit', $time, $time,
					'label_reset_password', 'cs', 'Resetovat heslo', $time, $time,
					'label_password_again', 'cs', 'Heslo znova', $time, $time,
					'label_newsletter', 'cs', 'Přihlásit se k odběru newsletteru', $time, $time,
					'label_send_me_newsletter', 'cs', 'Chci odebírat newsletter', $time, $time,
					'label_search', 'cs', 'Hledat', $time, $time,
					'label_register', 'cs', 'Registrovat', $time, $time,
					'label_region1', 'cs', 'Moravskoslezský', $time, $time,
					'label_region2', 'cs', 'Středočeský', $time, $time,
					'label_region3', 'cs', 'Praha', $time, $time,
					'label_region4', 'cs', 'Jihočeský', $time, $time,
					'label_region5', 'cs', 'Plzeňský', $time, $time,
					'label_region6', 'cs', 'Karlovarský', $time, $time,
					'label_region7', 'cs', 'Ústecký', $time, $time,
					'label_region8', 'cs', 'Liberecký', $time, $time,
					'label_region9', 'cs', 'Královéhradecký', $time, $time,
					'label_region10', 'cs', 'Pardubický', $time, $time,
					'label_region11', 'cs', 'Vysočina', $time, $time,
					'label_region12', 'cs', 'Jihomoravský', $time, $time,
					'label_region13', 'cs', 'Olomoucký', $time, $time,
					'label_region14', 'cs', 'Zlínský', $time, $time,
					'title_addresses_management', 'cs', 'Správa adres', $time, $time,
					'title_orders_management', 'cs', 'Správa objednávek', $time, $time,
					'title_edit_address', 'cs', 'Úprava adresy %s', $time, $time,
					'title_add_address', 'cs', 'Přidání adresy', $time, $time,
					'title_change_password', 'cs', 'Změna hesla', $time, $time,
					'param_page', 'cs', 'stranka', $time, $time,
					'param_sort', 'cs', 'razeni', $time, $time,
					'param_limit', 'cs', 'limit', $time, $time,
					'system_an_error_occured', 'cs', 'Vyskytla se chyba.', $time, $time,
					'system_return_to_homepage', 'cs', 'Zpět na úvodní stránku.', $time, $time,
					'system_page_not_found', 'cs', '404 - Stránka nenalezena.', $time, $time,
					'system_application_error', 'cs', '500 - Chyba aplikace.', $time, $time
				)
			),
			'translations_admin' => array(
				'schema' => array('key', 'language', 'text', 'creationDate', 'modificationDate'),
				'data' => array(
					'activation code', 'cs', 'Aktivační kód', $time, $time,
					'activation code', 'en', 'Activation code', $time, $time,
					'area_email', 'en', 'E-mail', $time, $time,
					'area_email', 'cs', 'E-mail', $time, $time,
					'area_email_description', 'en', ' ', $time, $time,
					'area_email_description', 'cs', ' ', $time, $time,
					'area_gallery', 'en', 'Gallery', $time, $time,
					'area_gallery', 'cs', 'Galerie', $time, $time,
					'area_gallery_description', 'en', ' ', $time, $time,
					'area_gallery_description', 'cs', ' ', $time, $time,
					'area_textblock', 'en', 'Text block', $time, $time,
					'area_textblock', 'cs', 'Text', $time, $time,
					'area_textblock_description', 'en', ' ', $time, $time,
					'area_textblock_description', 'cs', ' ', $time, $time,
					'blog', 'cs', 'Blog', $time, $time,
					'blog', 'en', 'Blog', $time, $time,
					'city', 'cs', 'Město', $time, $time,
					'city', 'en', 'City', $time, $time,
					'classname', 'cs', 'Název třídy', $time, $time,
					'classname', 'en', 'Class name', $time, $time,
					'company', 'cs', 'Společnost', $time, $time,
					'company', 'en', 'Company', $time, $time,
					'contact', 'cs', 'Kontakt', $time, $time,
					'contact', 'en', 'Contact', $time, $time,
					'contactform', 'cs', 'Kontaktní formulář', $time, $time,
					'contactform', 'en', 'Contact form', $time, $time,
					'content', 'cs', 'Obsah', $time, $time,
					'content', 'en', 'Content', $time, $time,
					'creation date', 'cs', 'Datum vytvoření', $time, $time,
					'creation date', 'en', 'Creation date', $time, $time,
					'creationdate', 'cs', 'Datum vytvoření', $time, $time,
					'creationdate', 'en', 'Creation date', $time, $time,
					'czech', 'cs', 'Čeština', $time, $time,
					'czech', 'en', 'Czech', $time, $time,
					'dic', 'cs', 'DIČ', $time, $time,
					'dic', 'en', 'DIČ', $time, $time,
					'email', 'cs', 'E-mail', $time, $time,
					'email', 'en', 'E-mail', $time, $time,
					'filename', 'cs', 'Název souboru (složky)', $time, $time,
					'filename', 'en', 'Filename', $time, $time,
					'first name', 'cs', 'Jméno', $time, $time,
					'first name', 'en', 'First name', $time, $time,
					'firstname', 'cs', 'Jméno', $time, $time,
					'firstname', 'en', 'First name', $time, $time,
					'fullpath', 'cs', 'Cesta', $time, $time,
					'fullpath', 'en', 'Full path', $time, $time,
					'gender', 'cs', 'Pohlaví', $time, $time,
					'gender', 'en', 'Gender', $time, $time,
					'ico', 'cs', 'IČ', $time, $time,
					'ico', 'en', 'IČ', $time, $time,
					'id', 'cs', 'ID', $time, $time,
					'id', 'en', 'ID', $time, $time,
					'language', 'cs', 'Jazyk', $time, $time,
					'language', 'en', 'Language', $time, $time,
					'last name', 'cs', 'Příjmení', $time, $time,
					'last name', 'en', 'Last name', $time, $time,
					'lastname', 'cs', 'Příjmení', $time, $time,
					'lastname', 'en', 'Last name', $time, $time,
					'master', 'cs', '', $time, $time,
					'master', 'en', '', $time, $time,
					'master (admin mode)', 'cs', '', $time, $time,
					'master (admin mode)', 'en', '', $time, $time,
					'message', 'cs', 'Zpráva', $time, $time,
					'message', 'en', 'Message', $time, $time,
					'modificationdate', 'cs', 'Datum poslední modifikace', $time, $time,
					'modificationdate', 'en', 'Modification date', $time, $time,
					'name', 'cs', 'Jméno (Název)', $time, $time,
					'name', 'en', 'Name', $time, $time,
					'news', 'cs', 'Novinka', $time, $time,
					'news', 'en', 'News', $time, $time,
					'news(pl)', 'cs', 'Novinky', $time, $time,
					'news(pl)', 'en', 'News', $time, $time,
					'newsletter active', 'cs', 'Newsletter aktivní', $time, $time,
					'newsletter active', 'en', 'Newsletter active', $time, $time,
					'newsletter confirmed', 'cs', 'Newsletter potvrzen', $time, $time,
					'newsletter confirmed', 'en', 'Newsletter confirmed', $time, $time,
					'newsletterform', 'cs', 'Newsletter formulář', $time, $time,
					'newsletterform', 'en', 'Newsletter form', $time, $time,
					'password', 'cs', 'Heslo', $time, $time,
					'password', 'en', 'Password', $time, $time,
					'password reset token', 'cs', 'Token k resetování hesla', $time, $time,
					'password reset token', 'en', 'Password reset token', $time, $time,
					'perex', 'cs', 'Perex', $time, $time,
					'perex', 'en', 'Perex', $time, $time,
					'phone', 'cs', 'Telefon', $time, $time,
					'phone', 'en', 'Phone', $time, $time,
					'preview image', 'cs', 'Náhledový obrázek', $time, $time,
					'preview image', 'en', 'Preview image', $time, $time,
					'published', 'cs', 'Zveřejněno', $time, $time,
					'published', 'en', 'Published', $time, $time,
					'seo', 'cs', 'SEO', $time, $time,
					'seo', 'en', 'SEO', $time, $time,
					'seo slug', 'cs', 'SEO slug', $time, $time,
					'seo slug', 'en', 'SEO slug', $time, $time,
					'seo description', 'cs', 'SEO popisek', $time, $time,
					'seo description', 'en', 'SEO description', $time, $time,
					'seo keywords', 'cs', 'SEO klíčová slova', $time, $time,
					'seo keywords', 'en', 'SEO keywords', $time, $time,
					'simple page', 'cs', 'Jednoduchá stránka', $time, $time,
					'simple page', 'en', 'Simple page', $time, $time,
					'street', 'cs', 'Ulice', $time, $time,
					'street', 'en', 'Street', $time, $time,
					'text', 'cs', 'Text', $time, $time,
					'text', 'en', 'Text', $time, $time,
					'unsubscribe code', 'cs', 'Kód k odhlášení z newsletteru', $time, $time,
					'unsubscribe code', 'en', 'Unsubscribe code', $time, $time,
					'user', 'cs', 'Uživatel', $time, $time,
					'user', 'en', 'User', $time, $time,
					'users', 'cs', 'Uživatelé', $time, $time,
					'users', 'en', 'Users', $time, $time,
					'zip code', 'cs', 'PSČ', $time, $time,
					'zip code', 'en', 'Zip code', $time, $time
				)
			),
			'website_settings' => array(
				'schema' => array('id', 'name', 'type', 'data', 'siteId', 'creationDate', 'modificationDate'),
				'data' => array(
					1, 'frontendLanguages', 'text', 'cs', 0, $time, $time
				)
			)
		);

		foreach($dbExtension as $table => $struct) {
			$q = '(?'.str_repeat(',?', count($struct['schema']) - 1).')';
			$rowCount = count($struct['data']) / count($struct['schema']);
			$stmt = $this->db->prepare(vsprintf('INSERT INTO `%s` (%s) VALUES %s', array(
				$table,
				'`'.implode('`,`', $struct['schema']).'`',
				$q.str_repeat(','.$q, $rowCount - 1)
			)));
			$stmt->execute($struct['data']);
		}
	}
}
