<?php

namespace Website\Tool\Setup;

use Composer\Script\Event;
use Composer\Util\Filesystem;
use Composer\Installer\PackageEvent;

class Composer
{

	public static function postCreateProject(Event $event)
	{
		$config = $event->getComposer()->getConfig();
		$rootPath = dirname($config->get('vendor-dir'));
		$projectName = basename($rootPath);

		// init composer
		rename($rootPath . '/composer.tmpl', $rootPath . '/composer.json');
		unlink($rootPath . '/composer.lock');

		// init git
		$filesystem = new Filesystem();
		$filesystem->removeDirectory($rootPath . '/.git');
		rename($rootPath . '/gitignore.tmpl', $rootPath . '/.gitignore');
		exec('git init');
		exec(sprintf('git remote add origin https://portabucket@bitbucket.org/portabucket/%s.git', $projectName));

		// create database
		exec(sprintf('mysql --login-path=deployment -e "create database %s character set utf8 collate utf8_general_ci"', $projectName));

		// init deployment script
		$confPath = $rootPath . '/website/tools/Deployment/remote.conf';
		$contents = preg_replace(
			'/WEBNAME=""/',
			sprintf('WEBNAME="%s"', $projectName),
			file_get_contents($confPath)
		);
		$fh = fopen($confPath, "w");
		fwrite($fh, $contents);
		fclose($fh);

		// init readme
		$contents = preg_replace(
			'/###TITLE###/',
			sprintf('%s', ucfirst($projectName)),
			file_get_contents($rootPath . '/README.tmpl')
		);
		$fh = fopen($rootPath . '/README.md', "w");
		fwrite($fh, $contents);
		fclose($fh);

		// cleanup
		foreach(glob($rootPath . '/website/cli/postupdate-*.php') as $filename) {
			@unlink(realpath($filename));
		}
		@unlink($rootPath . '/README.tmpl');

	}

}
