<?php

/**
 * Builds a language switching structure for a given object. Assumes the getUrl($language) method is implemented on that object.
 *
 * @author Martin Kuric <martin.kuric@portadesign.cz>
 */

namespace Website\Controller\Action\Helper;

class BuildLanguageSwitchFromObject extends \Zend_Controller_Action_Helper_Abstract
{
	protected $switcher = [];

	/**
	 *
	 * @param \Pimcore\Model\Object\Concrete $object the object instance
	 *
	 * @return array associative array with localized URLs for each language, e.g. ['en' => 'en_url', 'cs' => 'cs_url']
	 */
	public function direct($object, $hpFallbackPath = null)
	{
		$languages = \Website\Tool\Utils::getValidFrontendLanguages();

		foreach ($languages as $language) {
			$url = null;
			if (method_exists($object, 'getUrl')) {
				$this->switcher[$language] = $object->getUrl($language);
				if (!$url && $hpFallbackPath) {
					$langBackup = $this->getActionController()->view->language;
					$this->getActionController()->view->language = $language;
					$url = $this->getActionController()->view->docUrl($hpFallbackPath);
					if ($url == '/') {
						$url = null;
					}
					$this->getActionController()->view->language = $langBackup;
				}
			}
			if ($url) {
				$this->switcher[$language] = $url;
			}
		}

		return $this->switcher;
	}
}
