<?php

class CmsController extends \Website\Controller\BaseController
{

	/*						DOCUMENT ROUTED ACTIONS							*/

	public function templateSimpleAction()
	{
		$this->enableLayout();
	}

	public function sitemapAction()
	{
		$this->enableLayout();

		//output cached stuff
		if (!$this->isOutputCached($this->cacheKeySuffix)) {
			$language = $this->document->getProperty('language');
			$root = Pimcore\Model\Document::getById(1);
			$this->view->sitemapNavigation = $this->view->pimcoreNavigation($root, $root)
				->menu()->setUseTranslator(false)->renderMenu();
		}
	}

	public function contactUsAction()
	{
		$this->enableLayout();

		$form = new \Website\Form\ContactForm();

		if ($this->getRequest()->isPost()) {
			if ($this->handleContactForm($form)) {
				$this->gotoUrl($this->view->docUrl('/'.$this->defaultLanguage.'/kontakt'));
			}
		}

		$this->view->contactForm = $form;
	}

	public function newsAction()
	{
		$this->enableLayout();

		$list = new \Website\Model\News\Listing();
		$list->setOrder('desc');
		$list->setOrderKey('createdOn');
		$list->setCondition('createdOn < '.time());

		$paginator = \Zend_Paginator::factory($list);
		$paginator->setCurrentPageNumber($this->getRequest()->getParam('page', 1));
		$paginator->setItemCountPerPage(6);

		$this->view->news = $paginator;
	}



	/* 						STATIC-ROUTE ROUTED ACTIONS						 */



	public function newsDetailAction()
	{
		$this->enableLayout();

		//output cached stuff
		if (!$this->isOutputCached($this->cacheKeySuffix)) {
			$article = \Website\Model\News::getById($this->getRequest()->getParam('id'));

			if (!$article) {
				throw new \Zend_Controller_Router_Exception($this->translate('system_page_not_found'), 404);
				return;
			}

			//get sibblings (next and previous news)
			$list = new \Website\Model\News\Listing();
			$list->setOrder('desc');
			$list->setOrderKey('createdOn');
			$list->setCondition('createdOn < '.time());
			$list->load();
			list($this->view->previousNews, $this->view->nextNews) = $this->_helper->getSiblings($list, $article, 'createdOn');
			//extend breadcrumbs
			$this->addToBreadcrumbs[] = [
				'label' => $article->getName(),
				'url' => $article->getUrl()
			];
			//explicit language switch
			$this->languageSwitch = $this->_helper->buildLanguageSwitchFromObject($article);
			//explicit seo stuff
			$this->view->headTitle($article->getName());
			if ($article->getSeoDescription()) {
				$this->view->headMeta()->setName('description', $article->getSeoDescription());
			}

			$this->view->news = $article;
		}
	}



	/*				VIEW-LESS ACTIONS (ALLWAYS REDIRECT)					*/



	public function newsletterSubscribeAction()
	{
		$this->handleNewsletterForm($this->newsletterForm);

		$this->newsletterForm->reset();

		$this->ajaxResponseBuilder->addFlashMessages()
			->addElement('#newsletter-form-wrapper', 'cms/snippets/newsletter-form.php')
			->sendResponse();
	}

	public function newsletterUnsubscribeAction()
	{
		$this->disableViewAutoRender();
		$code = $this->getRequest()->getParam('code');

		$newsletterManager = new \Website\Model\NewsletterManager();
		$email = $newsletterManager->unsubscribe($code);

 		//@TODO usage of model response would be better here
		if ($email) {
			$this->addSuccessMsg(sprintf($this->translate('msg_newsletter_unsubscribed'), $email));
		} elseif ($email === false) {
			$this->addInfoMsg($this->translate('msg_newsletter_code_invalid'));
		} else {
			$this->addErrorMsg($this->translate('msg_unknown_error'));
		}

		$this->gotoUrl($this->getPreviousUrl());
	}



	/*							FORM HANDLERS								*/



	private function handleNewsletterForm(\Zend_Form &$form)
	{
		if ($form->isValid($this->getRequest()->getPost())) {
			$data = $form->getValues();
			$data['lang'] = $this->language;
			$newsletterManager = new \Website\Model\NewsletterManager();
			if ($newsletterManager->addNewsletter($data)) {
				$this->addSuccessMsg(sprintf($this->translate('msg_newsletter_registered'), $data['email']));
				return true;
			} else {
				$this->addErrorMsg($this->translate('msg_unknown_error'));
				return false;
			}
		} else {
			$this->addErrorMsg($this->translate('msg_form_invalid'));
		}

		return false;
	}

	private function handleContactForm(\Zend_Form &$form)
	{
		if ($form->isValid($this->getRequest()->getPost())) {
			$data = $form->getValues();
			$data['lang'] = $this->language;

			$contactForm = \Pimcore\Model\Object\ContactForm::create($data);
			$contactForm->setCreationDate(time());
			$key = \Pimcore\File::getValidFilename($data['fullName'].'_'.date('Y-m-d-H:i:s', time()));
			$contactForm->setKey($key);
			$contactForm->setParentId(\Pimcore\Model\Object\Folder::getByPath('/kontakt/kontaktni-formulare')->getId());
			$contactForm->setPublished(true);

			try {
				$contactForm->save();

				$this->addSuccessMsg($this->translate('msg_contact_form_success'));

				//send email to admin
				$mailManager = new \Website\Model\MailManager();
				$mailManager->sendMail('/notifikace/pro-administratora-novy-kontaktni-formular', $this->language, null, null, [
					'deeplink' => $this->view->serverUrl().'/admin/login/deeplink?object_'.$contactForm->getId().'_object',
					'form' => $contactForm
				]);

				return true;
			} catch (\Exception $e) {
				\Pimcore\Log\Simple::log('exceptions', 'CONTACT FORM - '.$e->getMessage()."\n".$e->getTraceAsString());
				$this->addErrorMsg($this->translate('msg_unknown_error'));
			}
		} else {
			$this->addErrorMsg($this->translate('msg_form_invalid'));
		}
		return false;
	}
}
