<?php

namespace Website\Tool\Console\Command;

use Pimcore\Console\AbstractCommand;
use Symfony\Component\Console\Input\InputArgument;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Output\OutputInterface;

class GeneratorAreaDeleteCommand extends AbstractCommand
{
	protected function configure()
	{
		$this
			->setName('generator:area-delete')
			->setDescription('Deleate a pimcore area definition')
			->addArgument(
				'name',
				InputArgument::REQUIRED,
				'Area name in lowercase'
			);
	}

	protected function execute(InputInterface $input, OutputInterface $output)
	{
		$generator = new \Website\Model\Generator();

		$name = strtolower($input->getArgument('name'));

		$generator->deleteArea($name);
		$output->writeln(sprintf("Area [%s] deleted\n", $name));
	}
}
