<?php

namespace Website\Tool\Console\Command;

use Pimcore\Console\AbstractCommand;
use Symfony\Component\Console\Input\InputArgument;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Output\OutputInterface;

class GeneratorClassDeleteCommand extends AbstractCommand
{
	protected function configure()
	{
		$this
			->setName('generator:class-delete')
			->setDescription('Delete a pimcore class definition')
			->addArgument(
				'name',
				InputArgument::REQUIRED,
				'Class name in CamelCase'
			);
	}

	protected function execute(InputInterface $input, OutputInterface $output)
	{
		$generator = new \Website\Model\Generator();

		$name = $input->getArgument('name');
		$generator->deleteClassMapping($name);
		$output->writeln(sprintf("Classmapping for class [%s] deleted\n", $name));

		$generator->deleteClassDefinition($name);
		$output->writeln(sprintf("Class [%s] deleted\n", $name));
	}
}
