<?php
set_time_limit(60000);
include_once(__DIR__ . "/../../../pimcore/cli/startup.php");
$db = Pimcore_Resource_Mysql::get();
Pimcore_Model_Cache::clearAll();

fputs(STDOUT, "3132\n");
// PHP 5.5 Crypt-API password compatibility layer for PHP version < PHP 5.5
include_once("password_compatibility.php");

$users = $db->fetchAll("SELECT id,password FROM users WHERE name != 'system' AND type = 'user' AND IFNULL(password, '') != ''");

foreach ($users as $user) {
	$newPassword = password_hash($user["password"], PASSWORD_DEFAULT);

	$db->update("users", [
		"password" => $newPassword
	], "id = " . $user["id"]);
}

fputs(STDOUT, "3147\n");
$db->query("CREATE TABLE `custom_layouts` (
	`id` INT(11) UNSIGNED NOT NULL AUTO_INCREMENT,
	`classId` INT(11) UNSIGNED NOT NULL,
	`name` VARCHAR(255) NULL DEFAULT NULL,
	`description` TEXT NULL,
	`creationDate` BIGINT(20) UNSIGNED NULL DEFAULT NULL,
	`modificationDate` BIGINT(20) UNSIGNED NULL DEFAULT NULL,
	`userOwner` INT(11) UNSIGNED NULL DEFAULT NULL,
	`userModification` INT(11) UNSIGNED NULL DEFAULT NULL,
	PRIMARY KEY (`id`),
	UNIQUE INDEX `name` (`name`, `classId`)
) DEFAULT CHARSET=utf8;");


$db->query("ALTER TABLE `users_workspaces_object`
	ADD COLUMN `layouts` TEXT NULL AFTER `lView`;
");

fputs(STDOUT, "3157\n");
try {
	$db->query("ALTER TABLE `keyvalue_keys` ADD COLUMN `translator` int(11) DEFAULT NULL;");
	$db->query("ALTER TABLE `keyvalue_keys` CHANGE COLUMN `type` `type` enum('bool','number','select','text','translated') NULL DEFAULT NULL;");
} catch (\Exception $e) {
	fputs(STDOUT, $e->getMessage());
}

Pimcore_Model_Cache::clearAll();
fputs(STDOUT, "done\n");
