<?php

namespace Website\Model\Document;

class Page extends \Pimcore\Model\Document\Page implements \Website\Model\IElasticObjectFulltext
{
	use \Website\Model\ElasticTrait;

	public function save()
	{
		parent::save();

		if (\Website\Tool\Utils::elasticSearchEnabled()) {
			$this->elasticSearchUpdateFulltext();
		}
	}

	public function delete()
	{
		if (\Website\Tool\Utils::elasticSearchEnabled()) {
			$this->elasticSearchDeleteFulltext();
		}

		parent::delete();
	}

	/* 								For elastic search							*/

	public function elasticSearchLoadFulltext($lang = null)
	{
		if (!$lang) {
			$lang = $this->getProperty('language');
			if (!$lang) {
				$lang = \Website\Tool\Utils::getDefaultLanguage();
			}
		}

		//set frontend translator if needed
		if (!\Zend_Registry::isRegistered('Zend_Translate')
			|| (\Zend_Registry::get('Zend_Translate') && \Zend_Registry::get('Zend_Translate')->getLocale() != $lang)
			// hack, tests for fronend translation
			|| (\Zend_Registry::get('Zend_Translate') && \Zend_Registry::get('Zend_Translate')->_('label_email') == 'label_email')
		) {
			$translate = new \Pimcore\Translate\Website($lang);
			\Zend_Registry::set('Zend_Translate', $translate);
		}

		//disable redirecting in the dispatch process which would break the indexing
		$redirector = \Zend_Controller_Action_HelperBroker::getStaticHelper('redirector');
		$exitBackup = $redirector->getExit();
		$redirector->setExit(false);

		\Website\Tool\Utils::forceInheritanceAndFallbackValues();

		$data = array_merge($this->getElasticBaseData(), [
			'path' => \Website\Tool\Utils::docUrl($this->getRealFullPath(), $lang),
			'title' => $this->getTitle(),
			'description' => $this->getDescription(),
			'content' => ($this->getPublished())
				? $this->normalizeElasticText(\Pimcore\Model\Document\Service::render(
					$this,
					[
						'elastic_document_indexing' => true,
					],
					false
				))
				: '',
		]);

		\Website\Tool\Utils::restorInheritanceAndFallbackValues();

		$redirector->setExit($exitBackup);

		return $data;
	}
}
