<?php

set_time_limit(60000);
include_once __DIR__.'/../../../pimcore/cli/startup.php';
\Pimcore\Cache::clearAll();
$db = \Pimcore\Db::get();

function check($fieldDefinitions, $needsSave) {
	/** @var  $fieldDefinition */
	foreach ($fieldDefinitions as $fieldDefinition) {
		if ($fieldDefinition instanceof  \Pimcore\Model\Object\ClassDefinition\Data\Localizedfields) {
			$needsSave = check($fieldDefinition->getFieldDefinitions(), $needsSave);
		} else  if ($fieldDefinition instanceof \Pimcore\Model\Object\ClassDefinition\Data\Relations\AbstractRelations) {
			if (method_exists($fieldDefinition, "getLazyLoading") && $fieldDefinition->getLazyLoading()) {
				$needsSave |= true;
				$fieldDefinition->setLazyLoading(false);
			}
		}
	}
	return $needsSave;
}

fwrite(STDOUT, "4010\n");
try {
	$db->query("ALTER TABLE users ADD websiteTranslationLanguagesEdit LONGTEXT, ADD websiteTranslationLanguagesView LONGTEXT;");
} catch (\Exception $e) {
	fwrite(STDOUT, '4010 failed - '.$e->getMessage()."\n");
}

fwrite(STDOUT, "4012\n");
try {
	$db->query("ALTER TABLE `search_backend_data` DROP INDEX `data`;");
	$db->query("ALTER TABLE `search_backend_data` DROP INDEX `properties`;");
} catch (\Exception $e) {
	fwrite(STDOUT, '4012 failed - '.$e->getMessage()."\n");
}

fwrite(STDOUT, "4021\n");
try {
	$db->query("ALTER TABLE `assets_metadata` ADD INDEX `name` (`name`);");
} catch (\Exception $e) {
	fwrite(STDOUT, '4021 failed - '.$e->getMessage()."\n");
}

fwrite(STDOUT, "4025\n");
try {
	$config = \Pimcore\WorkflowManagement\Workflow\Config::getWorkflowManagementConfig(true);
	if ($config) {
		$config = $config['workflows'];
		$workflows = [];
		if(is_array($config)) {
			foreach ($config as $workflow) {
				$workflow['creationDate'] = \Carbon\Carbon::now()->getTimestamp();
				$workflow['modificationDate'] = \Carbon\Carbon::now()->getTimestamp();
				$workflows[$workflow['id']] = $workflow;
			}
		}
		$contents = to_php_data_file_format($workflows);
		\Pimcore\File::putPhpFile(\Pimcore\Config::locateConfigFile('workflowmanagement.php'), $contents);
	}
} catch (\Exception $e) {
	fwrite(STDOUT, '4025 failed - '.$e->getMessage()."\n");
}

fwrite(STDOUT, "4028\n");
try {
	// Update thumbnail configs (doNotScaleUp is changed for forceResize)
	$list = new Asset\Image\Thumbnail\Config\Listing();
	$thumbnailConfigs = $list->load();

	foreach ($thumbnailConfigs as $thumbnailConfig) {
		$toUpdate = false;

		$items = $thumbnailConfig->getItems();
		foreach ($items as &$item) {
			if (isset($item["method"]) && $item["method"] === "cover") {
				if (isset($item["arguments"])) {
					$toUpdate = true;
					foreach ($item["arguments"] as $key => $value) {
						if ($key === "doNotScaleUp") {
							$item["arguments"]["forceResize"] = !$value;
							unset($item["arguments"][$key]);
						}
					}
				}
			}
		}
		unset($item); // good practice to unset pointer at the end of the loop

		// We update only if necessary
		if ($toUpdate) {
			$thumbnailConfig->setItems($items);
			$thumbnailConfig->save();
		}
	}
} catch (\Exception $e) {
	fwrite(STDOUT, '4028 failed - '.$e->getMessage()."\n");
}

fwrite(STDOUT, "4031\n");
try {
	$routes = new \Pimcore\Model\Staticroute\Listing();
	$routes = $routes->load();
	/** @var  $route \Pimcore\Model\Staticroute */
	foreach ($routes as $route) {
		$siteId = $route->getSiteId();
		if ($siteId && !is_array($siteId)) {
			$route->setSiteId(array($siteId));
		}
		$route->save();
	}
} catch (\Exception $e) {
	fwrite(STDOUT, '4031 failed - '.$e->getMessage()."\n");
}

fwrite(STDOUT, "4050\n");
try {
	$db->query("ALTER TABLE versions ADD stackTrace text AFTER note;");
} catch (\Exception $e) {
	fwrite(STDOUT, '4050 failed - '.$e->getMessage()."\n");
}

fwrite(STDOUT, "4060\n");
try {
	$db->query("ALTER TABLE `versions` ADD INDEX `date` (`date`);");
} catch (\Exception $e) {
	fwrite(STDOUT, '4060 failed - '.$e->getMessage()."\n");
}

fwrite(STDOUT, "4079\n");
try {
	$db->query("ALTER TABLE `schedule_tasks` ADD INDEX `version` (`version`);");
} catch (\Exception $e) {
	fwrite(STDOUT, '4079 failed - '.$e->getMessage()."\n");
}

fwrite(STDOUT, "4093\n");
try {
	$db->query("ALTER TABLE `tags` CHANGE COLUMN `idPath` `idPath` VARCHAR(190) NULL DEFAULT NULL;");
	$db->query("ALTER TABLE `tracking_events` CHANGE COLUMN `category` `category` VARCHAR(190) NULL DEFAULT NULL;");
	$db->query("ALTER TABLE `tracking_events` CHANGE COLUMN `action` `action` VARCHAR(190) NULL DEFAULT NULL;");
	$db->query("ALTER TABLE `tracking_events` CHANGE COLUMN `label` `label` VARCHAR(190) NULL DEFAULT NULL;");
	$db->query("ALTER TABLE `tracking_events` CHANGE COLUMN `data` `data` VARCHAR(190) NULL DEFAULT NULL;");
	$db->query("ALTER TABLE `users` CHANGE COLUMN `password` `password` VARCHAR(190) NULL DEFAULT NULL;");
	$db->query("ALTER TABLE `website_settings` CHANGE COLUMN `name` `name` VARCHAR(190) NULL DEFAULT '';");
	$db->query("ALTER TABLE `classificationstore_stores` CHANGE COLUMN `name` `name` VARCHAR(190) NULL DEFAULT NULL;");
	$db->query("ALTER TABLE `classificationstore_groups` CHANGE COLUMN `name` `name` VARCHAR(190) NULL DEFAULT '';");
	$db->query("ALTER TABLE `classificationstore_keys` CHANGE COLUMN `name` `name` VARCHAR(190) NULL DEFAULT '';");
	$db->query("ALTER TABLE `classificationstore_keys` CHANGE COLUMN `type` `type` VARCHAR(190) NULL DEFAULT NULL;");
} catch (\Exception $e) {
	fwrite(STDOUT, '4093 failed - '.$e->getMessage()."\n");
}

fwrite(STDOUT, "4095\n");
try {
	$list = new \Pimcore\Model\Object\Fieldcollection\Definition\Listing();
	$list = $list->load();

	/** @var  $collectionDef \Pimcore\Model\Object\Fieldcollection\Definition*/
	foreach ($list as $collectionDef) {
		$needsSave = false;

		$fieldDefinitions = $collectionDef->getFieldDefinitions();
		$needsSave |= check($fieldDefinitions, $needsSave);

		if ($needsSave) {
			$collectionDef->save();
		}
	}
} catch (\Exception $e) {
	fwrite(STDOUT, '4095 failed - '.$e->getMessage()."\n");
}

fwrite(STDOUT, "4104\n");
//change columnType for existing class definitions
$classList = new \Pimcore\Model\Object\ClassDefinition\Listing();
$classes = $classList->load();
if(is_array($classes)){
    foreach($classes as $class){
        $doSave = false;
        foreach ($class->getFieldDefinitions() as $fieldDef) {
            if($fieldDef instanceof \Pimcore\Model\Object\ClassDefinition\Data\Select) {
                $fieldDef->setQueryColumnType("varchar");
                $fieldDef->setColumnType("varchar");
                $doSave = true;
            }
        }
        if($doSave){
            $class->save();
        }
    }
}

\Pimcore\Cache::clearAll();
fwrite(STDOUT, "done\n");
