<?php

class DefaultController extends \Website\Controller\BaseController 
{

	/*						DOCUMENT ROUTED ACTIONS							*/

	public function indexAction()
	{
		$this->enableLayout();
	}

	public function defaultAction ()
	{
		if(!$this->editmode && !\Pimcore\Tool::isFrontentRequestByAdmin()) {
			$this->gotoUrl($this->view->docUrl('/'.$this->defaultLanguage), 301);
		}
	}

	public function emptyPageAction()
	{
		if (!$this->editmode && !\Pimcore\Tool::isFrontentRequestByAdmin()) {
			$childs = $this->document->getChilds();
			if (empty($childs)) {
				throw new \Zend_Controller_Action_Exception($this->translate('system_page_not_found'), 404);
			} else {
				$this->gotoUrl(current($childs)->getFullPath(), 301);
			}
		}
	}

	public function errorPageAction()
	{
		\Pimcore\Cache::disable();

		$errorHandler = $this->getRequest()->getParam('error_handler');
		$exception = $errorHandler->exception;

		//this catches administration previews and maybe some other cases?
		if (!$exception) $exception = new \Zend_Exception ('', 404);

		if ($exception->getCode() == 404) {
			$this->enableLayout();
			$this->view->withLayout = true;
			$this->view->content = '<h1>Požadovaná stránka neexistuje</h1>';
		} else {
			$this->disableLayout();
			$this->view->content = '<h1>Chyba aplikace</h1>';
			\Pimcore\Log\Simple::log('exceptions', $exception->getMessage() . "\n" . $exception->getTraceAsString());
		}

		$this->getResponse()->setHttpResponseCode($exception->getCode());
	}



	/* 						STATIC-ROUTE ROUTED ACTIONS						 */



	/*							VIEW-LESS ACTIONS							*/



	public function downloadAssetAction()
	{
		//@TODO check for ownership
		$this->disableLayout();
		$this->disableViewAutoRender();

		$id = $this->getRequest()->getParam('id');
		$asset = Asset::getById($id);
		if (!$asset) {
			$this->addErrorMsg($this->translate('msg_invalid_request'));
		}

		//@TODO name from meta data...
		$name = substr(basename($asset->getFilename()), (stripos($asset->getFilename(), '_')) ? stripos($asset->getFilename(), '_') + 1 : 0);
		header('Content-Description: File Transfer');
		header('Content-Type: application/octet-stream');
		header('Content-Disposition: attachment; filename='.$name);
		header('Content-Transfer-Encoding: binary');
		header('Expires: 0');
		header('Cache-Control: must-revalidate, post-check=0, pre-check=0');
		header('Pragma: public');
		header('Content-Length: ' . filesize($asset->getFileSystemPath()));
		ob_clean();
		flush();
		readfile($asset->getFileSystemPath());
		exit;
	}

	public function sitemapXmlAction()
	{
		$this->disableLayout();
		$this->disableViewAutoRender();

		$file = sprintf(PIMCORE_WEBSITE_PATH.'/var/tmp/sitemap%s.xml', (\Pimcore\Model\Site::isSiteRequest()) ? \Pimcore\Model\Site::getCurrentSite()->getRootDocument()->getProperty('language') : '');
		$timestamp = (file_exists($file)) ? filemtime($file) : 0;
		if ((time() - $timestamp) < 86400) {
			$xml = file_get_contents($file);
		} else {
			$xml = null;
		}
		if (!$xml) {
			$xml = '<?xml version="1.0" encoding="UTF-8"?><urlset xmlns="http://www.sitemaps.org/schemas/sitemap/0.9">';
			$db = \Pimcore\Db::get();
			$validLanguages = \Website\Tool\Utils::getValidFrontendLanguages();
			$rootDocumentsIds = $db->select()->from('documents', array('documents.id'))
			->join('documents_page', 'documents.id = documents_page.id', array())
			->joinLeft('properties', 'documents_page.id = properties.cid', array())
			->where('documents_page.id = '.\Website\Tool\Utils::DOCUMENT_ROOT.' OR documents_page.contentMasterDocumentId = ?', \Website\Tool\Utils::DOCUMENT_ROOT)
			->where('properties.name = ?', 'language')
			->query()->fetchAll(\Zend_Db::FETCH_COLUMN);
			$accountDocumentsIds = $db->select()->from('documents', array('documents.id'))
			->join('documents_page', 'documents.id = documents_page.id', array())
			->where('documents_page.contentMasterDocumentId = ?', \Website\Tool\Utils::DOCUMENT_ACCOUNT)
			->query()->fetchAll(\Zend_Db::FETCH_COLUMN);
			$accountDocumentsIds[] = \Website\Tool\Utils::DOCUMENT_ACCOUNT;
			foreach ($rootDocumentsIds as $rootDocumentId) {
				$csRoot = \Pimcore\Model\Document\Page::getById($rootDocumentId);
				$language = $csRoot->getProperty('language');
				if (!in_array($language, $validLanguages)) continue;
				if (\Pimcore\Model\Site::isSiteRequest() && \Pimcore\Model\Site::getCurrentSite()->getRootId() != $rootDocumentId) continue;
				//add documents
				$queue = array($csRoot);
				while ($page = array_shift($queue)) {
					if ($page instanceof \Pimcore\Model\Document\Page && !in_array($page->getId(), $accountDocumentsIds)) {
						$xml .= sprintf('<url><loc>%s</loc><lastmod>%s</lastmod><changefreq>monthly</changefreq></url>', $this->view->serverUrl().$page->getFullPath(), date('Y-m-d', $page->getModificationDate()));
						if ($page->hasChilds()) foreach ($page->getChilds () as $child) {
							$queue[] = $child;
						}
					}
				}
				//add news
				$newsList = new \Website\Model\News\Listing();
				$newsList->load();
				foreach ($newsList->getItems(0, 0) as $news) {
					$xml .= sprintf('<url><loc>%s</loc><lastmod>%s</lastmod><changefreq>monthly</changefreq></url>',
						$this->view->serverUrl(). $news->getUrl($language),
						date('Y-m-d', $news->getModificationDate())
					);
				}
			}

			$xml .= sprintf('</urlset>');

			$handle = fopen($file, 'w');
			fwrite($handle, $xml);
			fclose($handle);
		}
		
		header('Content-Description: File Transfer');
		header('Content-Type: application/octet-stream');
		header('Content-Disposition: attachment; filename='.basename('sitemap.xml'));
		header('Content-Transfer-Encoding: binary');
		header('Expires: 0');
		header('Cache-Control: must-revalidate, post-check=0, pre-check=0');
		header('Pragma: public');
		
		echo $xml;
		exit;
	}



	/*							FORM HANDLERS								*/

}
