<?php

namespace Website\Model;

class News extends \Pimcore\Model\Object\News implements IElasticObjectFulltext 
{

	private $url = array();

	/*								Helpers										*/

	public function getUrl($language = null)
	{
		if (!$language) $language = \Website\Tool\Utils::getDefaultLanguage();

		if (!isset($this->url[$language])) {
			$this->url[$language] = \Website\Tool\Utils::url('news-'.$language, array('id' => $this->getId(), 'slug' => $this->getSlug()));
		}

		return $this->url[$language];
	}

	/*								Mapped										*/

	public function save()
	{
		if (parent::getId()) {
			$systemLanguages = \Pimcore\Tool::getValidLanguages();
			foreach ($systemLanguages as $lang) {
				parent::setSlug(\Website\Tool\Utils::webalize(parent::getName($lang)), $lang);
			}

			if (\Website\Tool\Utils::elasticSearchEnabled()) {
				$this->elasticSearchUpdateFulltext();
			}
		}

		parent::save();
	}

	public function delete()
	{
		$id = parent::getId();

		parent::delete();

		if (\Website\Tool\Utils::elasticSearchEnabled()) {
			\Website\Tool\ElasticSearch::delete($id, \Website\Tool\ElasticSearch::OBJECT_TYPE_KEY);
		}
	}

	/* 								For elastic search							 */

	/**
	 * indexed the news object data into elastic search at current index
	 */
	public function elasticSearchUpdateFulltext()
	{
		$indexName = \Website\Tool\ElasticSearch::getMainIndexName();
		$systemLanguages = \Pimcore\Tool::getValidLanguages();
		$elasticClient = \Website\Tool\ElasticSearch::getClient();

		foreach ($systemLanguages as $lang) {
			$data = $this->elasticSearchLoadFulltext($lang);
			$elasticClient->index(array(
				'index' => $indexName,
				'type' => \Website\Tool\ElasticSearch::OBJECT_TYPE_KEY . '_' . $lang,
				'id' => $data['id'],
				'body' => $data
			));

			if (!\Website\Tool\ElasticSearch::isUpdateRequest()) {
				$elasticClient->indices()->refresh(array('index' => $indexName));
			}
		}
	}

	/**
	 * returns elastic search document data structure 
	 * @param string $lang
	 * @return array
	 */
	public function elasticSearchLoadFulltext($lang)
	{
		$view = new \Pimcore\View();
		$view->setScriptPath(array(
			PIMCORE_WEBSITE_PATH . '/views/scripts',
			PIMCORE_WEBSITE_PATH . '/views/layouts'
		));
		$view->addHelperPath(PIMCORE_WEBSITE_PATH . '/lib/Website/View/Helper', '\\Website\\View\\Helper');
		$view->news = $this;

		$data = array(
			'id' => $this->getId(),
			'path' => $this->getUrl($lang),
			'published' => $this->isPublished(),
			'title' => $this->getName($lang),
			'keywords' => $this->getSeoKeywords($lang),
			'description' => $this->getSeoDescription($lang),
			'content' => \Website\Tool\ElasticSearch::normalizeText($view->render('cms/news-detail.php'))
		);

		return $data;
	}

}
