<?php

namespace Website\Tool;

class Utils
{
	//hardcoded pimcore IDs
	const DOCUMENT_ROOT = 2;
	const DOCUMENT_ACCOUNT = 12;

	const SALT = 'hopcipcibirybcibirybhopaa';

	private static $inheritance;
	private static $fallback;
	private static $languageSwitch = null;
	public static $defaultLanguage = null;

	/**
	 * returns the default website language (the first from system settings)
	 * default language should match the language property of master document tree
	 * @return string default language ISO 639-1
	 */
	public static function getDefaultLanguage()
	{
		if (self::$defaultLanguage === null) {
			$config = \Pimcore\Config::getSystemConfig();
			self::$defaultLanguage = current(explode(',', $config->general->validLanguages));
		}
		
		return self::$defaultLanguage;
	}

	/**
	 * defines the valid frontend languages as a subset of valid admin languages
	 * used when we need to add another language in the admin, but don't want to break the site while filling in all the localized data...
	 * @return array valid languages (ISO 639-1)
	 */
	public static function getValidFrontendLanguages()
	{
		$config = \Pimcore\Config::getWebsiteConfig();
		$allowed = explode(',', $config->get('frontendLanguages', self::getDefaultLanguage()));
		$combined = array();

		foreach (\Pimcore\Tool::getValidLanguages() as $language) {
			if (in_array($language, $allowed)) {
				$combined[] = $language;
			}
		}

		return $combined;
	}

	public static function thumbnail($image, $thumbnail)
	{
		if ($image instanceof \Pimcore\Model\Asset\Image) {
			return (string)$image->getThumbnail($thumbnail);
		} else {
			return '';
		}
	}

	/**
	 * @param mixed $image image asset or hotspot image
	 * @param string $thumbnail image thumbnail pipeline name
	 * @param array $additionalOptions additional options (see pimcore document image editable documentation)
	 * @param mixed $fallbackImage image asset or image asset ID or image asset path
	 * @return string HTML image element like the document image editable
	 */
	public static function image($image, $thumbnail, $fallbackImage = null, $additionalOptions = array())
	{
		$html = null;
		$imageTag = new \Pimcore\Model\Document\Tag\Image();
		if ($image instanceof \Pimcore\Model\Document\Tag\Image && $image->getImage()) {
			$imageTag = $image;
		} elseif ($image instanceof \Pimcore\Model\Asset\Image) {
			$imageTag->setImage($image);
		} elseif ($image instanceof \Pimcore\Model\Object\Data\Hotspotimage && $image->getImage()) {
			$html = $image->getThumbnail($thumbnail)->getHTML($additionalOptions);
		} elseif ($fallbackImage instanceof \Pimcore\Model\Asset\Image) {
			$imageTag->setImage($fallbackImage);
		} elseif ($fallbackImage) {
			$image = \Pimcore\Model\Asset\Image::getById($fallbackImage);
			if (!$image) $image = \Pimcore\Model\Asset\Image::getByPath($fallbackImage);
			if ($image) $imageTag->setImage($image);
		}

		if (!$html) {
			$additionalOptions['thumbnail'] = $thumbnail;
			$imageTag->setOptions($additionalOptions);
			$html = $imageTag->frontend();
		}

		return $html;
	}

	public static function url($staticRoute, $params = array())
	{
		if (!$staticRoute instanceof \Pimcore\Model\Staticroute) {
			$staticRoute = \Pimcore\Model\Staticroute::getByName($staticRoute, (\Pimcore\Model\Site::isSiteRequest()) ? \Pimcore\Model\Site::getCurrentSite()->getId() : 0);
		}
				
		if (!$staticRoute) return '/';

		return $staticRoute->assemble($params, true);
	}

	public static function docUrl($realFullPath, $language)
	{
		$languageSwitch = self::getLanguageSwitch($language, $realFullPath);

		return (isset($languageSwitch[$language])) ? $languageSwitch[$language] : '/';
	}

	public static function getLanguageSwitch($language, $section)
	{
		$switcher = (self::$languageSwitch) ? self::$languageSwitch : \Pimcore\Cache::load('language_switcher_' . $language);
		if (!$switcher) {
			$switcher = array();
			$parent = \Pimcore\Model\Document\Page::getById(1);
			$languages = \Website\Tool\Utils::getValidFrontendLanguages();
			$originLanguage = $parent->getProperty('language');
			$queue = array($parent);
			$db = \Pimcore\Db::get();
			while (!empty($queue)) {
				$masterDocument = array_shift($queue);

				foreach ($masterDocument->getChilds() as $child) {
					if ($child instanceof \Pimcore\Model\Document\Page && $child->isPublished()) {
						$switcher[$child->getRealFullPath()] = array();
						if ($child->getProperty('language') == $originLanguage) {
							$queue[] = $child;
						}
					}
				}

				if ($masterDocument->getId() != 1) {
					$query = $db->select()->from('documents', array('documents.id'))
						->join('documents_page', 'documents.id = documents_page.id', array())
						->where('documents_page.contentMasterDocumentId = ?', $masterDocument->getId())
						->query()->fetchAll();
					$sibblings = array($masterDocument);
					foreach ($query as $row) {
						$page = \Pimcore\Model\Document\Page::getById($row['id']);
						if ($page->isPublished() && in_array($page->getProperty('language'), $languages)) {
							$sibblings[] = $page;
						}
					}
					//corresponding documents in another languages
					foreach ($sibblings as $sibbling) {
						foreach ($sibblings as $sibbling2) {
							$switcher[$sibbling->getRealFullPath()][$sibbling2->getProperty('language')] = $sibbling2->getFullPath();
							$switcher[$sibbling2->getRealFullPath()][$sibbling->getProperty('language')] = $sibbling->getFullPath();
						}
					}
				}
			}

			# global cache, for frontend requests
			if (!\Pimcore\Tool::isFrontentRequestByAdmin()) {
				\Pimcore\Cache::save($switcher, 'language_switcher_' . $language, array('output'));
			}
		}

		# per-request cache, for administration
		self::$languageSwitch = $switcher;

		return (is_array($switcher) && isset($switcher[$section])) ? $switcher[$section] : array();
	}

	public static function elasticSearchEnabled()
	{
        return (@class_exists('\\Elasticsearch\\Client'));
	}

	public static function forceInheritanceAndFallbackValues($inherit = true)
	{
		self::$inheritance = \Pimcore\Model\Object\AbstractObject::getGetInheritedValues();
		self::$fallback = \Pimcore\Model\Object\Localizedfield::getGetFallbackValues();
		\Pimcore\Model\Object\AbstractObject::setGetInheritedValues($inherit);
		\Pimcore\Model\Object\Localizedfield::setGetFallbackValues($inherit);
	}

	public static function restorInheritanceAndFallbackValues()
	{
		\Pimcore\Model\Object\AbstractObject::setGetInheritedValues(self::$inheritance);
		\Pimcore\Model\Object\Localizedfield::setGetFallbackValues(self::$fallback);
	}

	public static function profilerStart()
	{
		$profiler = \Pimcore\Db::get()->getProfiler();
		$profiler->setEnabled(true);
	}
	
	public static function profilerStop()
	{
		$profiler = \Pimcore\Db::get()->getProfiler();
		if ($profiler->getQueryProfiles()) {
			foreach ($profiler->getQueryProfiles() as $query) {
				echo $query->getQuery() . ', time: ' . $query->getElapsedSecs() . '<br>';
			}
		} else {
			echo 'nada';
		}
		exit;
	}

	public static function loadAssets($rootFolderOrAssetArray = array(), $allowedTypes = array('image'))
	{
		$queue = array();
		if ($rootFolderOrAssetArray instanceof \Pimcore\Model\Asset\Folder) {
			$queue[] = $rootFolderOrAssetArray;
		} elseif (is_array($rootFolderOrAssetArray)) {
			$queue = $rootFolderOrAssetArray;
		} else {
			$root = \Pimcore\Model\Asset\Folder::getById($rootFolderOrAssetArray);
			if ($root)
				$queue[] = $root;
		}

		$assets = array();
		while ($asset = array_shift($queue)) {
			if (!$asset instanceof \Pimcore\Model\Asset)
				continue;

			if ($asset instanceof \Pimcore\Model\Asset\Folder) {
				foreach ($asset->getChilds() as $child) {
					$queue[] = $child;
				}
			} elseif (in_array($asset->getType(), $allowedTypes)) {
				$assets[] = $asset;
			}
		}
		return $assets;
	}

	public static function loadMoreItems($listObjectOrClassName, $limit, $offsetId = 0, $orderKey = 'o_id', $order = 'asc', $additionalConditionsAsString = null)
	{
		$result = array('items' => array(), 'offsetId' => null);

		//load the offset item if needed
		$itemClass = str_replace('\\Listing', '', (is_object($listObjectOrClassName)) ? get_class($listObjectOrClassName) : $listObjectOrClassName);
		if ($offsetId) {
			$offsetItem = $itemClass::getById($offsetId);
			if (!$offsetItem) return $result;
		}

		//just in case
		if ($orderKey == 'o_id' && substr($itemClass, 0, 6) != 'Object') {
			$orderKey = 'id';
		}

		//create the list
		$list = (is_object($listObjectOrClassName)) ? $listObjectOrClassName : new $listObjectOrClassName();
		if (!$list) return $result;

		//create the condition
		$conditions = array();
		if ($additionalConditionsAsString) $conditions[] = $additionalConditionsAsString;
		if ($list->getCondition()) $conditions[] = $list->getCondition();
		if ($offsetId) {
			$offsetValue = $offsetItem->{'get'.ucfirst($orderKey)}();
			if ($offsetValue instanceof \Pimcore\Date) $offsetValue = $offsetValue->getTimestamp();
			$conditions[] = sprintf('`%s` %s %s', $orderKey, ($order == 'asc') ? '>=' : '<=', $list->quote($offsetValue));
		}

		//load the list
		$list->setOrderKey($orderKey);
		$list->setOrder($order);
		$list->setLimit($limit + 1); # +1 because we want to check if there are more items
		$list->setCondition(implode(' AND ', $conditions));
		$list->load();

		//remove last item and set next offset ID
		$items = $list->getItems(0, 0);
		if (count($items) > $limit) {
			$tmp = array_pop($items);
			$result['offsetId'] = $tmp->getId();
		}
		$result['items'] = $items;

		return $result;
	}

	//Text stuff

	public static function webalize($path)
	{
		return trim(preg_replace('#-+#', '-', str_replace('.', '-', \Pimcore\File::getValidFilename($path))), '-');
	}

	public static function toCacheKey($text)
	{
		return str_replace('-', '_', self::webalize($text));
	}

	public static function cutStringRespectingWhitespace($string, $length, $suffix = '...')
	{
		if ($length < strlen($string)) {
			$text = substr($string, 0, $length);
			if (false !== ($length = strrpos($text, ' '))) {
				$text = substr($text, 0, $length);
			}
			$string = $text . $suffix;
		}
		return $string;
	}

	public static function mb_ucfirst($string, $encoding = 'utf-8')
	{
		$strlen = mb_strlen($string, $encoding);
		$firstChar = mb_substr($string, 0, 1, $encoding);
		$restOfString = mb_substr($string, 1, $strlen - 1, $encoding);

		return mb_strtoupper($firstChar, $encoding) . $restOfString;
	}

	public static function mb_lcfirst($string, $encoding = 'utf-8')
	{
		$strlen = mb_strlen($string, $encoding);
		$firstChar = mb_substr($string, 0, 1, $encoding);
		$restOfString = mb_substr($string, 1, $strlen - 1, $encoding);

		return mb_strtolower($firstChar, $encoding) . $restOfString;
	}

	public static function czechMonth($month)
	{
		static $arr = array(1 => 'leden', 'únor', 'březen', 'duben', 'květen', 'červen', 'červenec', 'srpen', 'září', 'říjen', 'listopad', 'prosinec');
		return $arr[$month];
	}

	public static function czechDay($day)
	{
		$days = array('neděle', 'pondělí', 'úterý', 'středa', 'čtvrtek', 'pátek', 'sobota');
		return $days[$day];
	}

	public static function formatSizeUnits($size)
	{
		if ($size >= 1073741824) {
			$bytes = number_format($size / 1073741824, 2, ',', ' ') . ' GB';
		} elseif ($size >= 1048576) {
			$bytes = number_format($size / 1048576, 2, ',', ' ') . ' MB';
		} elseif ($size >= 1024) {
			$bytes = number_format($size / 1024, 2, ',', ' ') . ' KB';
		} elseif ($size > 1) {
			$bytes = $size . ' B';
		} elseif ($size == 1) {
			$bytes = $size . ' B';
		} else {
			$bytes = '0 B';
		}

		return $bytes;
	}

	public static function encrypt($text)
	{
		return trim(base64_encode(mcrypt_encrypt(MCRYPT_RIJNDAEL_256, self::SALT, $text, MCRYPT_MODE_ECB, mcrypt_create_iv(mcrypt_get_iv_size(MCRYPT_RIJNDAEL_256, MCRYPT_MODE_ECB), MCRYPT_RAND))));
	}

	public static function decrypt($text)
	{
		return trim(mcrypt_decrypt(MCRYPT_RIJNDAEL_256, self::SALT, base64_decode($text), MCRYPT_MODE_ECB, mcrypt_create_iv(mcrypt_get_iv_size(MCRYPT_RIJNDAEL_256, MCRYPT_MODE_ECB), MCRYPT_RAND)));
	}

	public static function serialize($data)
	{
		return base64_encode(serialize($data));
	}

	public static function unserialize($data)
	{
		return unserialize(base64_decode($data));
	}

	public static function detectCzechEncoding($s)
	{
		if (preg_match('#[\x80-\x{1FF}\x{2000}-\x{3FFF}]#u', $s))
			return 'UTF-8';

		if (preg_match('#[\x7F-\x9F\xBC]#', $s))
			return 'WINDOWS-1250';

		return 'ISO-8859-2';
	}

	/**
	 * Returns the total width in points of the string using the specified font and
	 * size.
	 *
	 * This is not the most efficient way to perform this calculation. I'm
	 * concentrating optimization efforts on the upcoming layout manager class.
	 * Similar calculations exist inside the layout manager class, but widths are
	 * generally calculated only after determining line fragments.
	 * 
	 * @link http://devzone.zend.com/article/2525-Zend_Pdf-tutorial#comments-2535 
	 * @param string $string
	 * @param \Zend_Pdf_Resource_Font $font
	 * @param float $fontSize Font size in points
	 * @return float
	 */
	public static function widthForStringUsingFontSize($string, $font, $fontSize)
	{
		$drawingString = iconv('UTF-8', 'UTF-16BE//IGNORE', $string);
		$characters = array();
		for ($i = 0; $i < strlen($drawingString); $i++) {
			$characters[] = (ord($drawingString[$i++]) << 8 ) | ord($drawingString[$i]);
		}
		$glyphs = $font->glyphNumbersForCharacters($characters);
		$widths = $font->widthsForGlyphs($glyphs);
		$stringWidth = (array_sum($widths) / $font->getUnitsPerEm()) * $fontSize;
		return $stringWidth;
	}

}
