<?php

/**
 * Simple helper that helps to convert model responses to flash messages in the controller.
 *
 * @author Martin Kuric <martin.kuric@portadesign.cz>
 */
namespace Website\Controller\Action\Helper;

class HandleModelResponse extends \Zend_Controller_Action_Helper_Abstract
{
	/**
	 * 	Sets translated and formated falsh messages based on the input params.
	 *
	 * @param array $response associative array with keys "status", "key", "args" and "disableTranslation"
	 *
	 * @return int returns the "status" key from $response parameter
	 */
	public function direct(array $response)
	{
		$translate = isset($response['disableTranslation']) ? false : true;
		$translator = \Zend_Registry::get('Zend_Translate');
		$flashMessenger = \Zend_Controller_Action_HelperBroker::getStaticHelper('FlashMessenger');

		switch ($response['status']) {
			//for propagating error without setting the flash message
			case -2:
				return -1;
				break;
			case -1:
				if ($translate) {
					if (isset($response['args'])) {
						$flashMessenger->setNamespace('error')->addMessage(vsprintf($translator->translate($response['key']), $response['args']));
					} else {
						$flashMessenger->setNamespace('error')->addMessage($translator->translate($response['key']));
					}
				} else {
					if (isset($response['args'])) {
						$flashMessenger->setNamespace('error')->addMessage(vsprintf($response['key'], $response['args']));
					} else {
						$flashMessenger->setNamespace('error')->addMessage($response['key']);
					}
				}
				break;
			case 0:
				if ($translate) {
					if (isset($response['args'])) {
						$flashMessenger->setNamespace('info')->addMessage(vsprintf($translator->translate($response['key']), $response['args']));
					} else {
						$flashMessenger->setNamespace('info')->addMessage($translator->translate($response['key']));
					}
				} else {
					if (isset($response['args'])) {
						$flashMessenger->setNamespace('info')->addMessage(vsprintf($response['key'], $response['args']));
					} else {
						$flashMessenger->setNamespace('info')->addMessage($response['key']);
					}
				}
				break;
			case 1:
				if ($translate) {
					if (isset($response['args'])) {
						$flashMessenger->setNamespace('success')->addMessage(vsprintf($translator->translate($response['key']), $response['args']));
					} else {
						$flashMessenger->setNamespace('success')->addMessage($translator->translate($response['key']));
					}
				} else {
					if (isset($response['args'])) {
						$flashMessenger->setNamespace('success')->addMessage(vsprintf($response['key'], $response['args']));
					} else {
						$flashMessenger->setNamespace('success')->addMessage($response['key']);
					}
				}
				break;
			//for propagating success without setting flash message
			case 2:
				return 1;
				break;
		}

		return $response['status'];
	}
}
