<?php

namespace Website\Model;

class FileManager
{
	const MAX_FILE_SIZE = 10485760;

	public function __construct()
	{
	}

	public function uploadFile(\Zend_Form_Element_File $fileUpload, \Pimcore\Model\Object\Concrete &$object, $fieldName, $part = 1, $uploadFolderPath = null, $subFolder = true)
	{
		$part = $part - 1; // pimcore multihref data component is indexing from 0
		$fieldDefinition = $object->getClass()->getFieldDefinition($fieldName);

		if (!$uploadFolderPath) {
			$uploadFolderPath = '/';
		}
		if ($subFolder) {
			$uploadFolderPath .= '/'.$object->getKey();
		}
		try {
			\Pimcore\Model\Asset\Service::createFolderByPath($uploadFolderPath);
		} catch (\Exception $e) {
			\Pimcore\Log\Simple::log('exceptions', 'CREATING UPLOAD FOLDER - '.$e->getMessage()."\n".$e->getTraceAsString());

			return false;
		}
		$uploadFolderId = \Pimcore\Model\Asset\Folder::getByPath($uploadFolderPath)->getId();

		//first remove existing if exists :)
		$getter = 'get'.ucfirst($fieldName);
		$files = (array) $object->$getter();
		if (isset($files[$part])) {
			try {
				$files[$part]->delete();
			} catch (\Exception $e) {
				\Pimcore\Log\Simple::log('exceptions', 'DELETING FILE - '.$e->getMessage()."\n".$e->getTraceAsString());
			}
		}

		$fileInfo = current($fileUpload->getFileInfo());
		$fileName = \Pimcore\File::getValidFilename(date('Y-m-d-H-i-s-').$fieldName.$part.'_'.$fileInfo['name']);
		//try to remove previous asset by name (due to possible collision when created from administration for example...)
		$tmp = Asset::getByPath($uploadFolderPath.'/'.$fileName);
		if ($tmp) {
			try {
				$tmp->delete();
			} catch (\Exception $e) {
				\Pimcore\Log\Simple::log('exceptions', 'DELETING FILE - '.$e->getMessage()."\n".$e->getTraceAsString());
			}
		}
		$asset = new Asset();
		$asset->setParentId($uploadFolderId);
		$asset->setCreationDate(time());
		$asset->setFilename($fileName);
		$asset->setUserModification(1);
		$asset->setData(file_get_contents($fileInfo['tmp_name']));
		try {
			$asset->save();
		} catch (\Exception $e) {
			\Pimcore\Log\Simple::log('exceptions', 'CREATING FILE - '.$e->getMessage()."\n".$e->getTraceAsString());

			return false;
		}
		$setter = 'set'.ucfirst($fieldName);
		if ($fieldDefinition->fieldtype == 'href' || $fieldDefinition->fieldtype == 'image') {
			$object->$setter($asset);
		} else {
			$files[$part] = $asset;
			$object->$setter($files);
		}

		return true;
	}
}
