<?php

namespace Website\Tool\Console\Command;

use Pimcore\Console\AbstractCommand;
use Symfony\Component\Console\Input\InputArgument;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Output\OutputInterface;

class DeploymentClassUpdateCommand extends AbstractCommand
{
	protected function configure()
	{
		$this
			->setName('deployment:class-update')
			->setDescription('Create, update or delete class based on its definition file')
			->addArgument(
				'id',
				InputArgument::REQUIRED,
				'Class ID'
			)
			->addArgument(
				'name',
				InputArgument::REQUIRED,
				'Class name'
			)
			->addArgument(
				'icon',
				InputArgument::OPTIONAL,
				'Class icon'
			);
	}

	protected function execute(InputInterface $input, OutputInterface $output)
	{
		$id = trim($input->getArgument('id'));
		$name = trim($input->getArgument('name'));
		$icon = trim($input->getArgument('icon'));
		try {
			$class = \Pimcore\Model\Object\ClassDefinition::getById($id);
			$definitionPath = PIMCORE_WEBSITE_VAR.'/classes/definition_'.$id.'.psf';
			if (!$class) {
				if (file_exists($definitionPath)) {
					$generator = new \Website\Model\Generator();
					$id = $generator->createClassDefinition($name, false, false, $icon, $id, $definitionPath);
					if (!$id) {
						throw new \Exception(sprintf(
							'Class %s [%d] could not be created. See %s for details.',
							$name,
							$id,
							'/website/var/log/generator.log'
						));
					}
					$output->writeln(sprintf('Class %s [%d] created', $name, $id));
				} else {
					throw new \Exception(sprintf('Class with ID %d does not exist', $id));
				}
			} else {
				$className = $class->getName();
				if (file_exists($definitionPath)) {
					$class->save();
					$output->writeln(sprintf('Class %s updated', $className));
				} else {
					$class->delete();
					$output->writeln(sprintf('Class %s deleted', $className));
				}
			}
		} catch (\Exception $e) {
			$output->writeln(sprintf('<error>%s</error>', $id, $e->getMessage()));
		}
	}
}
