<?php


$baseMapping = [
	'id' => ['type' => 'integer', 'include_in_all' => false],
	'parentId' => ['type' => 'integer', 'include_in_all' => false],
	'key' => ['type' => 'string', 'include_in_all' => false, 'index' => 'not_analyzed'],
	'type' => ['type' => 'string', 'include_in_all' => false, 'index' => 'not_analyzed'],
	'published' => ['type' => 'boolean', 'include_in_all' => false],
];

return [
	'default_mapping' => [
		'meta' => [
			'languages' => [\Website\Tool\Utils::getDefaultLanguage()],
		],
		'properties' => $baseMapping,
	],
	'fulltext_mapping' => [
		'meta' => [
			'languages' => \Pimcore\Tool::getValidLanguages(),
			'fulltextFields' => ['title', 'description', 'content'],
		],
		'properties' => array_merge($baseMapping, [
			'path' => ['type' => 'string', 'include_in_all' => false],
		]),
	],
];
