<?php

namespace Website\Tool\Setup;

use Composer\Script\Event;
use Composer\Util\Filesystem;

class Composer
{
	public static function postCreateProject(Event $event)
	{
		$config = $event->getComposer()->getConfig();
		$rootPath = dirname($config->get('vendor-dir'));
		$projectName = basename($rootPath);

		// init composer
		rename($rootPath.'/composer.tmpl', $rootPath.'/composer.json');

		// init git
		$filesystem = new Filesystem();
		$filesystem->removeDirectory($rootPath.'/.git');
		rename($rootPath.'/gitignore.tmpl', $rootPath.'/.gitignore');
		exec('git init');
		exec(sprintf('git remote add origin https://portabucket@bitbucket.org/portabucket/%s.git', $projectName));

		// create database
		exec(sprintf('mysql --login-path=deployment -e "create database %s character set utf8 collate utf8_general_ci"', $projectName));

		// init readme
		$contents = preg_replace(
			'/###TITLE###/',
			sprintf('%s', ucfirst($projectName)),
			file_get_contents($rootPath.'/README.tmpl')
		);
		$repositoryUrl = sprintf('https://portabucket@bitbucket.org/portabucket/%s.git', $projectName);
		$contents = preg_replace(
			'/###REPOSITORY###/',
			$repositoryUrl,
			$contents
		);
		$fh = fopen($rootPath.'/README.md', 'w');
		fwrite($fh, $contents);
		fclose($fh);

		// cleanup
		$filesystem->removeDirectory($rootPath.'/website/tools/Update');
		@unlink($rootPath.'/README.tmpl');
	}
}
