<?php

set_time_limit(60000);
include_once __DIR__.'/../../../pimcore/cli/startup.php';
\Pimcore\Cache::clearAll();
$db = \Pimcore\Db::get();

fwrite(STDOUT, "3783\n");
$db->query('ALTER TABLE `classificationstore_relations`
	ADD COLUMN `mandatory` TINYINT(1) NULL DEFAULT NULL AFTER `sorter`;
');

fwrite(STDOUT, "3786\n");
// REDIRECTS: added active flag to enable/disable them
$db->query('ALTER TABLE `redirects` ADD COLUMN `active` tinyint(1) NULL DEFAULT NULL AFTER `priority`;');
$db->update('redirects', ['active' => 1]); // set all existing redirects to active
// no more individual configuration paths for executables
$config = \Pimcore\Config::getSystemConfig();
$existingConfigArray = $config->toArray();
$paths = [];
foreach (['ffmpeg', 'ghostscript', 'libreoffice', 'pngcrush', 'imgmin', 'jpegoptim', 'pdftotext'] as $app) {
	if (isset($config->assets->$app)) {
		$pathOnly = dirname($config->assets->$app);
		if (strlen($pathOnly) > 1) {
			$paths[] = $pathOnly;
		}

		unset($existingConfigArray['assets'][$app]);
	}
}
if (isset($config->general->php_cli)) {
	$pathOnly = dirname($config->general->php_cli);
	if (strlen($pathOnly) > 1) {
		$paths[] = $pathOnly;
	}

	unset($existingConfigArray['general']['php_cli']);
}
$newPath = implode(':', $paths);
$existingConfigArray['general']['path_variable'] = $newPath;
$configFile = \Pimcore\Config::locateConfigFile('system.php');
\Pimcore\File::putPhpFile($configFile, to_php_data_file_format($existingConfigArray));

fwrite(STDOUT, "3803\n");
$keywords = $db->fetchAll("SELECT id,keywords FROM documents_page WHERE LENGTH(IFNULL(keywords,'')) > 0");
$keywordList = '';
foreach ($keywords as $keyword) {
	$keywordList .= $keyword['id'].'|'.$keyword['keywords']."\n";
}
\Pimcore\File::put(PIMCORE_SYSTEM_TEMP_DIRECTORY.'/document-page-keyword-export.csv', $keywordList);
$db->query('ALTER TABLE documents_page DROP COLUMN keywords');

fwrite(STDOUT, "3808\n");
// add missing indexes
$db->query('ALTER TABLE `redirects` ADD INDEX `active` (`active`);');
$db->query('ALTER TABLE `classificationstore_relations` ADD INDEX `mandatory` (`mandatory`);');

fwrite(STDOUT, "3814\n");
$types = \Pimcore\Model\Document::getTypes();
$types[] = 'printpage';
$types[] = 'printcontainer';
$types = array_unique($types);
$db->query("
	ALTER TABLE documents
	CHANGE type type ENUM('".implode("', '", $types)."');
");
// add missing indexes
$db->query("CREATE TABLE IF NOT EXISTS `documents_printpage` (
	`id` int(11) unsigned NOT NULL DEFAULT '0',
	`module` varchar(255) DEFAULT NULL,
	`controller` varchar(255) DEFAULT NULL,
	`action` varchar(255) DEFAULT NULL,
	`template` varchar(255) DEFAULT NULL,
	`lastGenerated` int(11) DEFAULT NULL,
	`lastGenerateMessage` text CHARACTER SET utf8,
	PRIMARY KEY (`id`)
) DEFAULT CHARSET=utf8;
");

fwrite(STDOUT, "3815\n");
$db->query("INSERT INTO `users_permission_definitions` VALUES ('web2print_settings');");

\Pimcore\Cache::clearAll();
fwrite(STDOUT, "done\n");
