<?php
set_time_limit(60000);
include_once("../../pimcore/cli/startup.php");
$db = Pimcore_Resource_Mysql::get();
Pimcore_Model_Cache::clearAll();

fputs(STDOUT, "3174\n");
try {
    $db->query("ALTER TABLE `users` ADD COLUMN `apiKey` varchar(255) NULL DEFAULT NULL;");
} catch (\Exception $e) {

}

$conf = Pimcore_Config::getSystemConfig();

if($conf->webservice->enabled) {
    echo "<b>Warning</b>: You're using the webservice API, this update <b>resets all API keys!</b> <br />Please open the user management to set new API keys.";
}

fputs(STDOUT, "3183\n");
try{
    $db->query("ALTER TABLE `keyvalue_keys` CHANGE COLUMN `type` `type` enum('bool','number','select','text','translated','translatedSelect','range') NULL DEFAULT NULL;");
} catch (\Exception $e) {
    echo $e->getMessage();
	exit;
}

fputs(STDOUT, "3207\n");
try{
    $db->query("CREATE TABLE `keyvalue_translator_configuration` (
      `id` INT(10) NOT NULL AUTO_INCREMENT,
      `name` VARCHAR(200) NULL DEFAULT NULL,
      `translator` VARCHAR(200) NULL DEFAULT NULL,
      PRIMARY KEY (`id`)
    ) DEFAULT CHARSET=utf8;");

} catch (\Exception $e) {
    echo $e->getMessage();
	exit;
}

fputs(STDOUT, "3208\n");
try{

    $config = Pimcore_Config::getReportConfig()->toArray();

    if(isset($config["analytics"]) && is_array($config["analytics"]["sites"])) {
        foreach($config["analytics"]["sites"] as $siteKey => &$siteConfig) {
            if(!$siteConfig["universalcode"]) {
                $siteConfig["asynchronouscode"] = 1;
            }
        }
    }

    $config = new Zend_Config($config, true);
    $writer = new Zend_Config_Writer_Xml(array(
        "config" => $config,
        "filename" => PIMCORE_CONFIGURATION_DIRECTORY . "/reports.xml"
    ));
    $writer->write();

} catch (\Exception $e) {
    echo $e->getMessage();
	exit;
}

fputs(STDOUT, "3210\n");
try{
    // objectsmetadata inside localized fields/bricks/fieldcollection
    $tables = $db->fetchAll("SHOW TABLES LIKE 'object_metadata_%'");

    foreach ($tables as $table) {
        $t = current($table);

        $sql =  "ALTER TABLE `" . $t. "`
        ADD COLUMN `ownertype` ENUM('object','fieldcollection','localizedfield','objectbrick') NOT NULL DEFAULT 'object' AFTER `data`,
        ADD COLUMN `ownername` VARCHAR(70) NOT NULL DEFAULT '' AFTER `ownertype`,
        ADD COLUMN `position` VARCHAR(70) NOT NULL DEFAULT '0' AFTER `ownername`,
        DROP PRIMARY KEY,
        ADD PRIMARY KEY (`o_id`, `dest_id`, `fieldname`, `column`, `ownertype`, `ownername`, `position`),
        ADD INDEX `ownertype` (`ownertype`),
        ADD INDEX `ownername` (`ownername`),
        ADD INDEX `position` (`position`);";

        $db->query($sql);
    }
} catch (\Exception $e) {
    echo $e->getMessage();
	exit;
}

fputs(STDOUT, "3213\n");
try{
    $db->query("ALTER TABLE `assets_metadata`
	    CHANGE COLUMN `type` `type` ENUM('input','textarea','asset','document','object','date') DEFAULT NULL AFTER `language`;");
} catch (\Exception $e) {
    echo $e->getMessage();
	exit;
}

fputs(STDOUT, "3214\n");
try{
    $db->query("DROP TABLE IF EXISTS `assets_metadata_predefined`;");

    $db->query("CREATE TABLE `assets_metadata_predefined` (
                      `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
                      `name` varchar(255) DEFAULT NULL,
                      `description` text,
                      `language` varchar(255) DEFAULT NULL,
                      `type` enum('input','textarea','asset','document','object','date') DEFAULT NULL,
                      `data` text,
                      `targetSubtype` enum('image', 'text', 'audio', 'video', 'document', 'archive', 'unknown') DEFAULT NULL,
                      `creationDate` bigint(20) unsigned DEFAULT '0',
                      `modificationDate` bigint(20) unsigned DEFAULT '0',
                      PRIMARY KEY (`id`),
                      KEY `name` (`name`),
                      KEY `id` (`id`),
                      KEY `type` (`type`),
                      KEY `language` (`language`),
                      KEY `targetSubtype` (`targetSubtype`)
                    ) DEFAULT CHARSET=utf8;");
} catch (\Exception $e) {
    echo $e->getMessage();
}

fputs(STDOUT, "3221\n");
try{
    $db->query("ALTER TABLE `users_workspaces_asset` CHANGE COLUMN `userId` `userId` int(11) NOT NULL DEFAULT 0;");
    $db->query("ALTER TABLE `users_workspaces_document` CHANGE COLUMN `userId` `userId` int(11) NOT NULL DEFAULT 0;");
    $db->query("ALTER TABLE `users_workspaces_object` CHANGE COLUMN `userId` `userId` int(11) NOT NULL DEFAULT 0;");
} catch (\Exception $e) {
    echo $e->getMessage();
}

fputs(STDOUT, "3232\n");
try{
    $db->query("ALTER TABLE `keyvalue_keys` ADD COLUMN `mandatory` TINYINT(1) NULL DEFAULT NULL AFTER `translator`;");
} catch (\Exception $e) {
    echo $e->getMessage();
}

fputs(STDOUT, "3261\n");
$dir = Asset_Image_Thumbnail_Config::getWorkingDir();
$files = scandir($dir);
foreach ($files as $file) {
    $found = false;
    if(strpos($file, ".xml")) {
        $name = str_replace(".xml", "", $file);

        $thumbnail = Asset_Image_Thumbnail_Config::getByName($name);
        foreach($thumbnail->items as &$item) {
            if($item["method"] == "cover") {
                $item["arguments"]["doNotScaleUp"] = "1";
                $found = true;
            }
        }

        if($found) {
            unset($thumbnail->filenameSuffix);
            $thumbnail->save();
        }
    }
}

Pimcore_Model_Cache::clearAll();
fputs(STDOUT, "done\n");
