<?php

/**
 * Builds a language switching structure for a given object and corresponding static route.
 * 
 * @author Martin Kuric <martin.kuric@portadesign.cz>
 */

namespace Website\Controller\Action\Helper;

class BuildLanguageSwitchFromObject extends \Zend_Controller_Action_Helper_Abstract
{

	protected $switcher = array();

	/**
	 * 
	 * @param \Pimcore\Model\Object\Concrete $object the object instance
	 * @param string $routeName name of the used static route
	 * @param bool $routeForEachLanguage tells if there are seperate static routes for each language
	 * 
	 * @return array associative array with localized URLs for each language, e.g. array('en' => 'en_url', 'cs' => 'cs_url')
	 */
	public function direct($object, $routeName, $routeForEachLanguage = false)
	{
		$params = array();
		$vars = array();
		$languages = \Website\Tool\Utils::getValidFrontendLanguages();

		if (!$routeForEachLanguage) {
			$route = \Pimcore\Model\Staticroute::getByName($routeName, (\Pimcore\Model\Site::isSiteRequest()) ? \Pimcore\Model\Site::getCurrentSite()->getId() : 0);
			if ($route) $vars = array_diff(explode(',', $route->getVariables()), array('language'));
		}

		foreach ($languages as $language) {
			$baseUrl = '';
			$siteId = 0;
			if ($routeForEachLanguage) {
				if (\Pimcore\Model\Site::isSiteRequest()) {
					$siteRootId = \Pimcore\Model\Document\Page::getByPath('/' . $language)->getId();
					$site = \Pimcore\Model\Site::getByRootId($siteRootId);
					if ($site) {
						$siteId = $site->getId();
						$baseUrl = 'http://' . $site->getMainDomain();
					}
				}
				$route = \Pimcore\Model\Staticroute::getByName($routeName . $language, $siteId);
				if ($route) $vars = explode(',', $route->getVariables());
			} else {
				$params['language'] = $language;
			}
			foreach ($vars as $var) {
				$params[$var] = $object->{'get' . ucfirst($var)}($language);
			}
			$this->switcher[$language] = $baseUrl . $route->assemble($params, true);
		}

		return $this->switcher;
	}

}
