<?php

namespace Website\Form;

class LoginForm extends Base
{
	
	public function init()
	{
		parent::init();
		$this->setName('login');
		
		//elements
		$email = new \Zend_Form_Element_Text('email');
		$email->setRequired(true)
			->setLabel('label_email')
			->addFilter('StripTags')
			->addFilter('StringTrim')
			->addValidator($this->notEmptyValidator)
			->addValidator($this->emailValidator);
		
		$password = new \Zend_Form_Element_Password('password');
		$password->setRequired(true)
			->setLabel('label_password')
			->addFilter('StripTags')
			->addFilter('StripTags')
			->addValidator($this->notEmptyValidator)
			->addValidator($this->passwordLengthValidator);

		$remeberMe = new \Zend_Form_Element_Checkbox('rememberMe');
		$remeberMe->setRequired(false)
			->addFilter('StripTags')
			->addFilter('StringTrim')
			->setLabel('label_remember_me');

		$formName = new \Zend_Form_Element_Hidden('formName');
		$formName->setValue($this->getName());
		
		$submit = new \Zend_Form_Element_Button('send');
		$submit->setLabel('label_login')
			->setAttrib('type', 'submit');
		
		$this->addElements(array(
			$email,
			$password,
			$remeberMe,
			$formName,
			$submit
		));

		//remove decorators
		$this->setElementDecorators(array('ViewHelper'));

		$this->setUpJsValidation();
	}
}
