<?php

namespace Website\Model;

class MailManager
{
	public function sendMail(\Pimcore\Model\Document\Email $document, $to = null, $from = null, $params = null, \Zend_Mime_Part $attachment = null)
	{
		$mailer = new \Pimcore\Mail('utf-8');

		if ($to) $document->setTo($to);
		if ($document->getFrom() && !$from) $from = $document->getFrom();
		$document->setFrom(null); # because we want to add the name, and \Pimcore\Mail doesn't support it
		$mailer->setDocument($document);

		$senderName = $document->getProperty('emailSender', null);
		$mailer->setFrom($from, $senderName);

		if ($params) $mailer->setParams($params);
		if ($attachment) $mailer->addAttachment($attachment);

		try {
			$mailer->send();
			return true;
		} catch (\Exception $e) {
			\Pimcore\Log\Simple::log('exceptions', 'MAIL - '.$e->getMessage()."\n".$e->getTraceAsString());
			return false;
		}
	}
}
