<?php

namespace Website\Model;

class UserManager
{
	const ROOT_FOLDER_ID = 3;

	protected $translator;

	public function __construct($translator)
	{
		$this->translator = $translator;
	}

	public function createUser($data)
	{
		try {
			$user = \Pimcore\Model\Object\User::create($data);
			$user->setKey(\Pimcore\File::getValidFilename($data['email']));
			$user->setParentId(self::ROOT_FOLDER_ID);
			$user->setPublished(false);
			$user->save();
		} catch (\Exception $e) {
			\Pimcore\Log\Simple::log('exceptions', 'REGISTRATION - ' . $e->getMessage() . "\n" . $e->getTraceAsString());
			$this->addErrorMsg($this->translate('msg_unknown_error'));
			return false;
		}

		//send email
		$helper = new \Zend_View_Helper_ServerUrl();
		$mailManager = new \Website\Model\MailManager();
		$mailManager->sendMail(\Pimcore\Model\Document\Email::getByPath('/'.$data['lang'].'/notifikace/registrace'), $data['email'], null, array(
			'siteUrl' => $helper->serverUrl().'/'.$data['lang'],
			'activationUrl' => $helper->serverUrl().\Website\Tool\Utils::url('activate-account', array(
				'language' => $data['lang'],
				'code' => $data['activationCode']
			)),
			'user' => $user
		));

		return true;
	}
}
