<?php

namespace Website\View\Helper;

class FormBuilder extends \Zend_View_Helper_Abstract
{
	const TYPE_BOOTSTRAP = 'bootstrap';
	const TYPE_PORTA = 'porta';

	public $view;

	protected $output = '';
	/**
	 *
	 * @var \Zend_Form
	 */
	protected $form = null;
	/**
	 * @var \Zend_Form_Element
	 */
	protected $element = null;
	protected $formClass = null;
	//input stands for <input>, <textarea>
	protected $inputClass = null;
	protected $inputWrapperClass = null;
	protected $inputLabelWrapperClass = null;
	protected $inputElementWrapperClass = null;

	protected $selectClass = null;
	protected $selectWrapperClass = null;
	protected $selectLabelWrapperClass = null;
	protected $selectElementWrapperClass = null;

	protected $checkboxInputClass = null;
	protected $checkboxInputWrapperClass = null;
	protected $checkboxInputLabelWrapperClass = null;
	protected $checkboxElementWrapperClass = null;

	protected $radioInputClass = null;
	protected $radioInputWrapperClass = null;
	protected $radioInputLabelWrapperClass = null;
	protected $radioElementWrapperClass = null;
	protected $radioWrapperClass = null;

	protected $uploadWidgetWrapperClass = null;
	protected $uploadWidgetLabelWrapperClass = null;
	protected $uploadElementWrapperClass = null;
	protected $uploadInputWrappperClass = null;
	protected $uploadInputClass = null;

	protected $buttonClass = null;
	protected $buttonWrapperClass = null;

	protected $showErrors = true;
	protected $errorElement = 'label';
	protected $errorClass = null;
	protected $errorWrapperSelector = null;
	protected $errorWrapperClass = null;

	protected $showLabel = true;
	protected $placeholder = false;
	protected $notice = null;
	protected $hint = null;
	protected $encode = true;
	protected $explicitRequired = false;
	protected $autoPopulateData = null;
	protected $autoPopulatePrefix = null;
	/**
	 * adds a suffix for each radio part label
	 * @var array
	 */
	protected $radioLabelSuffix = array();
	/**
	 * hint for each radio part
	 * @var array
	 */
	protected $radioLabelHint = array();

	protected function _run()
	{
		
	}

	public function formBuilder(\Zend_Form $form, $type = null)
	{
		return $this->setForm($form, $type);
	}

	public function reset()
	{
		$this->output = '';
		$this->element = null;
		$this->formClass = null;

		$this->inputClass = null;
		$this->inputWrapperClass = null;
		$this->inputLabelWrapperClass = null;
		$this->inputElementWrapperClass = null;

		$this->selectClass = null;
		$this->selectWrapperClass = null;
		$this->selectLabelWrapperClass = null;
		$this->selectElementWrapperClass = null;

		$this->checkboxInputClass = null;
		$this->checkboxInputWrapperClass = null;
		$this->checkboxInputLabelWrapperClass = null;
		$this->checkboxElementWrapperClass = null;

		$this->radioInputClass = null;
		$this->radioInputWrapperClass = null;
		$this->radioInputLabelWrapperClass = null;
		$this->radioElementWrapperClass = null;
		$this->radioWrapperClass = null;

		$this->uploadWidgetWrapperClass = null;
		$this->uploadWidgetLabelWrapperClass = null;
		$this->uploadElementWrapperClass = null;
		$this->uploadInputWrappperClass = null;
		$this->uploadInputClass = null;

		$this->buttonClass = null;
		$this->buttonWrapperClass = null;

		$this->errorElement = 'label';
		$this->errorClass = null;
		$this->errorWrapperSelector = null;
		$this->errorWrapperClass = null;

		$this->showLabel = true;
		$this->placeholder = false;
		$this->notice = null;
		$this->hint = null;
		$this->encode = true;
		$this->explicitRequired = false;
		$this->autoPopulateData = null;
		$this->autoPopulatePrefix = null;
		$this->radioLabelSuffix = array();
		$this->radioLabelHint = array();

		return $this;
	}

	public function setForm(\Zend_Form $form, $type = false)
	{
		$this->reset();

		if ($type == self::TYPE_BOOTSTRAP) $this->setBootstrapDefaults();
		if ($type == self::TYPE_PORTA) $this->setPortaDefaults();

		$this->form = $form;

		return $this;
	}

	/**
	 * @param string $class
	 * @return \Website\View\Helper\FormBuilder
	 */
	public function setFormClass($class)
	{
		$this->formClass = $class;

		return $this;
	}

	/**
	 * @param string $json
	 * @return \Website\View\Helper\FormBuilder
	 */
	public function setAutoPopulateData($json)
	{
		$this->autoPopulateData = $json;

		return $this;
	}

	/**
	 * @param string $prefix
	 * @return \Website\View\Helper\FormBuilder
	 */
	public function setAutoPopulateDataPrefix($prefix)
	{
		$this->autoPopulatePrefix = $prefix;

		return $this;
	}

	/**
	 * @param string $labelWrapperClass
	 * @return \Website\View\Helper\FormBuilder
	 */
	public function setLabelWrapperClass($labelWrapperClass)
	{
		$this->labelWrapperClass = $labelWrapperClass;

		return $this;
	}

	/**
	 * @param string $inputClass
	 * @return \Website\View\Helper\FormBuilder
	 */
	public function setInputClass($inputClass)
	{
		$this->inputClass = $inputClass;

		return $this;
	}

	/**
	 * @param string $inputWrapperClass
	 * @return \Website\View\Helper\FormBuilder
	 */
	public function setInputWrapperClass($inputWrapperClass)
	{
		$this->inputWrapperClass = $inputWrapperClass;

		return $this;
	}

	/**
	 * @param string $inputLabelWrapperClass
	 * @return \Website\View\Helper\FormBuilder
	 */
	public function setInputLabelWrapperClass($inputLabelWrapperClass)
	{
		$this->inputLabelWrapperClass = $inputLabelWrapperClass;

		return $this;
	}

	/**
	 * @param string $inputElementWrapperClass
	 * @return \Website\View\Helper\FormBuilder
	 */
	public function setInputElementWrapperClass($inputElementWrapperClass)
	{
		$this->inputElementWrapperClass = $inputElementWrapperClass;

		return $this;
	}

	/**
	 * @param string $selectClass
	 * @return \Website\View\Helper\FormBuilder
	 */
	public function setSelectClass($selectClass)
	{
		$this->selectClass = $selectClass;

		return $this;
	}

	/**
	 * @param string $selectWrapperClass
	 * @return \Website\View\Helper\FormBuilder
	 */
	public function setSelectWrapperClass($selectWrapperClass)
	{
		$this->selectWrapperClass = $selectWrapperClass;

		return $this;
	}

	/**
	 * @param string $selectLabelWrapperClass
	 * @return \Website\View\Helper\FormBuilder
	 */
	public function setSelectLabelWrapperClass($selectLabelWrapperClass)
	{
		$this->selectLabelWrapperClass = $selectLabelWrapperClass;

		return $this;
	}

	/**
	 * @param string $selectElementWrapperClass
	 * @return \Website\View\Helper\FormBuilder
	 */
	public function setSelectElementWrapperClass($selectElementWrapperClass)
	{
		$this->selectElementWrapperClass = $selectElementWrapperClass;

		return $this;
	}

	/**
	 * @param string $checkboxInputClass
	 * @return \Website\View\Helper\FormBuilder
	 */
	public function setCheckboxInputClass($checkboxInputClass)
	{
		$this->checkboxInputClass = $checkboxInputClass;

		return $this;
	}

	/**
	 * @param string $checkboxInputWrapperClass
	 * @return \Website\View\Helper\FormBuilder
	 */
	public function setCheckboxInputWrapperClass($checkboxInputWrapperClass)
	{
		$this->checkboxInputWrapperClass = $checkboxInputWrapperClass;

		return $this;
	}

	/**
	 * @param string $checkboxLabelWrapperClass
	 * @return \Website\View\Helper\FormBuilder
	 */
	public function setCheckboxInputLabelWrapperClass($checkboxInputLabelWrapperClass)
	{
		$this->checkboxInputLabelWrapperClass = $checkboxInputLabelWrapperClass;

		return $this;
	}

	/**
	 * @param string $checkboxElementWrapperClass
	 * @return \Website\View\Helper\FormBuilder
	 */
	public function setCheckboxElementWrapperClass($checkboxElementWrapperClass)
	{
		$this->checkboxElementWrapperClass = $checkboxElementWrapperClass;

		return $this;
	}

	/**
	 * @param string $radioInputClass
	 * @return \Website\View\Helper\FormBuilder
	 */
	public function setRadioInputClass($radioInputClass)
	{
		$this->radioInputClass = $radioInputClass;

		return $this;
	}

	/**
	 * @param string $radioInputWrapperClass
	 * @return \Website\View\Helper\FormBuilder
	 */
	public function setRadioInputWrapperClass($radioInputWrapperClass)
	{
		$this->radioInputWrapperClass = $radioInputWrapperClass;

		return $this;
	}

	/**
	 * @param string $radioLabelWrapperClass
	 * @return \Website\View\Helper\FormBuilder
	 */
	public function setRadioInputLabelWrapperClass($radioInputLabelWrapperClass)
	{
		$this->radioInputLabelWrapperClass = $radioInputLabelWrapperClass;

		return $this;
	}

	/**
	 * @param string $radioElementWrapperClass
	 * @return \Website\View\Helper\FormBuilder
	 */
	public function setRadioElementWrapperClass($radioElementWrapperClass)
	{
		$this->radioElementWrapperClass = $radioElementWrapperClass;

		return $this;
	}

	/**
	 * @param string $radioWrapperClass
	 * @return \Website\View\Helper\FormBuilder
	 */
	public function setRadioWrapperClass($radioWrapperClass)
	{
		$this->radioWrapperClass = $radioWrapperClass;

		return $this;
	}

	/**
	 * @param string $uploadWidgetWrapperClass
	 * @return \Website\View\Helper\FormBuilder
	 */
	public function setUploadWidgetWrapperClass($uploadWidgetWrapperClass)
	{
		$this->uploadWidgetWrapperClass = $uploadWidgetWrapperClass;

		return $this;
	}

	/**
	 * @param string $buttonClass
	 * @return \Website\View\Helper\FormBuilder
	 */
	public function setButtonClass($buttonClass)
	{
		$this->buttonClass = $buttonClass;

		return $this;
	}

	/**
	 * @param string $buttonWrapperClass
	 * @return \Website\View\Helper\FormBuilder
	 */
	public function setButtonWrapperClass($buttonWrapperClass)
	{
		$this->buttonWrapperClass = $buttonWrapperClass;

		return $this;
	}

	/**
	 * @param string $encode
	 * @return \Website\View\Helper\FormBuilder
	 */
	public function setEncode($encode)
	{
		$this->encode = $encode;

		return $this;
	}

	/**
	 * @param string $notice
	 * @return \Website\View\Helper\FormBuilder
	 */
	public function setNotice($notice)
	{
		$this->notice = $notice;

		return $this;
	}

	/**
	 * @param string $hint
	 * @return \Website\View\Helper\FormBuilder
	 */
	public function setHint($hint)
	{
		$this->hint = $hint;

		return $this;
	}

	/**
	 * @param string $showErrors
	 * @return \Website\View\Helper\FormBuilder
	 */
	public function setShowErrors($showErrors)
	{
		$this->showErrors = $showErrors;

		return $this;
	}

	/**
	 * @param string $errorElement
	 * @return \Website\View\Helper\FormBuilder
	 */
	public function setErrorElement($errorElement)
	{
		$this->errorElement = $errorElement;

		return $this;
	}

	/**
	 * @param string $errorClass
	 * @return \Website\View\Helper\FormBuilder
	 */
	public function setErrorClass($errorClass)
	{
		$this->errorClass = $errorClass;

		return $this;
	}

	/**
	 * @param string $showLabel
	 * @return \Website\View\Helper\FormBuilder
	 */
	public function setShowLabel($showLabel)
	{
		$this->showLabel = $showLabel;

		return $this;
	}

	/**
	 * @param string $placeholder
	 * @return \Website\View\Helper\FormBuilder
	 */
	public function setPlaceholder($placeholder)
	{
		$this->placeholder = $placeholder;

		return $this;
	}

	/**
	 * @param string $explicitRequired
	 * @return \Website\View\Helper\FormBuilder
	 */
	public function setExplicitRequired($explicitRequired)
	{
		$this->explicitRequired = $explicitRequired;

		return $this;
	}

	/**
	 * @param string $radioLabelSuffix
	 * @return \Website\View\Helper\FormBuilder
	 */
	public function setRadioLabelSuffix($radioLabelSuffix)
	{
		$this->radioLabelSuffix = $radioLabelSuffix;

		return $this;
	}

	/**
	 * @param string $radioLabelHint
	 * @return \Website\View\Helper\FormBuilder
	 */
	public function setRadioLabelHint($radioLabelHint)
	{
		$this->radioLabelHint = $radioLabelHint;

		return $this;
	}

	/**
	 * @return string html
	 */
	public function start()
	{
		$jsValidation = ($this->form->getAttrib('js-validation'));
		$persistToHash = ($this->form->getAttrib('persist-to-hash'));

		$this->output .= vsprintf('<form role="form" class="%s" id="%s" method="%s" enctype="%s" action="%s"%s%s novalidate%s%s%s%s%s%s>', array(
			$this->formClass,
			$this->form->getId(),
			$this->form->getMethod(),
			$this->form->getEnctype(),
			$this->form->getAction(),
			($this->autoPopulateData) ? sprintf(' data-populate="%s"', $this->view->enc($this->autoPopulateData, true, true)) : '',
			($this->autoPopulatePrefix) ? sprintf(' data-populate-prefix="%s"', $this->autoPopulatePrefix) : '',
			($jsValidation) ? ' data-js-validation="1"' : '',
			($jsValidation) ? ' data-error-element="'.$this->errorElement.'"' : '',
			($jsValidation) ? ' data-error-class="'.$this->errorClass.'"' : '',
			($jsValidation && $this->errorWrapperSelector) ? ' data-error-wrapper-selector="'.$this->errorWrapperSelector.'"' : '',
			($jsValidation && $this->errorWrapperClass) ? ' data-error-wrapper-class="'.$this->errorWrapperClass.'"' : '',
			($persistToHash) ? ' data-persist-to-hash="1"' : ''
		));

		return $this;
	}

	/**
	 * 
	 * @return string html string
	 */
	public function end()
	{
		$this->output .= '</form>';
		return $this;
	}

	private function input()
	{
		$output = '';
		if ($this->inputClass) $this->element->setAttrib('class', $this->inputClass);
		if ($this->element->isRequired()) $this->element->setAttrib('required', 'required');
		$placeholder = false;
		if ($this->placeholder) {
			$placeholder = ($this->placeholder === true) ? $this->element->getLabel() : $this->placeholder;
			$this->element->setAttrib('placeholder', (!$this->encode) ? $placeholder : $this->view->enc($placeholder));
		}

		if ($this->inputElementWrapperClass) $output .= sprintf('<div class="%s">', $this->inputElementWrapperClass . (($this->element->hasErrors() && $this->errorWrapperClass) ? ' '.$this->errorWrapperClass : ''));
			if ($this->showLabel && $this->inputLabelWrapperClass) $output .= sprintf('<div class="%s">', $this->inputLabelWrapperClass);
				if ($this->showLabel && !$placeholder) $output .= sprintf('<label for="%s">%s</label>', $this->element->getName(), (!$this->encode) ? $this->element->getLabel() : $this->view->enc($this->element->getLabel()));
			if ($this->showLabel && $this->inputLabelWrapperClass) $output .= '</div>';

			if ($this->inputWrapperClass) $output .= sprintf('<div class="%s">', $this->inputWrapperClass);
				$output .= $this->element;
			if ($this->inputWrapperClass) $output .= '</div>';

			if ($this->showErrors) $output .= $this->getErrors();

			if ($this->hint) $output .= sprintf('<p class="hint">%s</p>', $this->hint);
			if ($this->notice) $output .= sprintf('<p class="notice">%s</p>', $this->notice);
		if ($this->inputElementWrapperClass) $output .= '</div>';

		$this->output .= $output;

		return $this;
	}

	private function select()
	{
		$output = '';
		if ($this->selectClass) $this->element->setAttrib('class', $this->selectClass);
		if ($this->element->isRequired()) $this->element->setAttrib('required', 'required');
		$placeholder = false;
		if ($this->placeholder) {
			$placeholder = ($this->placeholder === true) ? $this->element->getLabel() : $this->placeholder;
			$this->element->setAttrib('placeholder', (!$this->encode) ? $placeholder : $this->view->enc($placeholder));
		}

		if ($this->selectElementWrapperClass) $output .= sprintf('<div class="%s">', $this->selectElementWrapperClass . (($this->element->hasErrors() && $this->errorWrapperClass) ? ' '.$this->errorWrapperClass : ''));
			if ($this->showLabel && $this->selectLabelWrapperClass) $output .= sprintf('<div class="%s">', $this->selectLabelWrapperClass);
				if ($this->showLabel && !$placeholder) $output .= sprintf('<label for="%s">%s</label>', $this->element->getName(), (!$this->encode) ? $this->element->getLabel() : $this->view->enc($this->element->getLabel()));
			if ($this->showLabel && $this->selectLabelWrapperClass) $output .= '</div>';

			if ($this->selectWrapperClass) $output .= sprintf('<div class="%s">', $this->selectWrapperClass);
				$output .= $this->element;
			if ($this->selectWrapperClass) $output .= '</div>';

			if ($this->showErrors) $output .= $this->getErrors();

			if ($this->hint) $output .= sprintf('<p class="hint">%s</p>', $this->hint);
			if ($this->notice) $output .= sprintf('<p class="notice">%s</p>', $this->notice);
		if ($this->selectElementWrapperClass) $output .= '</div>';

		$this->output .= $output;

		return $this;
	}

	private function checkbox($index = null)
	{
		$output = '';
		if ($this->checkboxInputClass) $this->element->setAttrib('class', $this->checkboxInputClass);
		if ($this->element->isRequired()) $this->element->setAttrib('required', 'required');

		if ($this->checkboxElementWrapperClass) $output .= sprintf('<div class="%s"><div class="toggle">', $this->checkboxElementWrapperClass . (($this->element->hasErrors() && $this->errorWrapperClass) ? ' '.$this->errorWrapperClass : ''));
			if ($this->showLabel && $this->checkboxInputLabelWrapperClass) $output .= sprintf('<div class="%s">', $this->checkboxInputLabelWrapperClass);
				if ($this->showLabel) {
					if ($index !== null) {
						$option = $this->element->getMultiOption($index);
						$label = (!$this->encode) ? $option : $this->view->enc($option);
						$for = $this->element->getName().'-'.$index;
					} else {
						$for = $this->element->getId();
						$label = (!$this->encode) ? $this->element->getLabel() : $this->view->enc($this->element->getLabel());
					}
					$output .= sprintf('<label for="%s">%s</label>', $for, $label);
				}
			if ($this->showLabel && $this->checkboxInputLabelWrapperClass) $output .= '</div>';

			if ($this->checkboxInputWrapperClass) $output .= sprintf('<div class="%s">', $this->checkboxInputWrapperClass);
				if ($index !== null) {
					$values = $this->element->getValue();
					$output .= vsprintf('<input type="checkbox" name="%s[]" id="%s" value="%s"%s%s>', array(
						$this->element->getName(),
						$this->element->getName().'-'.$index,
						$index,
 						($values && in_array($index, $values)) ? ' checked="checked"' : '',
						($this->checkboxInputClass) ? sprintf(' class="%s"', $this->checkboxInputClass) : ''
					));
				} else {
					$output .= $this->element;
				}
			if ($this->checkboxInputWrapperClass) $output .= '</div>';

			if ($this->showErrors && !$index) $output .= $this->getErrors();
		
			if ($this->hint) $output .= sprintf('<p class="hint">%s</p>', $this->hint);
			if ($this->notice) $output .= sprintf('<p class="notice">%s</p>', $this->notice);
		if ($this->checkboxElementWrapperClass) $output .= '</div></div>';

		$this->output .= $output;

		return $this;
	}

	private function radio($index = null)
	{
		$output = '';

		if ($index === null && $this->radioWrapperClass) $output .= sprintf('<div class="%s">', $this->radioWrapperClass . (($this->element->hasErrors() && $this->errorWrapperClass) ? ' '.$this->errorWrapperClass : ''));
		
		foreach($this->element->getMultiOptions() as $value => $label) {
			if ($index !== null && $index != $value) continue;
			$labelSuffix = (is_array($this->radioLabelSuffix) && isset($this->radioLabelSuffix[$value])) ? $this->radioLabelSuffix[$value] : '';
			$labelHint = (is_array($this->radioLabelHint) && isset($this->radioLabelHint[$value])) ? $this->radioLabelHint[$value] : '';
			if ($this->radioElementWrapperClass) $output .= sprintf('<div class="%s"><div class="toggle">', $this->radioElementWrapperClass);
				if ($this->showLabel && $this->radioInputLabelWrapperClass) $output .= sprintf('<div class="%s">', $this->radioInputLabelWrapperClass);
					if ($this->showLabel) $output .= sprintf('<label for="%s">%s</label>', $this->element->getName().$value, (!$this->encode) ? $label : $this->view->enc($label));
				if ($this->showLabel && $this->radioInputLabelWrapperClass) $output .= '</div>';

				if ($this->radioInputWrapperClass) $output .= sprintf('<div class="%s">', $this->radioInputWrapperClass);
					$output .= vsprintf('<input type="radio" id="%s" name="%s" value="%s"%s%s>', array(
						$this->element->getName().$value,
						$this->element->getName(),
						(!$this->encode) ? $value : $this->view->enc($value),
						($this->element->getValue() == $value) ? ' checked="checked"' : '',
						($this->radioInputClass) ? sprintf(' class="%s"', $this->radioInputClass) : ''
					));
				if ($this->radioInputWrapperClass) $output .= '</div>';

				$output .= (!$this->encode) ? $labelSuffix : $this->view->enc($labelSuffix);
				$output .= (!$this->encode) ? $labelHint : $this->view->enc($labelHint);
			if ($this->radioElementWrapperClass) $output .= '</div></div>';
		}

		if ($this->showErrors && !$index) $output .= $this->getErrors();

		if ($index === null && $this->radioWrapperClass) $output .= '</div>';

		$this->output .= $output;

		return $this;
	}

	public function getErrors($element = null)
	{
		$output = '';

		if ($element) {
			if (!$element instanceof \Zend_Form_Element && isset($this->form->{(string)$element})) {
				$element = $this->form->$element;
			}
		} else {
			$element = $this->element;
		}

		if (!$element instanceof \Zend_Form_Element) return $output;

		$output .= sprintf('<div class="error-placement-wrapper" data-element-id="%s">', $element->getId());
			if ($element->hasErrors()) $output .= vsprintf('<%s class="%s">%s</%s>', array(
				$this->errorElement,
				$this->errorClass,
				(!$this->encode) ? current($this->form->getMessages($element->getName())) : $this->view->enc(current($this->form->getMessages($element->getName()))),
				$this->errorElement
			));
		$output .= sprintf('</div>', $element->getId());

		return $output;
	}

	public function upload($fileType, $index = null)
	{
		$getter = $fileType.'1';
		$first = $this->form->$getter;

		$output = '';
		if ($this->uploadWidgetWrapperClass) $output .= sprintf('<div class="%s" data-input="%s">', ($this->uploadWidgetWrapperClass) ? ' '.$this->uploadWidgetWrapperClass : '', $fileType);
			if ($this->showLabel) {
				if ($this->uploadWidgetLabelWrapperClass) $output .= sprintf('<div class="%s">', $this->uploadWidgetLabelWrapperClass);
					$output .= sprintf('<label>%s</label>', $first->getAttrib('data-label'));
				if ($this->uploadWidgetLabelWrapperClass) $output .= '</div>';
			}
			for ($i = 1; $i <= $first->getAttrib('data-maxParts'); $i++) {
				if($index && $i != $index) continue;
				$getter = $fileType.$i;
				$getterEdit = 'edit_'.$getter;
				$getterRemove = 'remove_'.$getter;
				$required = ($this->form->$getter->getAttrib('data-required') == 1);
				$id = $this->form->$getterEdit->getAttrib('data-id');
				$hasErrors = $this->form->$getter->hasErrors();
				if ($hasErrors) $this->form->$getterEdit->setValue(1);
				$class = 'upload-part';
				if ($required) {
					$class .= ' part-required';
				} else {
					$class .= ' part-optional';
				}
				if (!$id && !$hasErrors && !$required) {
					$class .= ' part-hidden';
				}
				if ($this->uploadElementWrapperClass) $class .= ' '.$this->uploadElementWrapperClass;
				if ($hasErrors && $this->errorWrapperClass) $class .= ' '.$this->errorWrapperClass;
				$output .= sprintf('<div class="%s">', $class);
					$output .= $this->form->$getterEdit;
					$output .= $this->form->$getterRemove;
					//@TODO style the edit/download part...
					$output .= '<div class="part-edit">';
						if ($id) {
							$output .= sprintf('<a class="btn alt" href="%s" target="_blank">%s<span class="r"></span></a>', \Website\Tool\Utils::url('download-asset', array('id' => $id)), $this->view->translate('label_downloadFile'));
							$output .= sprintf('<a class="btn edit-upload" href="javascript:void(0);">%s<span class="r"></span></a>', $this->view->translate('label_editFile'));
						}
					$output .= '</div>';
					$output .= sprintf('<div class="part-input%s">', ($this->uploadInputWrappperClass) ? ' '.$this->uploadInputWrappperClass : '');
						if ($this->uploadInputClass) $this->form->$getter->setAttrib('class', $this->uploadInputClass);
						$output .= $this->form->$getter;
					$output .= '</div>';
					if ($this->showErrors && !$index) $output .= $this->getErrors();
				$output .= '</div>';
			}

			//@TODO style the add/remove part
			if ($this->uploadWidgetWrapperClass && ($first->getAttrib('data-maxParts') - $first->getAttrib('data-required')) >= 1) {
				$output .= sprintf('<p class="add-hint add-upload"><a class="add" href="javascript:void(0);">%s</a></p>', $this->view->translate('label_addFile'));
				$output .= sprintf('<p class="remove-hint remove-upload"><a class="remove" href="javascript:void(0);">%s</a></p>', $this->view->translate('label_removeFile'));
			}
		if ($this->uploadWidgetWrapperClass) $output .= '</div>';

		$this->output .= $output;

		return $this;
	}

	private function hidden()
	{
		$this->output .= (string)$this->element;
		return $this;
	}

	private function submit($iconBefore = null, $iconAfter = null)
	{
		$output = '';

		if ($this->buttonWrapperClass) $output .= sprintf('<div class="%s">', $this->buttonWrapperClass);

			$output .= vsprintf('<button type="submit" id="%s" name="%s" class="%s" value="%s">%s%s%s</button>', array(
				$this->element->getId(),
				$this->element->getName(),
				$this->buttonClass,
				$this->element->getName(),
				($iconBefore) ? $iconBefore : '',
				$this->element->getLabel(),
				($iconAfter) ? $iconAfter : ''
			));
		
		if ($this->buttonWrapperClass) $output .= '</div>';

		$this->output .= $output;

		return $this;
	}

	/**
	 * returns simple one-column form 
	 * @return string form html
	 */
	public function simpleForm()
	{
		$this->setBootstrapDefaults();

		$this->start();

		/* @var $element \Zend_Form_Element */
		foreach ($this->form->getElements() as $element) {
			$this->element($element);
		}

		return $this->end();
	}

	private function setBootstrapDefaults()
	{
		//bootstrap 3 compatible base setup
		$this->showErrors = true;
		$this->errorWrapperClass = 'has-error';
		$this->errorWrapperSelector = '.form-group';
		$this->errorElement = 'span';
		$this->errorClass = 'help-block';

		$this->setFormClass(null);

		$this->setInputClass('form-control');
		$this->setInputWrapperClass(null);
		$this->setInputLabelWrapperClass(null);
		$this->setInputElementWrapperClass('form-group');

		$this->setSelectClass('form-control');
		$this->setSelectWrapperClass(null);
		$this->setSelectLabelWrapperClass(null);
		$this->setSelectElementWrapperClass('form-group');

		$this->setCheckboxInputClass(null);
		$this->setCheckboxInputWrapperClass(null);
		$this->setCheckboxInputLabelWrapperClass(null);
		$this->setCheckboxElementWrapperClass('form-group checkbox');

		$this->setRadioInputClass(null);
		$this->setRadioInputWrapperClass(null);
		$this->setRadioInputLabelWrapperClass(null);
		$this->setRadioElementWrapperClass('radio');
		$this->setRadioWrapperClass('form-group');

		$this->uploadWidgetLabelWrapperClass = null;
		$this->uploadWidgetWrapperClass = 'upload-widget well';
		$this->uploadElementWrapperClass = 'form-group';
		$this->uploadInputClass = 'file';
		$this->uploadInputWrappperClass = null;

		$this->setButtonClass('btn btn-default');
		$this->setButtonWrapperClass(null);
	}

	private function setPortaDefaults()
	{
		//marty templates compatible base setup
		$this->showErrors = true;
		$this->errorWrapperClass = null;
		$this->errorWrapperSelector = null;
		$this->errorElement = 'label';
		$this->errorClass = 'error';

		$this->setFormClass('std');

		$this->setInputClass('text');
		$this->setInputWrapperClass('input');
		$this->setInputLabelWrapperClass('label');
		$this->setInputElementWrapperClass('cell');

		$this->setSelectClass('select uf');
		$this->setSelectWrapperClass('input');
		$this->setSelectLabelWrapperClass('label');
		$this->setSelectElementWrapperClass('cell');

		$this->setCheckboxInputClass('uf checkbox');
		$this->setCheckboxInputWrapperClass(null);
		$this->setCheckboxInputLabelWrapperClass(null);
		$this->setCheckboxElementWrapperClass('cell-input');

		$this->setRadioInputClass('uf radio');
		$this->setRadioInputWrapperClass(null);
		$this->setRadioInputLabelWrapperClass(null);
		$this->setRadioElementWrapperClass('cell-input');
		$this->setRadioWrapperClass('cell-set');

		$this->uploadWidgetLabelWrapperClass = null;
		$this->uploadWidgetWrapperClass = 'upload-widget cell';
		$this->uploadElementWrapperClass = 'cell-set';
		$this->uploadInputClass = 'uf file';
		$this->uploadInputWrappperClass = 'cell';

		$this->setButtonClass('btn');
		$this->setButtonWrapperClass('cell');
	}

	/**
	 * @param \Zend_Form_Element|string $element
	 * @param mixed $p1
	 * @param mixed $p2
	 * @return string html
	 */
	public function element($element, $p1 = null, $p2 = null)
	{
		$upload = (substr((($element instanceof \Zend_Form_Element) ? $element->getName() : $element), 0, 6) == 'upload');

		if (!$upload && !$element instanceof \Zend_Form_Element) {
			$element = (isset($this->form->$element)) ? $this->form->$element : null;
		}

		if (!$element) {
			$this->output .= '';
			return $this;
		}

		if ($this->explicitRequired && !$upload) {
			$element->setRequired(true);
		}

		if (!$upload) $this->element = $element;

		if ($upload) {
			$this->upload($element, $p1);
		} elseif ($element instanceof \Zend_Form_Element_Text || $element instanceof \Zend_Form_Element_Password || $element instanceof \Zend_Form_Element_Textarea) {
			$this->input();
		} elseif ($element instanceof \Zend_Form_Element_Select) {
			$this->select();
		} elseif ($element instanceof \Zend_Form_Element_Checkbox) {
			$this->checkbox();
		} elseif ($element instanceof \Zend_Form_Element_MultiCheckbox) {
			if ($p1 !== null) {
				$this->checkbox($p1);
			} else {
				foreach (array_keys($element->getMultiOptions()) as $moIndex) {
					$this->checkbox($moIndex);
				}
			}
		} elseif ($element instanceof \Zend_Form_Element_Radio) {
			$this->radio($p1);
		} elseif ($element instanceof \Zend_Form_Element_Submit || $element instanceof \Zend_Form_Element_Button) {
			$this->submit($p1, $p2);
		} elseif ($element instanceof \Zend_Form_Element_Hidden || $element instanceof \Zend_Form_Element_Hash) {
			$this->hidden();
		}
		
		return $this;
	}

	public function setView(\Zend_View_Interface $view)
	{
		parent::setView($view);

		$this->view = $view;
	}

	public function __toString()
	{
		$tmp = $this->output;
		$this->output = '';
		return $tmp;
	}
}
