<?php

class DefaultController extends \Website\Controller\BaseController
{
	/*						DOCUMENT ROUTED ACTIONS							*/

	public function indexAction()
	{
		$this->enableLayout();
	}

	public function defaultAction()
	{
	}

	public function emptyPageAction()
	{
		if (!$this->editmode && !\Pimcore\Tool::isFrontentRequestByAdmin()) {
			$childs = $this->document->getChilds();
			if (empty($childs)) {
				throw new \Zend_Controller_Action_Exception($this->translate('system_page_not_found'), 404);
			} else {
				$this->gotoUrl(current($childs)->getFullPath(), 301);
			}
		}
	}

	public function errorPageAction()
	{
		$errorHandler = $this->getRequest()->getParam('error_handler');
		$exception = $errorHandler->exception;

		if (!$exception || $exception->getCode() == 404) {
			$this->enableLayout();
			$this->view->content = '<h1>Požadovaná stránka neexistuje</h1>';
			$this->getResponse()->setHttpResponseCode(404);
		} else {
			$this->disableLayout();
			$this->view->content = '<h1>Chyba aplikace</h1>';
			$this->getResponse()->setHttpResponseCode(500);
		}
	}

	/* 						STATIC-ROUTE ROUTED ACTIONS						 */

	/*							VIEW-LESS ACTIONS							*/

	public function downloadAssetAction()
	{
		//@TODO check for ownership
		$this->disableLayout();
		$this->disableViewAutoRender();

		$id = $this->getRequest()->getParam('id');
		$asset = Asset::getById($id);
		if (!$asset) {
			$this->addErrorMsg($this->translate('msg_invalid_request'));
		}

		//@TODO name from meta data...
		$name = substr(basename($asset->getFilename()), (stripos($asset->getFilename(), '_')) ? stripos($asset->getFilename(), '_') + 1 : 0);
		header('Content-Description: File Transfer');
		header('Content-Type: application/octet-stream');
		header('Content-Disposition: attachment; filename='.$name);
		header('Content-Transfer-Encoding: binary');
		header('Expires: 0');
		header('Cache-Control: must-revalidate, post-check=0, pre-check=0');
		header('Pragma: public');
		header('Content-Length: '.filesize($asset->getFileSystemPath()));
		ob_clean();
		flush();
		readfile($asset->getFileSystemPath());
		exit;
	}

	public function sitemapXmlAction()
	{
		$this->disableLayout();
		$this->disableViewAutoRender();

		// save different sitemap for each site
		$documentRoot = (\Pimcore\Model\Site::isSiteRequest())
			? \Pimcore\Model\Site::getCurrentSite()->getRootDocument()
			: \Pimcore\Model\Document\Page::getById(1);
		$sitemapPath = sprintf(
			PIMCORE_WEBSITE_PATH.'/var/tmp/sitemap%s.xml',
			($siteRoot instanceof \Pimcore\Model\Document)
				? sprintf('-%d', $siteRoot->getId())
				: ''
		);
		// invalidate sitemap file each day
		$timestamp = (file_exists($sitemapPath)) ? filemtime($sitemapPath) : 0;
		if ((time() - $timestamp) < 86400) {
			$xml = file_get_contents($sitemapPath);
		} else {
			$xml = null;
		}

		if (!$xml) {
			$xml = '<?xml version="1.0" encoding="UTF-8"?><urlset xmlns="http://www.sitemaps.org/schemas/sitemap/0.9">';

			// add documents
			$validLanguages = \Website\Tool\Utils::getValidFrontendLanguages();
			$documentList = new \Pimcore\Model\Document\Listing();
			$documentList->setCondition(
				"type = ? AND path like ?",
				['page', $documentRoot->getRealFullPath().'%']
			);
			$documentIdList = $documentList->loadIdList();
			foreach ($documentIdList as $documentId) {
				$document = \Pimcore\Model\Document\Page::getById($documentId);
				$language = $document->getProperty('language');
				if (!$document || !in_array($language, $validLanguages)
						|| $document->getProperty('sitemap_xml_exclude')) {
					continue;
				}
				$url = $document->getFullPath();
				if (substr($url, 0, 4) != 'http') {
					$url = $this->view->serverUrl().$url;
				}
				$xml .= sprintf(
					'<url><loc>%s</loc><lastmod>%s</lastmod><changefreq>monthly</changefreq></url>',
					$url,
					date('Y-m-d', $document->getModificationDate())
				);
			}

			// add objects with getUrl method
			$classList = new Pimcore\Model\Object\ClassDefinition\Listing();
			$classList->load();
			foreach($classList->getClasses() as $class) {
				$objectClass = '\\Website\\Model\\'.$class->getName();
				if (!class_exists($objectClass, false)) {
					$objectClass = '\\Pimcore\\Model\\Object\\'.$class->getName();
				}
				$tmpObject = new $objectClass;
				if (method_exists($tmpObject, 'getUrl')) {
					$listClass = '\\Website\\Model\\'.$class->getName().'\\Listing';
					if (!class_exists($listClass, false)) {
						$listClass = '\\Pimcore\\Model\\Object\\'.$class->getName().'\\Listing';
					}
					$list = new $listClass();
					$list->load();
					foreach ($list->getItems(0, 0) as $object) {
						if ($object->getProperty('sitemap_xml_exclude')) {
							continue;
						}
						$url = $object->getUrl($this->language);
						if (substr($url, 0, 4) != 'http') {
							$url = $this->view->serverUrl().$url;
						}
						$xml .= sprintf(
							'<url><loc>%s</loc><lastmod>%s</lastmod><changefreq>monthly</changefreq></url>',
							$url,
							date('Y-m-d', $object->getModificationDate())
						);
					}

				}
			}

			$xml .= sprintf('</urlset>');

			$handle = fopen($sitemapPath, 'w');
			fwrite($handle, $xml);
			fclose($handle);
		}

		header('Content-Description: File Transfer');
		header('Content-Type: application/octet-stream');
		header('Content-Disposition: attachment; filename='.basename('sitemap.xml'));
		header('Content-Transfer-Encoding: binary');
		header('Expires: 0');
		header('Cache-Control: must-revalidate, post-check=0, pre-check=0');
		header('Pragma: public');

		echo $xml;
		exit;
	}

	/*							FORM HANDLERS								*/
}
