<?php

namespace Website\Model;

class MailManager
{
	public function sendMail($pathOrTemplate, $language, $to = null, $from = null, $params = null, \Zend_Mime_Part $attachment = null)
	{
		if ($pathOrTemplate instanceof \Pimcore\Model\Document\Email) {
			$document = $pathOrTemplate;
		} else {
			$document = \Pimcore\Model\Document\Email::getByPath($pathOrTemplate);
			if (!$document) {
				return false;
			}
			// try to load translated template
			if ($document->getProperty('language') != $language) {
				$service = new \Pimcore\Model\Document\Service();
				$translations = $service->getTranslations($document);
				if (isset($translations[$language])) {
					$translatedDocument = \Pimcore\Model\Document\Email::getById($translations[$language]);
					if ($translatedDocument) {
						$document = $translatedDocument;
					}
				}
			}
		}
		if (!$document instanceof \Pimcore\Model\Document\Email) {
			return false;
		}

		$mailer = new \Pimcore\Mail('utf-8');

		if ($to) {
			$document->setTo($to);
		}
		if ($document->getFrom() && !$from) {
			$from = $document->getFrom();
		}
		$document->setFrom(null); // because we want to add the name, and \Pimcore\Mail doesn't support it
		$mailer->setDocument($document);

		$senderName = $document->getProperty('emailSender', null);
		$mailer->setFrom($from, $senderName);

		if ($params) {
			$mailer->setParams($params);
		}
		if ($attachment) {
			$mailer->addAttachment($attachment);
		}

		try {
			$mailer->send();

			return true;
		} catch (\Exception $e) {
			\Pimcore\Logger::error('MAIL - '.$e->getMessage()."\n".$e->getTraceAsString());

			return false;
		}
	}
}
