<?php

namespace Website\Tool\Console\Command;

define('DEPLOYER', true);
define('DEPLOYER_BIN', __FILE__);

use Pimcore\Console\AbstractCommand;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Input\InputOption;
use Symfony\Component\Console\Output\OutputInterface;

class DeploymentDeployCommand extends AbstractCommand
{
	protected function configure()
	{
		$this
			->setName('deployment:deploy')
			->setDescription('Deploy project to the server')
			->addOption(
				'all', 'a',
				InputOption::VALUE_NONE,
				'Full deployment'
			)
			->addOption(
				'db', null,
				InputOption::VALUE_NONE,
				'Experimental incremental DB deployment'
			)
			->addOption(
				'skip', 's',
				InputOption::VALUE_NONE,
				'Skip requirements checks'
			);
	}

	protected function execute(InputInterface $input, OutputInterface $output)
	{
		require_once __DIR__.'/../../../../vendor/deployer/deployer/src/functions.php';
		$console = new \Deployer\Console\Application('Deployer', 'master');
		$deployer = new \Deployer\Deployer($console, $input, $output);
		require __DIR__.'/../../Deployer/recipe.php';
		$deployer->run();
	}
}
