<?php

set_time_limit(60000);
include_once __DIR__.'/../../../pimcore/cli/startup.php';
$db = \Pimcore\Db::get();
\Pimcore\Cache::clearAll();

fwrite(STDOUT, "3507\n");
try {
	$db->query("CREATE TABLE IF NOT EXISTS `application_logs` (
	`id` bigint(20) NOT NULL AUTO_INCREMENT,
	  `timestamp` datetime NOT NULL,
	  `message` varchar(1024) DEFAULT NULL,
	  `priority` int(10) DEFAULT NULL,
	  `fileobject` varchar(1024) DEFAULT NULL,
	  `info` varchar(1024) DEFAULT NULL,
	  `component` varchar(255) DEFAULT NULL,
	  `source` varchar(255) DEFAULT NULL,
	  `relatedobject` bigint(20) DEFAULT NULL,
	  `relatedobjecttype` enum('object','document','asset') DEFAULT NULL,
	  `maintenanceChecked` tinyint(4) DEFAULT NULL,
	  PRIMARY KEY (`id`),
	  KEY `component` (`component`),
	  KEY `timestamp` (`timestamp`),
	  KEY `relatedobject` (`relatedobject`),
	  KEY `priority` (`priority`)
	) ENGINE=MyISAM DEFAULT CHARSET=utf8;");

	User_Permission_Definition::create('application_logging');
} catch (\Exception $e) {
	fwrite(STDOUT, '3507 failed - '.$e->getMessage()."\n");
}

fwrite(STDOUT, "3522\n");
try {
	$db->query('ALTER TABLE `assets` ADD INDEX `modificationDate` (`modificationDate`);');
	$db->query('ALTER TABLE `documents` ADD INDEX `modificationDate` (`modificationDate`);');
	$db->query('ALTER TABLE `objects` ADD INDEX `o_modificationDate` (`o_modificationDate`);');
} catch (\Exception $e) {
	fwrite(STDOUT, '3522 failed - '.$e->getMessage()."\n");
}

fwrite(STDOUT, "3524\n");
try {
	$db->query("CREATE TABLE IF NOT EXISTS `classificationstore_groups` (
		`id` BIGINT(20) NOT NULL AUTO_INCREMENT,
		`parentId` BIGINT(20) NOT NULL DEFAULT '0',
		`name` VARCHAR(255) NOT NULL DEFAULT '',
		`description` VARCHAR(255) NULL DEFAULT NULL,
		`creationDate` BIGINT(20) UNSIGNED NULL DEFAULT '0',
		`modificationDate` BIGINT(20) UNSIGNED NULL DEFAULT '0',
		PRIMARY KEY (`id`)
	)
	DEFAULT CHARSET=utf8;");
	$db->query("CREATE TABLE IF NOT EXISTS `classificationstore_keys` (
		`id` BIGINT(20) NOT NULL AUTO_INCREMENT,
		`name` VARCHAR(255) NOT NULL DEFAULT '',
		`description` TEXT NULL,
		`type` ENUM('input','textarea','wysiwyg','checkbox','numeric','slider','select','multiselect','date','datetime','language','languagemultiselect','country','countrymultiselect','table') NULL DEFAULT NULL,
		`creationDate` BIGINT(20) UNSIGNED NULL DEFAULT '0',
		`modificationDate` BIGINT(20) UNSIGNED NULL DEFAULT '0',
		`definition` LONGTEXT NULL,
		`enabled` TINYINT(1) NULL DEFAULT NULL,
		PRIMARY KEY (`id`)
	)
	DEFAULT CHARSET=utf8;");
	$db->query('CREATE TABLE IF NOT EXISTS `classificationstore_relations` (
		`groupId` BIGINT(20) NOT NULL,
		`keyId` BIGINT(20) NOT NULL,
		PRIMARY KEY (`groupId`, `keyId`),
		INDEX `FK_classificationstore_relations_classificationstore_keys` (`keyId`),
		CONSTRAINT `FK_classificationstore_relations_classificationstore_groups` FOREIGN KEY (`groupId`) REFERENCES `classificationstore_groups` (`id`) ON DELETE CASCADE,
		CONSTRAINT `FK_classificationstore_relations_classificationstore_keys` FOREIGN KEY (`keyId`) REFERENCES `classificationstore_keys` (`id`) ON UPDATE NO ACTION ON DELETE CASCADE
	)
	DEFAULT CHARSET=utf8;');
} catch (\Exception $e) {
	fwrite(STDOUT, '3524 failed - '.$e->getMessage()."\n");
}

fwrite(STDOUT, "3527\n");
try {
	$db->query("DELETE FROM `users_permission_definitions` WHERE  `key`='sent_emails';");
} catch (\Exception $e) {
	fwrite(STDOUT, '3527 failed - '.$e->getMessage()."\n");
}

fwrite(STDOUT, "3529\n");
try {
	$db->query("ALTER TABLE `classificationstore_keys` ADD COLUMN `sorter` INT(10) NULL DEFAULT '0' AFTER `enabled`;");
	$db->query("ALTER TABLE `classificationstore_groups` ADD COLUMN `sorter` INT(10) NULL DEFAULT '0' AFTER `modificationDate`;");
} catch (\Exception $e) {
	fwrite(STDOUT, '3529 failed - '.$e->getMessage()."\n");
}

fwrite(STDOUT, "3531\n");
try {
	$db->query("CREATE TABLE IF NOT EXISTS `classificationstore_collections` (
		`id` BIGINT(20) NOT NULL AUTO_INCREMENT,
		`name` VARCHAR(255) NOT NULL DEFAULT '',
		`description` VARCHAR(255) NULL DEFAULT NULL,
		`creationDate` BIGINT(20) UNSIGNED NULL DEFAULT '0',
		`modificationDate` BIGINT(20) UNSIGNED NULL DEFAULT '0',
		PRIMARY KEY (`id`)
	) DEFAULT CHARSET=utf8;");
	$db->query('CREATE TABLE IF NOT EXISTS `classificationstore_collectionrelations` (
		`colId` BIGINT(20) NOT NULL,
		`groupId` BIGINT(20) NOT NULL,
		PRIMARY KEY (`colId`, `groupId`),
		CONSTRAINT `FK_classificationstore_collectionrelations_groups` FOREIGN KEY (`groupId`) REFERENCES `classificationstore_groups` (`id`) ON UPDATE NO ACTION ON DELETE CASCADE
	) DEFAULT CHARSET=utf8;');
} catch (\Exception $e) {
	fwrite(STDOUT, '3531 failed - '.$e->getMessage()."\n");
}

fwrite(STDOUT, "3546\n");
echo "You're going to install pimcore version 4!\n";

fwrite(STDOUT, "3548\n");
try {
	$db->query("ALTER TABLE `classificationstore_collectionrelations` ADD COLUMN `sorter` INT(10) NULL DEFAULT '0' AFTER `groupId`;");
	$db->query("ALTER TABLE `classificationstore_relations` ADD COLUMN `sorter` INT(10) NULL DEFAULT '0' AFTER `keyId`;");
	$db->query('ALTER TABLE `classificationstore_groups` DROP COLUMN `sorter`;');
	$db->query('ALTER TABLE `classificationstore_keys` DROP COLUMN `sorter`;');
	$tables = $db->fetchAll("SHOW TABLES LIKE 'object_classificationstore_data_%'");
	foreach ($tables as $table) {
		$t = current($table);
		$db->query('ALTER TABLE `'.$t.'`
			ADD COLUMN `collectionId` BIGINT(20) NULL AFTER `o_id`;
		');
	}
} catch (\Exception $e) {
	fwrite(STDOUT, '3548 failed - '.$e->getMessage()."\n");
}

fwrite(STDOUT, "3549\n");
try {
	$db->query('CREATE TABLE `quantityvalue_units` (
				  `id` bigint(20) NOT NULL AUTO_INCREMENT,
				  `group` varchar(50) COLLATE utf8_bin DEFAULT NULL,
				  `abbreviation` varchar(10) COLLATE utf8_bin NOT NULL,
				  `longname` varchar(250) COLLATE utf8_bin DEFAULT NULL,
				  `baseunit` varchar(10) COLLATE utf8_bin DEFAULT NULL,
				  `factor` double DEFAULT NULL,
				  PRIMARY KEY (`id`)
				) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8 COLLATE=utf8_bin;
			');
	$db->query("ALTER TABLE `classificationstore_keys`
		CHANGE COLUMN `type` `type` ENUM('input','textarea','wysiwyg','checkbox','numeric','slider','select','multiselect','date','datetime','language','languagemultiselect','country','countrymultiselect','table','quantityValue') NULL DEFAULT NULL AFTER `description`;
	");
} catch (\Exception $e) {
	fwrite(STDOUT, '3549 failed - '.$e->getMessage()."\n");
}

fwrite(STDOUT, "3551\n");
try {
	$db->query("ALTER TABLE `classificationstore_keys`
		CHANGE COLUMN `type` `type` ENUM('input','textarea','wysiwyg','checkbox','numeric','slider','select','multiselect','date','datetime','language','languagemultiselect','country','countrymultiselect','table','quantityValue','calculatedValue') NULL DEFAULT NULL AFTER `description`;
	");
} catch (\Exception $e) {
	fwrite(STDOUT, '3551 failed - '.$e->getMessage()."\n");
}

fwrite(STDOUT, "3563\n");
try {
	$tables2 = $db->fetchAll("SHOW TABLES LIKE 'object_metadata_%'");
	foreach ($tables2 as $table) {
		$t = current($table);
		$db->query('ALTER TABLE `'.$t."`
			ADD COLUMN `type` VARCHAR(50) NOT NULL DEFAULT '' AFTER `dest_id`,
			DROP PRIMARY KEY,
			ADD PRIMARY KEY (`o_id`, `dest_id`, `fieldname`, `column`, `ownertype`, `ownername`, `position`, `type`),
			ADD INDEX `type` (`type`);
		");
	}
} catch (\Exception $e) {
	fwrite(STDOUT, '3563 failed - '.$e->getMessage()."\n");
}

fwrite(STDOUT, "3565\n");
try {
	$db->query('ALTER TABLE `classificationstore_collectionrelations` DROP COLUMN `sorter`;');
	$db->query('ALTER TABLE `classificationstore_collectionrelations`
		ADD COLUMN `sorter` INT NULL AFTER `groupId`;
	');
	$db->query('ALTER TABLE `classificationstore_relations` DROP COLUMN `sorter`;');
	$db->query('ALTER TABLE `classificationstore_relations`
		ADD COLUMN `sorter` INT NOT NULL AFTER `keyId`;
	');
} catch (\Exception $e) {
	fwrite(STDOUT, '3565 failed - '.$e->getMessage()."\n");
}

fwrite(STDOUT, "3566\n");
try {
	$db->query('ALTER TABLE `quantityvalue_units`
		ADD COLUMN `conversionOffset` DOUBLE NULL DEFAULT NULL AFTER `factor`;
	');
} catch (\Exception $e) {
	fwrite(STDOUT, '3566 failed - '.$e->getMessage()."\n");
}

fwrite(STDOUT, "3576\n");
try {
	$db->query("ALTER TABLE `classificationstore_keys`
		ADD COLUMN `title` VARCHAR(255) NOT NULL DEFAULT '' AFTER `name`,
		ADD INDEX `name` (`name`),
		ADD INDEX `enabled` (`enabled`),
		ADD INDEX `type` (`type`);
	");
	$db->query('ALTER TABLE `classificationstore_groups`
		ADD INDEX `name` (`name`);
	');
	$db->query('ALTER TABLE `classificationstore_collections`
		ADD INDEX `name` (`name`);
	');
} catch (\Exception $e) {
	fwrite(STDOUT, '3576 failed - '.$e->getMessage()."\n");
}

fwrite(STDOUT, "3581\n");
try {
	// APPLICATION LOGGER
	$db->query('ALTER TABLE `application_logs`CHANGE COLUMN `priority` `priority-legacy` INT(10) NULL DEFAULT NULL AFTER `message`;');
	$db->query("ALTER TABLE application_logs ADD COLUMN `priority` ENUM('emergency','alert','critical','error','warning','notice','info','debug') DEFAULT NULL AFTER `message`;");
	$zendLoggerPsr3Mapping = [
		\Zend_Log::DEBUG => 'debug',
		\Zend_Log::INFO => 'info',
		\Zend_Log::NOTICE => 'notice',
		\Zend_Log::WARN => 'warning',
		\Zend_Log::ERR => 'error',
		\Zend_Log::CRIT => 'critical',
		\Zend_Log::ALERT => 'alert',
		\Zend_Log::EMERG => 'emergency',
	];
	foreach ($zendLoggerPsr3Mapping as $zend => $psr) {
		$db->update('application_logs', ['priority' => $psr], "`priority-legacy` = '".$zend."'");
	}
	$db->query('ALTER TABLE application_logs DROP COLUMN `priority-legacy`;');
	// USER PREFERRED LANGUAGE SETTINGS
	$db->query('ALTER TABLE `users`	ADD COLUMN `contentLanguages` LONGTEXT NULL DEFAULT NULL AFTER `language`;');
} catch (\Exception $e) {
	fwrite(STDOUT, '3581 failed - '.$e->getMessage()."\n");
}

fwrite(STDOUT, "3582\n");
try {
	$db->query("DELETE FROM `users_permission_definitions` WHERE `key`='document_style_editor';");
	$db->query('ALTER TABLE documents_page DROP COLUMN `css`;');
} catch (\Exception $e) {
	fwrite(STDOUT, '3582 failed - '.$e->getMessage()."\n");
}

fwrite(STDOUT, "3588\n");
try {
	$db->query("INSERT INTO `users_permission_definitions` (`key`) VALUES ('tags_assignment')");
	$db->query("INSERT INTO `users_permission_definitions` (`key`) VALUES ('tags_configuration')");
	$db->query("INSERT INTO `users_permission_definitions` (`key`) VALUES ('tags_search')");
	$db->query('CREATE TABLE `tags` (
	  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
	  `parentId` int(10) unsigned DEFAULT NULL,
	  `idPath` varchar(255) DEFAULT NULL,
	  `name` varchar(20) DEFAULT NULL,
	  PRIMARY KEY (`id`),
	  KEY `idpath` (`idPath`),
	  KEY `parentid` (`parentId`)
	) DEFAULT CHARSET=utf8;
	');
	$db->query("CREATE TABLE `tags_assignment` (
	  `tagid` int(10) unsigned NOT NULL DEFAULT '0',
	  `cid` int(10) NOT NULL DEFAULT '0',
	  `ctype` enum('document','asset','object') NOT NULL,
	  PRIMARY KEY (`tagid`,`cid`,`ctype`),
	  KEY `ctype` (`ctype`),
	  KEY `ctype_cid` (`cid`,`ctype`),
	  KEY `tagid` (`tagid`)
	) DEFAULT CHARSET=utf8;
	");
} catch (\Exception $e) {
	fwrite(STDOUT, '3588 failed - '.$e->getMessage()."\n");
}

fwrite(STDOUT, "3591\n");
try {
	$db->query('ALTER TABLE `application_logs`
		ADD COLUMN `pid` INT NULL DEFAULT NULL AFTER `id`;
	');
} catch (\Exception $e) {
	fwrite(STDOUT, '3591 failed - '.$e->getMessage()."\n");
}

fwrite(STDOUT, "3596\n");
try {
	$tables = $db->fetchAll("SHOW TABLES LIKE 'object_classificationstore_data_%'");
	foreach ($tables as $table) {
		$t = current($table);
		$db->query('ALTER TABLE `'.$t.'`
			ADD COLUMN `type` VARCHAR(50) NULL AFTER `language`;
		');
	}
} catch (\Exception $e) {
	fwrite(STDOUT, '3596 failed - '.$e->getMessage()."\n");
}

\Pimcore\Cache::clearAll();
fwrite(STDOUT, "done\n");
