<?php

set_time_limit(60000);
include_once __DIR__.'/../../../pimcore/cli/startup.php';
\Pimcore\Cache::clearAll();
$db = \Pimcore\Db::get();


fwrite(STDOUT, "3925\n");
try {
	$classesData = $db->fetchAll("SELECT * FROM classes");
	foreach($classesData as $classData) {
		$class = new \Pimcore\Model\Object\ClassDefinition();
		$class->setValues($classData);
		$class->setPropertyVisibility(\Pimcore\Tool\Serialize::unserialize($classData["propertyVisibility"]));
		$file = PIMCORE_CLASS_DIRECTORY."/definition_". $class->getId() .".psf";
		$layoutData = \Pimcore\Tool\Serialize::unserialize(file_get_contents($file));
		$class->setLayoutDefinitions($layoutData);
		$definitionFile = PIMCORE_CLASS_DIRECTORY."/definition_". $class->getName() .".php";
		if (!is_writable(dirname($definitionFile)) || (is_file($definitionFile) && !is_writable($definitionFile))) {
			throw new \Exception("Cannot write definition file in: " . $definitionFile . " please check write permission on this directory.");
		}
		$clone = clone $class;
		$clone->setDao(null);
		unset($clone->id);
		unset($clone->fieldDefinitions);
		$exportedClass = var_export($clone, true);
		$data = '<?php ';
		$data .= "\n\n";
		$data .= "/** Generated at " . date('c') . " */";
		$data .= "\n\n";
		$data .= "\nreturn " . $exportedClass . ";\n";
		\Pimcore\File::put($definitionFile, $data);
	}
	$db->query("
	ALTER TABLE `classes`
		DROP COLUMN `description`,
		DROP COLUMN `creationDate`,
		DROP COLUMN `modificationDate`,
		DROP COLUMN `userOwner`,
		DROP COLUMN `userModification`,
		DROP COLUMN `allowInherit`,
		DROP COLUMN `allowVariants`,
		DROP COLUMN `parentClass`,
		DROP COLUMN `useTraits`,
		DROP COLUMN `icon`,
		DROP COLUMN `previewUrl`,
		DROP COLUMN `propertyVisibility`,
		DROP COLUMN `showVariants`,
		DROP COLUMN `group`;
	");
} catch (\Exception $e) {
	fwrite(STDOUT, '3925 failed - '.$e->getMessage()."\n");
}

fwrite(STDOUT, "3936\n");
try {
	$db->delete("users_permission_definitions", $db->quoteIdentifier("key") . " = 'newsletter'");
} catch (\Exception $e) {
	fwrite(STDOUT, '3936 failed - '.$e->getMessage()."\n");
}

fwrite(STDOUT, "3938\n");
	$db->query("ALTER TABLE tags CHANGE COLUMN `name` `name` varchar(255) DEFAULT NULL;");
try {
} catch (\Exception $e) {
	fwrite(STDOUT, '3938 failed - '.$e->getMessage()."\n");
}

fwrite(STDOUT, "3947\n");
try {
	$folders = [PIMCORE_CLASS_DIRECTORY . "/objectbricks", PIMCORE_CLASS_DIRECTORY . "/fieldcollections"];
	foreach($folders as $folder) {
		$files = glob($folder . "/*.psf");
		foreach ($files as $file) {
			$data = file_get_contents($file);
			$definition = \Pimcore\Tool\Serialize::unserialize($data);
			$phpDefinitionFile = preg_replace("@\.psf$@", ".php", $file);
			$clone = clone $definition;
			$clone->setDao(null);
			unset($clone->fieldDefinitions);
			$exportedClass = var_export($clone, true);
			$data = '<?php ';
			$data .= "\n\n";
			$data .= "\nreturn " . $exportedClass . ";\n";
			\Pimcore\File::put($phpDefinitionFile, $data);
		}
	}
} catch (\Exception $e) {
	fwrite(STDOUT, '3947 failed - '.$e->getMessage()."\n");
}


\Pimcore\Cache::clearAll();
fwrite(STDOUT, "done\n");
