$(document).ready(function ($) {

	// Match height
	$('.item-eq').matchHeight();

	/**********************************************
	MOBILE NAVIGATION
	**********************************************/

	$(function() {
		var mobileNav = $('.mobile-nav');
		var mobileNavOverlay = $('.mobile-nav-overlay');

		function showNav() {
			mobileNav.addClass('active');
			mobileNavOverlay.fadeIn();
			//$('body').css({ 'overflow': 'hidden' });
		}

		function hideNav() {
			mobileNav.removeClass('active');
			mobileNavOverlay.fadeOut();
			//$('body').css({ 'overflow': 'auto' });
		}

		$('.nav-btn').click(function() {
			if ( ! mobileNav.hasClass('active') ) {
				showNav();
			}
			else {
				hideNav();
			}
			return false;
		});

		// Mobile nav close
		$('.mobile-nav .close').click(function(){
			hideNav();
		});

		// Mobile nav overlay close
		$('.mobile-nav-overlay').click(function(){
			hideNav();
		});

		$('.mobile-nav li a').each(function() {
			if ( $(this).siblings('ul').length > 0 ) {
				$(this).append('<span class="more"></span>');
			}
		});

		// Mobile nav accordion
		$('.mobile-nav li a').click(function() {
			if ( $(this).siblings('ul').length > 0 ) {
				if ( ! $(this).siblings('ul').hasClass('active') ) {
					//$('.mobile-nav ul ul').removeClass('active');
					$(this).siblings('ul').addClass('active');
				} else {
					$(this).siblings('ul').removeClass('active');
				}
				return false;
			}
		});
	});

	/**********************************************
	RESIZE END / SCROLL END
	**********************************************/

	var resizeEnd;
	$(window).on('resize', function () {
		clearTimeout(resizeEnd);
		resizeEnd = setTimeout(function () {
			$(window).trigger('resizeEnd');
		}, 100);
	});

	var scrollEnd;
	$(window).on('scroll', function () {
		clearTimeout(scrollEnd);
		scrollEnd = setTimeout(function () {
			$(window).trigger('scrollEnd');
		}, 100);
	});

});

function jQuerySelectorEscape(expression) {
	return expression.replace(/[!"#$%&'()*+,.\/:;<=>?@\[\\\]^`{|}~]/g, '\\$&');
}

// Zobrazení elementu ve viewportu
function inViewport(el) {
	var elH = $(el).height(),
			elTop = $(el).offset().top,
			scrollTop = $(window).scrollTop(),
			winH = $(window).height();
	fixedHeaderH = 0; // výška fixní hlavičky

	return ((elTop + elH) > (scrollTop + fixedHeaderH) && (scrollTop - elH) > (elTop - winH));
}
