import $ from 'jquery'

const initNavigation = () => {
    $(() => {
        const body = document.body;
        const dropdownTriggers = document.querySelectorAll('.dropdown__trig');
        const dropdownMenus = document.querySelectorAll('.dropdown__menu');
        const menuTriggers = document.querySelectorAll('.menu-trigger');

        for (const menuTrigger of menuTriggers) {
            menuTrigger.addEventListener('click', (e) => {
                e.preventDefault();
                hideDropdowns();
                body.classList.toggle('body--menu-open');
            });
        }

        if (!dropdownTriggers || !dropdownMenus) return;

        for (const trigger of dropdownTriggers) {
            const elId = trigger.getAttribute('data-dropdown');
            const dropdown = document.querySelector('#' + elId);
            if (!dropdown) continue;

            trigger.addEventListener('click', (e) => {
                if ((window.innerWidth > 992)) {
                    const wasOpened = dropdown.classList.contains('dropdown__menu--open');

                    hideDropdowns();
                    if (!wasOpened) {
                        showDropdown(dropdown, trigger);
                    }
                } else {
                    toggleDropdown(dropdown, trigger);
                }
            });
        }

        body.addEventListener('click', (e) => {
            if (e.target.closest('.main-nav, .services-nav, .x-layer')) return;

            hideDropdowns();
        });

        const hideDropdowns = () => {
            for (const dropdownMenu of dropdownMenus) {
            // $(dropdownMenu).fadeOut(300).removeClass('dropdown__menu--open');
                dropdownMenu.classList.remove('dropdown__menu--open');
            }
            for (const dropdownTrigger of dropdownTriggers) {
            // $(dropdownTrigger).removeClass('dropdown__trig--active');
                dropdownTrigger.classList.remove('dropdown__trig--active');
            }
        }

        const showDropdown = (dropdown, trigger) => {
            // $(dropdown).addClass('dropdown__menu--open').fadeIn(200);
            // $(trigger).addClass('dropdown__trig--active');
            dropdown.classList.add('dropdown__menu--open');
            trigger.classList.add('dropdown__trig--active');
        }

        const toggleDropdown = (dropdown, trigger) => {
            // $(dropdown).toggleClass('dropdown__menu--open').fadeToggle(200);
            // $(trigger).toggleClass('dropdown__trig--active');
            dropdown.classList.toggle('dropdown__menu--open');
            trigger.classList.toggle('dropdown__trig--active');
        }
    });
}

export { initNavigation };

/* CSS only */

/* const initNavigation = () => {
    $(() => {
        const body = document.body;
        const dropdownTriggers = document.querySelectorAll('.dropdown__trig');
        const dropdownMenus = document.querySelectorAll('.dropdown__menu');
        const dropdowns = document.querySelectorAll('.dropdown');
        const menuTriggers = document.querySelectorAll('.menu-trigger');

        for (const menuTrigger of menuTriggers) {
          menuTrigger.addEventListener('click', (e) => {
            e.preventDefault();
            hideDropdowns();
            body.classList.toggle('body--menu-open');
          });
        }

        if(!dropdownTriggers || !dropdownMenus) return;

        for (const trigger of dropdownTriggers) {
          const elId = trigger.getAttribute('data-dropdown');
          const dropdown = document.querySelector('#' + elId);
          if (!dropdown) continue;

          trigger.addEventListener('click', (e) => {
            const isNestedDropdown = dropdown.closest('.dropdown__menu--open');
            if ((window.innerWidth > 992) && !isNestedDropdown) {
              const wasOpened = dropdown.classList.contains('dropdown__menu--open');
              const anotherOpened = document.querySelectorAll('.dropdown__menu--open').length && !wasOpened;

              hideDropdowns(true);

              if (!wasOpened) {
                showDropdown(dropdown, trigger, !anotherOpened);
              }

            } else {
              toggleDropdown(dropdown, trigger);
            }
          });

        }

        body.addEventListener('click', (e) => {
          if (!e.target.closest('.main-nav, .services-nav, .x-layer')) {
            hideDropdowns(true);
          }

          if (!e.target.closest('.main-nav, .menu-trigger')) {
            body.classList.remove('body--menu-open');
          }
        });

        const hideDropdowns = (animated = false) => {
          for (const dropdownMenu of dropdownMenus) {
            if(animated) {
              dropdownMenu.classList.add('dropdown__menu--anim');
            } else {
              dropdownMenu.classList.remove('dropdown__menu--anim');
            }
            dropdownMenu.classList.remove('dropdown__menu--open');
          }
          for (const dropdownTrigger of dropdownTriggers) {
            dropdownTrigger.classList.remove('dropdown__trig--active');
          }
          for (const dropdown of dropdowns) {
            dropdown.classList.remove('dropdown--open');
          }
        }

        const showDropdown = (dropdownMenu, trigger, animated = false) => {
          const dropdown = dropdownMenu.closest('.dropdown');
          if(animated) {
            dropdownMenu.classList.add('dropdown__menu--anim');
          } else {
            dropdownMenu.classList.remove('dropdown__menu--anim');
          }

          dropdown?.classList.add('dropdown--open');
          dropdownMenu.classList.add('dropdown__menu--open');
          trigger.classList.add('dropdown__trig--active');
        }

        const toggleDropdown = (dropdownMenu, trigger, animated = false) => {
          const dropdown = dropdownMenu.closest('.dropdown');

          if(animated) {
            dropdownMenu.classList.add('dropdown__menu--anim');
          } else {
            dropdownMenu.classList.remove('dropdown__menu--anim');
          }

          dropdown?.classList.toggle('dropdown--open');
          dropdownMenu.classList.toggle('dropdown__menu--open');
          trigger.classList.toggle('dropdown__trig--active');
        }
    });
}

export { initNavigation }; */
