import $ from 'jquery';

const initTabs = () => {
    $('.tabs').liteTabs();
}

// Lite tabs
const tabs = () => {
    $.fn.liteTabs = function (options) {
        return this.each(() => {
            const defaults = {
                borders: false,
                boxed: false,
                height: 'auto',
                hideHash: false,
                hashTag: true,
                selectedTab: 1,
                width: 500
            };
            // merge defaults with options in new settings object
            const settings = $.extend({}, defaults, options);
            // define key variables
            const $this = $(this);
            const $tabLinks = $this.find('.tab-nav__link');
            const $tabContent = $this.find('.tab-content').first().find('.tab');

            // on tab click...
            $tabLinks.on('click', function (e) {
                // const selectedPanel = $tabContent.filter('[name="' + this.hash + '"]');
                $tabContent.removeClass('tab--selected').filter('[name="' + this.hash + '"]').addClass('tab--selected');

                // defaults: add selected class to tab
                $tabLinks.removeClass('tab-nav__link--selected').filter(this).addClass('tab-nav__link--selected');

                // option: hide hash change
                if (settings.hideHash) {
                    e.preventDefault();
                }
            });

            // option: set selected tab
            if (settings.selectedTab) {
                $tabLinks.eq(settings.selectedTab - 1).addClass('tab--selected');
                $tabContent.eq(settings.selectedTab - 1).addClass('tab--selected');
            }

            // If hash tag..
            const hash = window.location.hash.substring(1);
            if (hash) {
                $('[href="#' + hash + '"]').click();
            } else if ($tabLinks.length) {
                $tabLinks.first().trigger('click');
            }

            // switch tabs on hash change
            $(window).on('hashchange', (e) => {
                const hash = window.location.hash.substring(1);
                if (hash) {
                    $('[href="#' + hash + '"]').click();
                }
            });
        });
    };
}

export { initTabs, tabs };
