
const initTooltips = () => {
    const tooltips = document.querySelectorAll('.tooltip');
    const body = document.body;

    for (const tooltip of tooltips) {
        const trigger = tooltip.querySelector('.tooltip__trig');
        const popup = tooltip.querySelector('.tooltip__popup');

        if (!(trigger && popup)) return;

        trigger.addEventListener('click', (e) => {
            e.preventDefault();
            popup.classList.toggle('tooltip__popup--active');
        });

        body.addEventListener('click', (e) => {
            if (!e.target.closest('.tooltip')) {
                popup.classList.remove('tooltip__popup--active');
            }
        });
    };
}

export { initTooltips };
