import $ from 'jquery'
import { initNavigation } from './components/nav';
import { initFlashMessages } from './components/flash-messages';

$(() => {
    initNavigation();
    initFlashMessages();

    // togglers
    const togglerSelector = '.sh-trig, .show-more';
    const togglers = document.querySelectorAll(togglerSelector);
    if (togglers.length) {
        import('./components/togglers').then(({ initTogglers }) => {
            initTogglers();
        });
    }

    // match height
    const matchHeightSelector = '.equal-height';
    const matchHeightElements = document.querySelectorAll(matchHeightSelector);
    if (matchHeightElements.length) {
        import('./components/matchheight').then(({ initMatchHeight }) => {
            initMatchHeight();
        })
    }

    // sliders
    const sliderSelector = '.slider';
    const sliders = document.querySelectorAll(sliderSelector);
    if (sliders.length) {
        import('./components/sliders').then(({ initSliders }) => {
            initSliders();
        });
    }

    // lightbox
    const popupSelector = '.modal-trigger, .glightbox';
    const popups = document.querySelectorAll(popupSelector);
    if (popups.length) {
        import('./components/popups-glightbox').then(({ initPopups }) => {
            initPopups();
        });
    }

    // tabs
    // tabs
    const tabsSelector = '.tabs';
    const tabs = document.querySelectorAll(tabsSelector);
    if (tabs.length) {
        import('./components/tabs').then(({ tabs, initTabs }) => {
            tabs();
            initTabs();
        });
    }

    // OpenLayer maps
    const maps = document.querySelectorAll('.ol-map');
    if (maps.length) {
        import('./components/openlayers').then(({ olMap }) => {
            olMap(maps);
        });
    }

    // Google maps
    /* const gmaps = document.querySelectorAll('.gmap');
    if (gmaps.length) {
        import('./components/gmap').then(({ loadGoogleMaps }) => {
            loadGoogleMaps();
        });
    } */

    // accordions
    const accordions = document.querySelectorAll('.accordion');
    if (accordions.length) {
        import('./components/accordion').then(({ initAccordions }) => {
            initAccordions();
        });
    }

    // tooltips
    const tooltips = document.querySelectorAll('.tooltip');
    if (tooltips.length) {
        import('./components/tooltip').then(({ initTooltips }) => {
            initTooltips();
        });
    }
})
