<?php

use Twig\TwigFunction;

$root = $_SERVER['DOCUMENT_ROOT'];
$request = $_SERVER['REQUEST_URI'];
$templates = $root.'/templates';

require_once $root.'/vendor/autoload.php';

// load templates
$loader = new \Twig\Loader\FilesystemLoader([$root, $templates]);
$twig = new \Twig\Environment($loader, array(
    'cache' => false,
    'debug' => true,
));
$twig->addExtension(new \Twig\Extension\DebugExtension());

// add twig extensions to render webpack encore script/style tags
$webpackScript = new TwigFunction('script_tags', 'renderWebpackScriptTags', ['is_safe' => ['html']]);;
$twig->addFunction($webpackScript);

$webpackStyle = new TwigFunction('style_tags', 'renderWebpackStyleTags', ['is_safe' => ['html']]);;
$twig->addFunction($webpackStyle);

// render the template
echo $twig->render(trim($request, '/') ? '/templates/'. trim($request, '/') : '/templates/01_index.html.twig');


function renderWebpackScriptTags($entrypoint, $buildPath) {
	$result = '';
	if(!$entrypoint) return $result;

	$entrypointsPath = $buildPath . '/entrypoints.json';
	if(!file_exists($entrypointsPath)) return $result;

	$content = file_get_contents($entrypointsPath);
	if ($content === false) return $result;
	$entrypoints = json_decode($content, true);
	if ($entrypoints === null) return $result;

	$scripts = null;
	try {
		$scripts = $entrypoints['entrypoints'][$entrypoint]['js'];
	}
	catch (Throwable $e) {}

	if (!$scripts) return $result;

	foreach($scripts as $script) {
		$result .= '<script src="' . $script . '" defer preload></script>';
	}
	return $result;
}

function renderWebpackStyleTags($entrypoint, $buildPath) {
	$result = '';
	if(!$entrypoint) return $result;

	$entrypointsPath = $buildPath . '/entrypoints.json';
	if(!file_exists($entrypointsPath)) return $result;

	$content = file_get_contents($entrypointsPath);
	if ($content === false) return $result;
	$entrypoints = json_decode($content, true);
	if ($entrypoints === null) return $result;

	$styles = null;
	try {
		$styles = $entrypoints['entrypoints'][$entrypoint]['css'];
	}
	catch (Throwable $e) {}

	if (!$styles) return $result;

	foreach($styles as $style) {
		$result .= '<link rel="stylesheet" href="' . $style . '">';
	}
	return $result;
}
