"use strict";
(self["webpackChunkporta_frontend_starter_kit"] = self["webpackChunkporta_frontend_starter_kit"] || []).push([["assets_js_components_sliders_js"],{

/***/ "./assets/js/components/sliders.js":
/*!*****************************************!*\
  !*** ./assets/js/components/sliders.js ***!
  \*****************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "initSliders": function() { return /* binding */ initSliders; },
/* harmony export */   "sliderSelector": function() { return /* binding */ sliderSelector; }
/* harmony export */ });
/* harmony import */ var jquery__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! jquery */ "./node_modules/jquery/dist/jquery.js");
/* harmony import */ var jquery__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(jquery__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var tiny_slider__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! tiny-slider */ "./node_modules/tiny-slider/dist/tiny-slider.js");


const sliderSelector = '.slider';
window.sliders = [];

const initSliders = () => {
  // Sliders initialization

  /* Generic item slider */
  const itemSliders = jquery__WEBPACK_IMPORTED_MODULE_0___default()('.item-slider');
  initItemSliders(itemSliders);
  const teaserSlider = jquery__WEBPACK_IMPORTED_MODULE_0___default()('.teaser-slider .slider__container');

  if (teaserSlider.length) {
    const autoplayButton = jquery__WEBPACK_IMPORTED_MODULE_0___default()('.teaser-slider-autoplay');
    (0,tiny_slider__WEBPACK_IMPORTED_MODULE_1__.tns)({
      container: teaserSlider.get(0),
      autoplay: autoplayButton.length > 0,
      loop: true,
      prevButton: '.slider__prev',
      nextButton: '.slider__next',
      navContainer: '.teaser-slider-nav__list',
      autoplayButton: autoplayButton.length ? autoplayButton.get(0) : false,
      autoplayButtonOutput: false,
      autoplayTimeout: 4000,
      items: 1,
      slideBy: 1,
      mode: 'gallery',
      speed: 800,
      animateIn: 'slider__panel--fade-in',
      animateOut: 'slider__panel--fade-out'
    });
  }
};

function initItemSliders(items) {
  const sliders = window.sliders;
  /* Generic item slider */

  items.each(function (index) {
    createSlider(jquery__WEBPACK_IMPORTED_MODULE_0___default()(this), index);
  });
  jquery__WEBPACK_IMPORTED_MODULE_0___default()(window).on('resizeEnd focus', function () {
    for (const sliderId in sliders) {
      if (!sliders[sliderId]) continue;
      const range = getRange();

      if (!sliders[sliderId]['enabled-' + range]) {
        sliders[sliderId].controls.hide();
      } else {
        if (typeof sliders[sliderId].slider !== 'undefined') {
          sliders[sliderId].controls.show();
        }
      }

      window.dispatchEvent(new Event('contentResize'));
    }
  }).resize();
}

function createSlider(el, index) {
  const sliders = window.sliders;
  const sliderId = 'itemSlider' + index;
  const controlsSelector = '.slider__controls';
  const controls = el.find(controlsSelector);
  const currentRange = getRange();
  const panels = el.find('.slider__panel');
  sliders[sliderId] = [];
  sliders[sliderId].element = el;
  sliders[sliderId].controls = controls;
  sliders[sliderId]['initial-slide'] = el.data('initial-slide');
  sliders[sliderId].autoWidth = el.data('autowidth');
  const attributes = ['items', 'move', 'enabled'];
  const attrDefaultValues = ['1', '1', true];
  const ranges = {
    xl: 1370,
    lg: 1200,
    md: 992,
    sm: 768,
    xs: 576,
    xxs: 0
  };
  attributes.forEach(function (attr, i) {
    let currentValue = attrDefaultValues[i];

    for (const rangeKey in ranges) {
      const defaultValue = currentValue; // e.g. sliders[sliderId]['items-lg'] = el.data('items-lg') ? el.data('items-lg') : sliders[sliderId]['items-xl'];

      const value = el.data(attr + '-' + rangeKey);
      sliders[sliderId][attr + '-' + rangeKey] = typeof value !== 'undefined' ? value : defaultValue;
      currentValue = sliders[sliderId][attr + '-' + rangeKey];
    }
  });
  const responsiveConfig = {};
  let defaultSlidesCount = 1;
  let defaultMoveCount = 1;
  let defaultEnabled = true;

  for (const rangeKey in ranges) {
    const breakpoint = ranges[rangeKey];
    const slidesCount = typeof el.data('items-' + rangeKey) !== 'undefined' ? el.data('items-' + rangeKey) : defaultSlidesCount;
    const moveCount = typeof el.data('move-' + rangeKey) !== 'undefined' ? el.data('move-' + rangeKey) : defaultMoveCount;
    const enabled = typeof el.data('enabled-' + rangeKey) !== 'undefined' ? el.data('enabled-' + rangeKey) : defaultEnabled;
    responsiveConfig[breakpoint] = {
      items: slidesCount,
      slideBy: moveCount,
      disable: !enabled
    };
    defaultSlidesCount = slidesCount;
    defaultMoveCount = moveCount;
    defaultEnabled = enabled;
  }

  sliders[sliderId].panels = panels;
  sliders[sliderId].responsiveConfig = responsiveConfig;

  if (sliders[sliderId]['enabled-' + currentRange]) {
    initSlider(sliderId);
  } else {
    enableLoadMore(sliderId);
  }
}

function enableLoadMore(sliderId) {
  const sliders = window.sliders;
  sliders[sliderId].controls.hide();
  const loadMore = sliders[sliderId]['load-more'];
  const range = getRange();
  const slideCount = sliders[sliderId]['items-' + range];

  if (typeof loadMore !== 'undefined') {
    loadMore.show();
    sliders[sliderId].panels.slice(slideCount).hide();
  }
}

function initSlider(sliderId) {
  const sliders = window.sliders;
  const range = getRange();
  const slideRange = 'items-' + range;
  const moveRange = 'move-' + range;
  const itemsCount = sliders[sliderId][slideRange];
  const moveCount = sliders[sliderId][moveRange];
  const controls = sliders[sliderId].controls;
  const el = sliders[sliderId].element;
  const initialSlide = sliders[sliderId]['initial-slide'];
  const sliderEl = el.find('.slider__container');
  const prevBtn = el.find('.slider__prev');
  const nextBtn = el.find('.slider__next');

  if (sliderEl.length) {
    controls.show();
    el.addClass('item-slider--active'); // const popupSelector = '.modal-trigger, .glightbox';
    // const popups = document.querySelectorAll(popupSelector);

    const slider = (0,tiny_slider__WEBPACK_IMPORTED_MODULE_1__.tns)({
      container: sliderEl.get(0),
      autoWidth: sliders[sliderId].autoWidth,
      loop: true,
      prevButton: prevBtn.length ? prevBtn.get(0) : true,
      nextButton: nextBtn.length ? nextBtn.get(0) : true,
      nav: false,
      items: itemsCount,
      slideBy: moveCount,
      startIndex: initialSlide,
      responsive: sliders[sliderId].responsiveConfig
      /* onInit: function () {
          if (popups.length) {
              import('./popups').then(({ initPopups }) => {
                  initPopups();
              });
          }
      } */

    });
    sliders[sliderId].slider = slider;
  } else {
    controls.hide();
    el.removeClass('item-slider--active');
  }

  window.dispatchEvent(new Event('resize'));
}

function getRange() {
  const width = jquery__WEBPACK_IMPORTED_MODULE_0___default()(window).width();

  if (width >= 1200) {
    return 'xl';
  } else if (width > 992) {
    return 'lg';
  } else if (width > 768) {
    return 'md';
  } else if (width > 576) {
    return 'sm';
  } else {
    return 'xs';
  }
}



/***/ })

}]);
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiYXNzZXRzX2pzX2NvbXBvbmVudHNfc2xpZGVyc19qcy5qcyIsIm1hcHBpbmdzIjoiOzs7Ozs7Ozs7Ozs7Ozs7OztBQUFBO0FBQ0E7QUFFQSxNQUFNRSxjQUFjLEdBQUcsU0FBdkI7QUFFQUMsTUFBTSxDQUFDQyxPQUFQLEdBQWlCLEVBQWpCOztBQUNBLE1BQU1DLFdBQVcsR0FBRyxNQUFNO0FBQ3RCOztBQUNBO0FBQ0EsUUFBTUMsV0FBVyxHQUFHTiw2Q0FBQyxDQUFDLGNBQUQsQ0FBckI7QUFDQU8sRUFBQUEsZUFBZSxDQUFDRCxXQUFELENBQWY7QUFFQSxRQUFNRSxZQUFZLEdBQUdSLDZDQUFDLENBQUMsbUNBQUQsQ0FBdEI7O0FBQ0EsTUFBSVEsWUFBWSxDQUFDQyxNQUFqQixFQUF5QjtBQUNyQixVQUFNQyxjQUFjLEdBQUdWLDZDQUFDLENBQUMseUJBQUQsQ0FBeEI7QUFDQUMsSUFBQUEsZ0RBQUcsQ0FBQztBQUNBVSxNQUFBQSxTQUFTLEVBQUVILFlBQVksQ0FBQ0ksR0FBYixDQUFpQixDQUFqQixDQURYO0FBRUFDLE1BQUFBLFFBQVEsRUFBRUgsY0FBYyxDQUFDRCxNQUFmLEdBQXdCLENBRmxDO0FBR0FLLE1BQUFBLElBQUksRUFBRSxJQUhOO0FBSUFDLE1BQUFBLFVBQVUsRUFBRSxlQUpaO0FBS0FDLE1BQUFBLFVBQVUsRUFBRSxlQUxaO0FBTUFDLE1BQUFBLFlBQVksRUFBRSwwQkFOZDtBQU9BUCxNQUFBQSxjQUFjLEVBQUVBLGNBQWMsQ0FBQ0QsTUFBZixHQUNWQyxjQUFjLENBQUNFLEdBQWYsQ0FBbUIsQ0FBbkIsQ0FEVSxHQUVWLEtBVE47QUFVQU0sTUFBQUEsb0JBQW9CLEVBQUUsS0FWdEI7QUFXQUMsTUFBQUEsZUFBZSxFQUFFLElBWGpCO0FBWUFDLE1BQUFBLEtBQUssRUFBRSxDQVpQO0FBYUFDLE1BQUFBLE9BQU8sRUFBRSxDQWJUO0FBY0FDLE1BQUFBLElBQUksRUFBRSxTQWROO0FBZUFDLE1BQUFBLEtBQUssRUFBRSxHQWZQO0FBZ0JBQyxNQUFBQSxTQUFTLEVBQUUsd0JBaEJYO0FBaUJBQyxNQUFBQSxVQUFVLEVBQUU7QUFqQlosS0FBRCxDQUFIO0FBbUJIO0FBQ0osQ0E3QkQ7O0FBK0JBLFNBQVNsQixlQUFULENBQTBCYSxLQUExQixFQUFpQztBQUM3QixRQUFNaEIsT0FBTyxHQUFHRCxNQUFNLENBQUNDLE9BQXZCO0FBRUE7O0FBQ0FnQixFQUFBQSxLQUFLLENBQUNNLElBQU4sQ0FBVyxVQUFVQyxLQUFWLEVBQWlCO0FBQ3hCQyxJQUFBQSxZQUFZLENBQUM1Qiw2Q0FBQyxDQUFDLElBQUQsQ0FBRixFQUFVMkIsS0FBVixDQUFaO0FBQ0gsR0FGRDtBQUlBM0IsRUFBQUEsNkNBQUMsQ0FBQ0csTUFBRCxDQUFELENBQ0swQixFQURMLENBQ1EsaUJBRFIsRUFDMkIsWUFBWTtBQUMvQixTQUFLLE1BQU1DLFFBQVgsSUFBdUIxQixPQUF2QixFQUFnQztBQUM1QixVQUFJLENBQUNBLE9BQU8sQ0FBQzBCLFFBQUQsQ0FBWixFQUF3QjtBQUV4QixZQUFNQyxLQUFLLEdBQUdDLFFBQVEsRUFBdEI7O0FBRUEsVUFBSSxDQUFDNUIsT0FBTyxDQUFDMEIsUUFBRCxDQUFQLENBQWtCLGFBQWFDLEtBQS9CLENBQUwsRUFBNEM7QUFDeEMzQixRQUFBQSxPQUFPLENBQUMwQixRQUFELENBQVAsQ0FBa0JHLFFBQWxCLENBQTJCQyxJQUEzQjtBQUNILE9BRkQsTUFFTztBQUNILFlBQUksT0FBTzlCLE9BQU8sQ0FBQzBCLFFBQUQsQ0FBUCxDQUFrQkssTUFBekIsS0FBb0MsV0FBeEMsRUFBcUQ7QUFDakQvQixVQUFBQSxPQUFPLENBQUMwQixRQUFELENBQVAsQ0FBa0JHLFFBQWxCLENBQTJCRyxJQUEzQjtBQUNIO0FBQ0o7O0FBRURqQyxNQUFBQSxNQUFNLENBQUNrQyxhQUFQLENBQXFCLElBQUlDLEtBQUosQ0FBVSxlQUFWLENBQXJCO0FBQ0g7QUFDSixHQWpCTCxFQWtCS0MsTUFsQkw7QUFtQkg7O0FBRUQsU0FBU1gsWUFBVCxDQUF1QlksRUFBdkIsRUFBMkJiLEtBQTNCLEVBQWtDO0FBQzlCLFFBQU12QixPQUFPLEdBQUdELE1BQU0sQ0FBQ0MsT0FBdkI7QUFFQSxRQUFNMEIsUUFBUSxHQUFHLGVBQWVILEtBQWhDO0FBQ0EsUUFBTWMsZ0JBQWdCLEdBQUcsbUJBQXpCO0FBQ0EsUUFBTVIsUUFBUSxHQUFHTyxFQUFFLENBQUNFLElBQUgsQ0FBUUQsZ0JBQVIsQ0FBakI7QUFDQSxRQUFNRSxZQUFZLEdBQUdYLFFBQVEsRUFBN0I7QUFDQSxRQUFNWSxNQUFNLEdBQUdKLEVBQUUsQ0FBQ0UsSUFBSCxDQUFRLGdCQUFSLENBQWY7QUFFQXRDLEVBQUFBLE9BQU8sQ0FBQzBCLFFBQUQsQ0FBUCxHQUFvQixFQUFwQjtBQUVBMUIsRUFBQUEsT0FBTyxDQUFDMEIsUUFBRCxDQUFQLENBQWtCZSxPQUFsQixHQUE0QkwsRUFBNUI7QUFDQXBDLEVBQUFBLE9BQU8sQ0FBQzBCLFFBQUQsQ0FBUCxDQUFrQkcsUUFBbEIsR0FBNkJBLFFBQTdCO0FBQ0E3QixFQUFBQSxPQUFPLENBQUMwQixRQUFELENBQVAsQ0FBa0IsZUFBbEIsSUFBcUNVLEVBQUUsQ0FBQ00sSUFBSCxDQUFRLGVBQVIsQ0FBckM7QUFDQTFDLEVBQUFBLE9BQU8sQ0FBQzBCLFFBQUQsQ0FBUCxDQUFrQmlCLFNBQWxCLEdBQThCUCxFQUFFLENBQUNNLElBQUgsQ0FBUSxXQUFSLENBQTlCO0FBRUEsUUFBTUUsVUFBVSxHQUFHLENBQUMsT0FBRCxFQUFVLE1BQVYsRUFBa0IsU0FBbEIsQ0FBbkI7QUFDQSxRQUFNQyxpQkFBaUIsR0FBRyxDQUFDLEdBQUQsRUFBTSxHQUFOLEVBQVcsSUFBWCxDQUExQjtBQUVBLFFBQU1DLE1BQU0sR0FBRztBQUFFQyxJQUFBQSxFQUFFLEVBQUUsSUFBTjtBQUFZQyxJQUFBQSxFQUFFLEVBQUUsSUFBaEI7QUFBc0JDLElBQUFBLEVBQUUsRUFBRSxHQUExQjtBQUErQkMsSUFBQUEsRUFBRSxFQUFFLEdBQW5DO0FBQXdDQyxJQUFBQSxFQUFFLEVBQUUsR0FBNUM7QUFBaURDLElBQUFBLEdBQUcsRUFBRTtBQUF0RCxHQUFmO0FBRUFSLEVBQUFBLFVBQVUsQ0FBQ1MsT0FBWCxDQUFtQixVQUFVQyxJQUFWLEVBQWdCQyxDQUFoQixFQUFtQjtBQUNsQyxRQUFJQyxZQUFZLEdBQUdYLGlCQUFpQixDQUFDVSxDQUFELENBQXBDOztBQUVBLFNBQUssTUFBTUUsUUFBWCxJQUF1QlgsTUFBdkIsRUFBK0I7QUFDM0IsWUFBTVksWUFBWSxHQUFHRixZQUFyQixDQUQyQixDQUczQjs7QUFDQSxZQUFNRyxLQUFLLEdBQUd2QixFQUFFLENBQUNNLElBQUgsQ0FBUVksSUFBSSxHQUFHLEdBQVAsR0FBYUcsUUFBckIsQ0FBZDtBQUNBekQsTUFBQUEsT0FBTyxDQUFDMEIsUUFBRCxDQUFQLENBQWtCNEIsSUFBSSxHQUFHLEdBQVAsR0FBYUcsUUFBL0IsSUFDSSxPQUFPRSxLQUFQLEtBQWlCLFdBQWpCLEdBQStCQSxLQUEvQixHQUF1Q0QsWUFEM0M7QUFHQUYsTUFBQUEsWUFBWSxHQUFHeEQsT0FBTyxDQUFDMEIsUUFBRCxDQUFQLENBQWtCNEIsSUFBSSxHQUFHLEdBQVAsR0FBYUcsUUFBL0IsQ0FBZjtBQUNIO0FBQ0osR0FiRDtBQWVBLFFBQU1HLGdCQUFnQixHQUFHLEVBQXpCO0FBQ0EsTUFBSUMsa0JBQWtCLEdBQUcsQ0FBekI7QUFDQSxNQUFJQyxnQkFBZ0IsR0FBRyxDQUF2QjtBQUNBLE1BQUlDLGNBQWMsR0FBRyxJQUFyQjs7QUFDQSxPQUFLLE1BQU1OLFFBQVgsSUFBdUJYLE1BQXZCLEVBQStCO0FBQzNCLFVBQU1rQixVQUFVLEdBQUdsQixNQUFNLENBQUNXLFFBQUQsQ0FBekI7QUFDQSxVQUFNUSxXQUFXLEdBQ2IsT0FBTzdCLEVBQUUsQ0FBQ00sSUFBSCxDQUFRLFdBQVdlLFFBQW5CLENBQVAsS0FBd0MsV0FBeEMsR0FDTXJCLEVBQUUsQ0FBQ00sSUFBSCxDQUFRLFdBQVdlLFFBQW5CLENBRE4sR0FFTUksa0JBSFY7QUFJQSxVQUFNSyxTQUFTLEdBQ1gsT0FBTzlCLEVBQUUsQ0FBQ00sSUFBSCxDQUFRLFVBQVVlLFFBQWxCLENBQVAsS0FBdUMsV0FBdkMsR0FDTXJCLEVBQUUsQ0FBQ00sSUFBSCxDQUFRLFVBQVVlLFFBQWxCLENBRE4sR0FFTUssZ0JBSFY7QUFJQSxVQUFNSyxPQUFPLEdBQ1QsT0FBTy9CLEVBQUUsQ0FBQ00sSUFBSCxDQUFRLGFBQWFlLFFBQXJCLENBQVAsS0FBMEMsV0FBMUMsR0FDTXJCLEVBQUUsQ0FBQ00sSUFBSCxDQUFRLGFBQWFlLFFBQXJCLENBRE4sR0FFTU0sY0FIVjtBQUlBSCxJQUFBQSxnQkFBZ0IsQ0FBQ0ksVUFBRCxDQUFoQixHQUErQjtBQUMzQmhELE1BQUFBLEtBQUssRUFBRWlELFdBRG9CO0FBRTNCaEQsTUFBQUEsT0FBTyxFQUFFaUQsU0FGa0I7QUFHM0JFLE1BQUFBLE9BQU8sRUFBRSxDQUFDRDtBQUhpQixLQUEvQjtBQU1BTixJQUFBQSxrQkFBa0IsR0FBR0ksV0FBckI7QUFDQUgsSUFBQUEsZ0JBQWdCLEdBQUdJLFNBQW5CO0FBQ0FILElBQUFBLGNBQWMsR0FBR0ksT0FBakI7QUFDSDs7QUFFRG5FLEVBQUFBLE9BQU8sQ0FBQzBCLFFBQUQsQ0FBUCxDQUFrQmMsTUFBbEIsR0FBMkJBLE1BQTNCO0FBQ0F4QyxFQUFBQSxPQUFPLENBQUMwQixRQUFELENBQVAsQ0FBa0JrQyxnQkFBbEIsR0FBcUNBLGdCQUFyQzs7QUFFQSxNQUFJNUQsT0FBTyxDQUFDMEIsUUFBRCxDQUFQLENBQWtCLGFBQWFhLFlBQS9CLENBQUosRUFBa0Q7QUFDOUM4QixJQUFBQSxVQUFVLENBQUMzQyxRQUFELENBQVY7QUFDSCxHQUZELE1BRU87QUFDSDRDLElBQUFBLGNBQWMsQ0FBQzVDLFFBQUQsQ0FBZDtBQUNIO0FBQ0o7O0FBRUQsU0FBUzRDLGNBQVQsQ0FBeUI1QyxRQUF6QixFQUFtQztBQUMvQixRQUFNMUIsT0FBTyxHQUFHRCxNQUFNLENBQUNDLE9BQXZCO0FBRUFBLEVBQUFBLE9BQU8sQ0FBQzBCLFFBQUQsQ0FBUCxDQUFrQkcsUUFBbEIsQ0FBMkJDLElBQTNCO0FBRUEsUUFBTXlDLFFBQVEsR0FBR3ZFLE9BQU8sQ0FBQzBCLFFBQUQsQ0FBUCxDQUFrQixXQUFsQixDQUFqQjtBQUNBLFFBQU1DLEtBQUssR0FBR0MsUUFBUSxFQUF0QjtBQUNBLFFBQU00QyxVQUFVLEdBQUd4RSxPQUFPLENBQUMwQixRQUFELENBQVAsQ0FBa0IsV0FBV0MsS0FBN0IsQ0FBbkI7O0FBQ0EsTUFBSSxPQUFPNEMsUUFBUCxLQUFvQixXQUF4QixFQUFxQztBQUNqQ0EsSUFBQUEsUUFBUSxDQUFDdkMsSUFBVDtBQUNBaEMsSUFBQUEsT0FBTyxDQUFDMEIsUUFBRCxDQUFQLENBQWtCYyxNQUFsQixDQUF5QmlDLEtBQXpCLENBQStCRCxVQUEvQixFQUEyQzFDLElBQTNDO0FBQ0g7QUFDSjs7QUFFRCxTQUFTdUMsVUFBVCxDQUFxQjNDLFFBQXJCLEVBQStCO0FBQzNCLFFBQU0xQixPQUFPLEdBQUdELE1BQU0sQ0FBQ0MsT0FBdkI7QUFFQSxRQUFNMkIsS0FBSyxHQUFHQyxRQUFRLEVBQXRCO0FBQ0EsUUFBTThDLFVBQVUsR0FBRyxXQUFXL0MsS0FBOUI7QUFDQSxRQUFNZ0QsU0FBUyxHQUFHLFVBQVVoRCxLQUE1QjtBQUNBLFFBQU1pRCxVQUFVLEdBQUc1RSxPQUFPLENBQUMwQixRQUFELENBQVAsQ0FBa0JnRCxVQUFsQixDQUFuQjtBQUNBLFFBQU1SLFNBQVMsR0FBR2xFLE9BQU8sQ0FBQzBCLFFBQUQsQ0FBUCxDQUFrQmlELFNBQWxCLENBQWxCO0FBQ0EsUUFBTTlDLFFBQVEsR0FBRzdCLE9BQU8sQ0FBQzBCLFFBQUQsQ0FBUCxDQUFrQkcsUUFBbkM7QUFDQSxRQUFNTyxFQUFFLEdBQUdwQyxPQUFPLENBQUMwQixRQUFELENBQVAsQ0FBa0JlLE9BQTdCO0FBQ0EsUUFBTW9DLFlBQVksR0FBRzdFLE9BQU8sQ0FBQzBCLFFBQUQsQ0FBUCxDQUFrQixlQUFsQixDQUFyQjtBQUVBLFFBQU1vRCxRQUFRLEdBQUcxQyxFQUFFLENBQUNFLElBQUgsQ0FBUSxvQkFBUixDQUFqQjtBQUNBLFFBQU15QyxPQUFPLEdBQUczQyxFQUFFLENBQUNFLElBQUgsQ0FBUSxlQUFSLENBQWhCO0FBQ0EsUUFBTTBDLE9BQU8sR0FBRzVDLEVBQUUsQ0FBQ0UsSUFBSCxDQUFRLGVBQVIsQ0FBaEI7O0FBQ0EsTUFBSXdDLFFBQVEsQ0FBQ3pFLE1BQWIsRUFBcUI7QUFDakJ3QixJQUFBQSxRQUFRLENBQUNHLElBQVQ7QUFDQUksSUFBQUEsRUFBRSxDQUFDNkMsUUFBSCxDQUFZLHFCQUFaLEVBRmlCLENBSWpCO0FBQ0E7O0FBRUEsVUFBTWxELE1BQU0sR0FBR2xDLGdEQUFHLENBQUM7QUFDZlUsTUFBQUEsU0FBUyxFQUFFdUUsUUFBUSxDQUFDdEUsR0FBVCxDQUFhLENBQWIsQ0FESTtBQUVmbUMsTUFBQUEsU0FBUyxFQUFFM0MsT0FBTyxDQUFDMEIsUUFBRCxDQUFQLENBQWtCaUIsU0FGZDtBQUdmakMsTUFBQUEsSUFBSSxFQUFFLElBSFM7QUFJZkMsTUFBQUEsVUFBVSxFQUFFb0UsT0FBTyxDQUFDMUUsTUFBUixHQUFpQjBFLE9BQU8sQ0FBQ3ZFLEdBQVIsQ0FBWSxDQUFaLENBQWpCLEdBQWtDLElBSi9CO0FBS2ZJLE1BQUFBLFVBQVUsRUFBRW9FLE9BQU8sQ0FBQzNFLE1BQVIsR0FBaUIyRSxPQUFPLENBQUN4RSxHQUFSLENBQVksQ0FBWixDQUFqQixHQUFrQyxJQUwvQjtBQU1mMEUsTUFBQUEsR0FBRyxFQUFFLEtBTlU7QUFPZmxFLE1BQUFBLEtBQUssRUFBRTRELFVBUFE7QUFRZjNELE1BQUFBLE9BQU8sRUFBRWlELFNBUk07QUFTZmlCLE1BQUFBLFVBQVUsRUFBRU4sWUFURztBQVVmTyxNQUFBQSxVQUFVLEVBQUVwRixPQUFPLENBQUMwQixRQUFELENBQVAsQ0FBa0JrQztBQUM5QjtBQUNaO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTs7QUFqQjJCLEtBQUQsQ0FBbEI7QUFtQkE1RCxJQUFBQSxPQUFPLENBQUMwQixRQUFELENBQVAsQ0FBa0JLLE1BQWxCLEdBQTJCQSxNQUEzQjtBQUNILEdBM0JELE1BMkJPO0FBQ0hGLElBQUFBLFFBQVEsQ0FBQ0MsSUFBVDtBQUNBTSxJQUFBQSxFQUFFLENBQUNpRCxXQUFILENBQWUscUJBQWY7QUFDSDs7QUFFRHRGLEVBQUFBLE1BQU0sQ0FBQ2tDLGFBQVAsQ0FBcUIsSUFBSUMsS0FBSixDQUFVLFFBQVYsQ0FBckI7QUFDSDs7QUFFRCxTQUFTTixRQUFULEdBQXFCO0FBQ2pCLFFBQU0wRCxLQUFLLEdBQUcxRiw2Q0FBQyxDQUFDRyxNQUFELENBQUQsQ0FBVXVGLEtBQVYsRUFBZDs7QUFFQSxNQUFJQSxLQUFLLElBQUksSUFBYixFQUFtQjtBQUNmLFdBQU8sSUFBUDtBQUNILEdBRkQsTUFFTyxJQUFJQSxLQUFLLEdBQUcsR0FBWixFQUFpQjtBQUNwQixXQUFPLElBQVA7QUFDSCxHQUZNLE1BRUEsSUFBSUEsS0FBSyxHQUFHLEdBQVosRUFBaUI7QUFDcEIsV0FBTyxJQUFQO0FBQ0gsR0FGTSxNQUVBLElBQUlBLEtBQUssR0FBRyxHQUFaLEVBQWlCO0FBQ3BCLFdBQU8sSUFBUDtBQUNILEdBRk0sTUFFQTtBQUNILFdBQU8sSUFBUDtBQUNIO0FBQ0oiLCJzb3VyY2VzIjpbIndlYnBhY2s6Ly9wb3J0YS1mcm9udGVuZC1zdGFydGVyLWtpdC8uL2Fzc2V0cy9qcy9jb21wb25lbnRzL3NsaWRlcnMuanMiXSwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0ICQgZnJvbSAnanF1ZXJ5JztcbmltcG9ydCB7IHRucyB9IGZyb20gJ3Rpbnktc2xpZGVyJztcblxuY29uc3Qgc2xpZGVyU2VsZWN0b3IgPSAnLnNsaWRlcic7XG5cbndpbmRvdy5zbGlkZXJzID0gW107XG5jb25zdCBpbml0U2xpZGVycyA9ICgpID0+IHtcbiAgICAvLyBTbGlkZXJzIGluaXRpYWxpemF0aW9uXG4gICAgLyogR2VuZXJpYyBpdGVtIHNsaWRlciAqL1xuICAgIGNvbnN0IGl0ZW1TbGlkZXJzID0gJCgnLml0ZW0tc2xpZGVyJyk7XG4gICAgaW5pdEl0ZW1TbGlkZXJzKGl0ZW1TbGlkZXJzKTtcblxuICAgIGNvbnN0IHRlYXNlclNsaWRlciA9ICQoJy50ZWFzZXItc2xpZGVyIC5zbGlkZXJfX2NvbnRhaW5lcicpO1xuICAgIGlmICh0ZWFzZXJTbGlkZXIubGVuZ3RoKSB7XG4gICAgICAgIGNvbnN0IGF1dG9wbGF5QnV0dG9uID0gJCgnLnRlYXNlci1zbGlkZXItYXV0b3BsYXknKTtcbiAgICAgICAgdG5zKHtcbiAgICAgICAgICAgIGNvbnRhaW5lcjogdGVhc2VyU2xpZGVyLmdldCgwKSxcbiAgICAgICAgICAgIGF1dG9wbGF5OiBhdXRvcGxheUJ1dHRvbi5sZW5ndGggPiAwLFxuICAgICAgICAgICAgbG9vcDogdHJ1ZSxcbiAgICAgICAgICAgIHByZXZCdXR0b246ICcuc2xpZGVyX19wcmV2JyxcbiAgICAgICAgICAgIG5leHRCdXR0b246ICcuc2xpZGVyX19uZXh0JyxcbiAgICAgICAgICAgIG5hdkNvbnRhaW5lcjogJy50ZWFzZXItc2xpZGVyLW5hdl9fbGlzdCcsXG4gICAgICAgICAgICBhdXRvcGxheUJ1dHRvbjogYXV0b3BsYXlCdXR0b24ubGVuZ3RoXG4gICAgICAgICAgICAgICAgPyBhdXRvcGxheUJ1dHRvbi5nZXQoMClcbiAgICAgICAgICAgICAgICA6IGZhbHNlLFxuICAgICAgICAgICAgYXV0b3BsYXlCdXR0b25PdXRwdXQ6IGZhbHNlLFxuICAgICAgICAgICAgYXV0b3BsYXlUaW1lb3V0OiA0MDAwLFxuICAgICAgICAgICAgaXRlbXM6IDEsXG4gICAgICAgICAgICBzbGlkZUJ5OiAxLFxuICAgICAgICAgICAgbW9kZTogJ2dhbGxlcnknLFxuICAgICAgICAgICAgc3BlZWQ6IDgwMCxcbiAgICAgICAgICAgIGFuaW1hdGVJbjogJ3NsaWRlcl9fcGFuZWwtLWZhZGUtaW4nLFxuICAgICAgICAgICAgYW5pbWF0ZU91dDogJ3NsaWRlcl9fcGFuZWwtLWZhZGUtb3V0J1xuICAgICAgICB9KTtcbiAgICB9XG59O1xuXG5mdW5jdGlvbiBpbml0SXRlbVNsaWRlcnMgKGl0ZW1zKSB7XG4gICAgY29uc3Qgc2xpZGVycyA9IHdpbmRvdy5zbGlkZXJzO1xuXG4gICAgLyogR2VuZXJpYyBpdGVtIHNsaWRlciAqL1xuICAgIGl0ZW1zLmVhY2goZnVuY3Rpb24gKGluZGV4KSB7XG4gICAgICAgIGNyZWF0ZVNsaWRlcigkKHRoaXMpLCBpbmRleCk7XG4gICAgfSk7XG5cbiAgICAkKHdpbmRvdylcbiAgICAgICAgLm9uKCdyZXNpemVFbmQgZm9jdXMnLCBmdW5jdGlvbiAoKSB7XG4gICAgICAgICAgICBmb3IgKGNvbnN0IHNsaWRlcklkIGluIHNsaWRlcnMpIHtcbiAgICAgICAgICAgICAgICBpZiAoIXNsaWRlcnNbc2xpZGVySWRdKSBjb250aW51ZTtcblxuICAgICAgICAgICAgICAgIGNvbnN0IHJhbmdlID0gZ2V0UmFuZ2UoKTtcblxuICAgICAgICAgICAgICAgIGlmICghc2xpZGVyc1tzbGlkZXJJZF1bJ2VuYWJsZWQtJyArIHJhbmdlXSkge1xuICAgICAgICAgICAgICAgICAgICBzbGlkZXJzW3NsaWRlcklkXS5jb250cm9scy5oaWRlKCk7XG4gICAgICAgICAgICAgICAgfSBlbHNlIHtcbiAgICAgICAgICAgICAgICAgICAgaWYgKHR5cGVvZiBzbGlkZXJzW3NsaWRlcklkXS5zbGlkZXIgIT09ICd1bmRlZmluZWQnKSB7XG4gICAgICAgICAgICAgICAgICAgICAgICBzbGlkZXJzW3NsaWRlcklkXS5jb250cm9scy5zaG93KCk7XG4gICAgICAgICAgICAgICAgICAgIH1cbiAgICAgICAgICAgICAgICB9XG5cbiAgICAgICAgICAgICAgICB3aW5kb3cuZGlzcGF0Y2hFdmVudChuZXcgRXZlbnQoJ2NvbnRlbnRSZXNpemUnKSk7XG4gICAgICAgICAgICB9XG4gICAgICAgIH0pXG4gICAgICAgIC5yZXNpemUoKTtcbn1cblxuZnVuY3Rpb24gY3JlYXRlU2xpZGVyIChlbCwgaW5kZXgpIHtcbiAgICBjb25zdCBzbGlkZXJzID0gd2luZG93LnNsaWRlcnM7XG5cbiAgICBjb25zdCBzbGlkZXJJZCA9ICdpdGVtU2xpZGVyJyArIGluZGV4O1xuICAgIGNvbnN0IGNvbnRyb2xzU2VsZWN0b3IgPSAnLnNsaWRlcl9fY29udHJvbHMnO1xuICAgIGNvbnN0IGNvbnRyb2xzID0gZWwuZmluZChjb250cm9sc1NlbGVjdG9yKTtcbiAgICBjb25zdCBjdXJyZW50UmFuZ2UgPSBnZXRSYW5nZSgpO1xuICAgIGNvbnN0IHBhbmVscyA9IGVsLmZpbmQoJy5zbGlkZXJfX3BhbmVsJyk7XG5cbiAgICBzbGlkZXJzW3NsaWRlcklkXSA9IFtdO1xuXG4gICAgc2xpZGVyc1tzbGlkZXJJZF0uZWxlbWVudCA9IGVsO1xuICAgIHNsaWRlcnNbc2xpZGVySWRdLmNvbnRyb2xzID0gY29udHJvbHM7XG4gICAgc2xpZGVyc1tzbGlkZXJJZF1bJ2luaXRpYWwtc2xpZGUnXSA9IGVsLmRhdGEoJ2luaXRpYWwtc2xpZGUnKTtcbiAgICBzbGlkZXJzW3NsaWRlcklkXS5hdXRvV2lkdGggPSBlbC5kYXRhKCdhdXRvd2lkdGgnKTtcblxuICAgIGNvbnN0IGF0dHJpYnV0ZXMgPSBbJ2l0ZW1zJywgJ21vdmUnLCAnZW5hYmxlZCddO1xuICAgIGNvbnN0IGF0dHJEZWZhdWx0VmFsdWVzID0gWycxJywgJzEnLCB0cnVlXTtcblxuICAgIGNvbnN0IHJhbmdlcyA9IHsgeGw6IDEzNzAsIGxnOiAxMjAwLCBtZDogOTkyLCBzbTogNzY4LCB4czogNTc2LCB4eHM6IDAgfTtcblxuICAgIGF0dHJpYnV0ZXMuZm9yRWFjaChmdW5jdGlvbiAoYXR0ciwgaSkge1xuICAgICAgICBsZXQgY3VycmVudFZhbHVlID0gYXR0ckRlZmF1bHRWYWx1ZXNbaV07XG5cbiAgICAgICAgZm9yIChjb25zdCByYW5nZUtleSBpbiByYW5nZXMpIHtcbiAgICAgICAgICAgIGNvbnN0IGRlZmF1bHRWYWx1ZSA9IGN1cnJlbnRWYWx1ZTtcblxuICAgICAgICAgICAgLy8gZS5nLiBzbGlkZXJzW3NsaWRlcklkXVsnaXRlbXMtbGcnXSA9IGVsLmRhdGEoJ2l0ZW1zLWxnJykgPyBlbC5kYXRhKCdpdGVtcy1sZycpIDogc2xpZGVyc1tzbGlkZXJJZF1bJ2l0ZW1zLXhsJ107XG4gICAgICAgICAgICBjb25zdCB2YWx1ZSA9IGVsLmRhdGEoYXR0ciArICctJyArIHJhbmdlS2V5KTtcbiAgICAgICAgICAgIHNsaWRlcnNbc2xpZGVySWRdW2F0dHIgKyAnLScgKyByYW5nZUtleV0gPVxuICAgICAgICAgICAgICAgIHR5cGVvZiB2YWx1ZSAhPT0gJ3VuZGVmaW5lZCcgPyB2YWx1ZSA6IGRlZmF1bHRWYWx1ZTtcblxuICAgICAgICAgICAgY3VycmVudFZhbHVlID0gc2xpZGVyc1tzbGlkZXJJZF1bYXR0ciArICctJyArIHJhbmdlS2V5XTtcbiAgICAgICAgfVxuICAgIH0pO1xuXG4gICAgY29uc3QgcmVzcG9uc2l2ZUNvbmZpZyA9IHt9O1xuICAgIGxldCBkZWZhdWx0U2xpZGVzQ291bnQgPSAxO1xuICAgIGxldCBkZWZhdWx0TW92ZUNvdW50ID0gMTtcbiAgICBsZXQgZGVmYXVsdEVuYWJsZWQgPSB0cnVlO1xuICAgIGZvciAoY29uc3QgcmFuZ2VLZXkgaW4gcmFuZ2VzKSB7XG4gICAgICAgIGNvbnN0IGJyZWFrcG9pbnQgPSByYW5nZXNbcmFuZ2VLZXldO1xuICAgICAgICBjb25zdCBzbGlkZXNDb3VudCA9XG4gICAgICAgICAgICB0eXBlb2YgZWwuZGF0YSgnaXRlbXMtJyArIHJhbmdlS2V5KSAhPT0gJ3VuZGVmaW5lZCdcbiAgICAgICAgICAgICAgICA/IGVsLmRhdGEoJ2l0ZW1zLScgKyByYW5nZUtleSlcbiAgICAgICAgICAgICAgICA6IGRlZmF1bHRTbGlkZXNDb3VudDtcbiAgICAgICAgY29uc3QgbW92ZUNvdW50ID1cbiAgICAgICAgICAgIHR5cGVvZiBlbC5kYXRhKCdtb3ZlLScgKyByYW5nZUtleSkgIT09ICd1bmRlZmluZWQnXG4gICAgICAgICAgICAgICAgPyBlbC5kYXRhKCdtb3ZlLScgKyByYW5nZUtleSlcbiAgICAgICAgICAgICAgICA6IGRlZmF1bHRNb3ZlQ291bnQ7XG4gICAgICAgIGNvbnN0IGVuYWJsZWQgPVxuICAgICAgICAgICAgdHlwZW9mIGVsLmRhdGEoJ2VuYWJsZWQtJyArIHJhbmdlS2V5KSAhPT0gJ3VuZGVmaW5lZCdcbiAgICAgICAgICAgICAgICA/IGVsLmRhdGEoJ2VuYWJsZWQtJyArIHJhbmdlS2V5KVxuICAgICAgICAgICAgICAgIDogZGVmYXVsdEVuYWJsZWQ7XG4gICAgICAgIHJlc3BvbnNpdmVDb25maWdbYnJlYWtwb2ludF0gPSB7XG4gICAgICAgICAgICBpdGVtczogc2xpZGVzQ291bnQsXG4gICAgICAgICAgICBzbGlkZUJ5OiBtb3ZlQ291bnQsXG4gICAgICAgICAgICBkaXNhYmxlOiAhZW5hYmxlZFxuICAgICAgICB9O1xuXG4gICAgICAgIGRlZmF1bHRTbGlkZXNDb3VudCA9IHNsaWRlc0NvdW50O1xuICAgICAgICBkZWZhdWx0TW92ZUNvdW50ID0gbW92ZUNvdW50O1xuICAgICAgICBkZWZhdWx0RW5hYmxlZCA9IGVuYWJsZWQ7XG4gICAgfVxuXG4gICAgc2xpZGVyc1tzbGlkZXJJZF0ucGFuZWxzID0gcGFuZWxzO1xuICAgIHNsaWRlcnNbc2xpZGVySWRdLnJlc3BvbnNpdmVDb25maWcgPSByZXNwb25zaXZlQ29uZmlnO1xuXG4gICAgaWYgKHNsaWRlcnNbc2xpZGVySWRdWydlbmFibGVkLScgKyBjdXJyZW50UmFuZ2VdKSB7XG4gICAgICAgIGluaXRTbGlkZXIoc2xpZGVySWQpO1xuICAgIH0gZWxzZSB7XG4gICAgICAgIGVuYWJsZUxvYWRNb3JlKHNsaWRlcklkKTtcbiAgICB9XG59XG5cbmZ1bmN0aW9uIGVuYWJsZUxvYWRNb3JlIChzbGlkZXJJZCkge1xuICAgIGNvbnN0IHNsaWRlcnMgPSB3aW5kb3cuc2xpZGVycztcblxuICAgIHNsaWRlcnNbc2xpZGVySWRdLmNvbnRyb2xzLmhpZGUoKTtcblxuICAgIGNvbnN0IGxvYWRNb3JlID0gc2xpZGVyc1tzbGlkZXJJZF1bJ2xvYWQtbW9yZSddO1xuICAgIGNvbnN0IHJhbmdlID0gZ2V0UmFuZ2UoKTtcbiAgICBjb25zdCBzbGlkZUNvdW50ID0gc2xpZGVyc1tzbGlkZXJJZF1bJ2l0ZW1zLScgKyByYW5nZV07XG4gICAgaWYgKHR5cGVvZiBsb2FkTW9yZSAhPT0gJ3VuZGVmaW5lZCcpIHtcbiAgICAgICAgbG9hZE1vcmUuc2hvdygpO1xuICAgICAgICBzbGlkZXJzW3NsaWRlcklkXS5wYW5lbHMuc2xpY2Uoc2xpZGVDb3VudCkuaGlkZSgpO1xuICAgIH1cbn1cblxuZnVuY3Rpb24gaW5pdFNsaWRlciAoc2xpZGVySWQpIHtcbiAgICBjb25zdCBzbGlkZXJzID0gd2luZG93LnNsaWRlcnM7XG5cbiAgICBjb25zdCByYW5nZSA9IGdldFJhbmdlKCk7XG4gICAgY29uc3Qgc2xpZGVSYW5nZSA9ICdpdGVtcy0nICsgcmFuZ2U7XG4gICAgY29uc3QgbW92ZVJhbmdlID0gJ21vdmUtJyArIHJhbmdlO1xuICAgIGNvbnN0IGl0ZW1zQ291bnQgPSBzbGlkZXJzW3NsaWRlcklkXVtzbGlkZVJhbmdlXTtcbiAgICBjb25zdCBtb3ZlQ291bnQgPSBzbGlkZXJzW3NsaWRlcklkXVttb3ZlUmFuZ2VdO1xuICAgIGNvbnN0IGNvbnRyb2xzID0gc2xpZGVyc1tzbGlkZXJJZF0uY29udHJvbHM7XG4gICAgY29uc3QgZWwgPSBzbGlkZXJzW3NsaWRlcklkXS5lbGVtZW50O1xuICAgIGNvbnN0IGluaXRpYWxTbGlkZSA9IHNsaWRlcnNbc2xpZGVySWRdWydpbml0aWFsLXNsaWRlJ107XG5cbiAgICBjb25zdCBzbGlkZXJFbCA9IGVsLmZpbmQoJy5zbGlkZXJfX2NvbnRhaW5lcicpO1xuICAgIGNvbnN0IHByZXZCdG4gPSBlbC5maW5kKCcuc2xpZGVyX19wcmV2Jyk7XG4gICAgY29uc3QgbmV4dEJ0biA9IGVsLmZpbmQoJy5zbGlkZXJfX25leHQnKTtcbiAgICBpZiAoc2xpZGVyRWwubGVuZ3RoKSB7XG4gICAgICAgIGNvbnRyb2xzLnNob3coKTtcbiAgICAgICAgZWwuYWRkQ2xhc3MoJ2l0ZW0tc2xpZGVyLS1hY3RpdmUnKTtcblxuICAgICAgICAvLyBjb25zdCBwb3B1cFNlbGVjdG9yID0gJy5tb2RhbC10cmlnZ2VyLCAuZ2xpZ2h0Ym94JztcbiAgICAgICAgLy8gY29uc3QgcG9wdXBzID0gZG9jdW1lbnQucXVlcnlTZWxlY3RvckFsbChwb3B1cFNlbGVjdG9yKTtcblxuICAgICAgICBjb25zdCBzbGlkZXIgPSB0bnMoe1xuICAgICAgICAgICAgY29udGFpbmVyOiBzbGlkZXJFbC5nZXQoMCksXG4gICAgICAgICAgICBhdXRvV2lkdGg6IHNsaWRlcnNbc2xpZGVySWRdLmF1dG9XaWR0aCxcbiAgICAgICAgICAgIGxvb3A6IHRydWUsXG4gICAgICAgICAgICBwcmV2QnV0dG9uOiBwcmV2QnRuLmxlbmd0aCA/IHByZXZCdG4uZ2V0KDApIDogdHJ1ZSxcbiAgICAgICAgICAgIG5leHRCdXR0b246IG5leHRCdG4ubGVuZ3RoID8gbmV4dEJ0bi5nZXQoMCkgOiB0cnVlLFxuICAgICAgICAgICAgbmF2OiBmYWxzZSxcbiAgICAgICAgICAgIGl0ZW1zOiBpdGVtc0NvdW50LFxuICAgICAgICAgICAgc2xpZGVCeTogbW92ZUNvdW50LFxuICAgICAgICAgICAgc3RhcnRJbmRleDogaW5pdGlhbFNsaWRlLFxuICAgICAgICAgICAgcmVzcG9uc2l2ZTogc2xpZGVyc1tzbGlkZXJJZF0ucmVzcG9uc2l2ZUNvbmZpZ1xuICAgICAgICAgICAgLyogb25Jbml0OiBmdW5jdGlvbiAoKSB7XG4gICAgICAgICAgICAgICAgaWYgKHBvcHVwcy5sZW5ndGgpIHtcbiAgICAgICAgICAgICAgICAgICAgaW1wb3J0KCcuL3BvcHVwcycpLnRoZW4oKHsgaW5pdFBvcHVwcyB9KSA9PiB7XG4gICAgICAgICAgICAgICAgICAgICAgICBpbml0UG9wdXBzKCk7XG4gICAgICAgICAgICAgICAgICAgIH0pO1xuICAgICAgICAgICAgICAgIH1cbiAgICAgICAgICAgIH0gKi9cbiAgICAgICAgfSk7XG4gICAgICAgIHNsaWRlcnNbc2xpZGVySWRdLnNsaWRlciA9IHNsaWRlcjtcbiAgICB9IGVsc2Uge1xuICAgICAgICBjb250cm9scy5oaWRlKCk7XG4gICAgICAgIGVsLnJlbW92ZUNsYXNzKCdpdGVtLXNsaWRlci0tYWN0aXZlJyk7XG4gICAgfVxuXG4gICAgd2luZG93LmRpc3BhdGNoRXZlbnQobmV3IEV2ZW50KCdyZXNpemUnKSk7XG59XG5cbmZ1bmN0aW9uIGdldFJhbmdlICgpIHtcbiAgICBjb25zdCB3aWR0aCA9ICQod2luZG93KS53aWR0aCgpO1xuXG4gICAgaWYgKHdpZHRoID49IDEyMDApIHtcbiAgICAgICAgcmV0dXJuICd4bCc7XG4gICAgfSBlbHNlIGlmICh3aWR0aCA+IDk5Mikge1xuICAgICAgICByZXR1cm4gJ2xnJztcbiAgICB9IGVsc2UgaWYgKHdpZHRoID4gNzY4KSB7XG4gICAgICAgIHJldHVybiAnbWQnO1xuICAgIH0gZWxzZSBpZiAod2lkdGggPiA1NzYpIHtcbiAgICAgICAgcmV0dXJuICdzbSc7XG4gICAgfSBlbHNlIHtcbiAgICAgICAgcmV0dXJuICd4cyc7XG4gICAgfVxufVxuXG5leHBvcnQgeyBpbml0U2xpZGVycywgc2xpZGVyU2VsZWN0b3IgfTtcbiJdLCJuYW1lcyI6WyIkIiwidG5zIiwic2xpZGVyU2VsZWN0b3IiLCJ3aW5kb3ciLCJzbGlkZXJzIiwiaW5pdFNsaWRlcnMiLCJpdGVtU2xpZGVycyIsImluaXRJdGVtU2xpZGVycyIsInRlYXNlclNsaWRlciIsImxlbmd0aCIsImF1dG9wbGF5QnV0dG9uIiwiY29udGFpbmVyIiwiZ2V0IiwiYXV0b3BsYXkiLCJsb29wIiwicHJldkJ1dHRvbiIsIm5leHRCdXR0b24iLCJuYXZDb250YWluZXIiLCJhdXRvcGxheUJ1dHRvbk91dHB1dCIsImF1dG9wbGF5VGltZW91dCIsIml0ZW1zIiwic2xpZGVCeSIsIm1vZGUiLCJzcGVlZCIsImFuaW1hdGVJbiIsImFuaW1hdGVPdXQiLCJlYWNoIiwiaW5kZXgiLCJjcmVhdGVTbGlkZXIiLCJvbiIsInNsaWRlcklkIiwicmFuZ2UiLCJnZXRSYW5nZSIsImNvbnRyb2xzIiwiaGlkZSIsInNsaWRlciIsInNob3ciLCJkaXNwYXRjaEV2ZW50IiwiRXZlbnQiLCJyZXNpemUiLCJlbCIsImNvbnRyb2xzU2VsZWN0b3IiLCJmaW5kIiwiY3VycmVudFJhbmdlIiwicGFuZWxzIiwiZWxlbWVudCIsImRhdGEiLCJhdXRvV2lkdGgiLCJhdHRyaWJ1dGVzIiwiYXR0ckRlZmF1bHRWYWx1ZXMiLCJyYW5nZXMiLCJ4bCIsImxnIiwibWQiLCJzbSIsInhzIiwieHhzIiwiZm9yRWFjaCIsImF0dHIiLCJpIiwiY3VycmVudFZhbHVlIiwicmFuZ2VLZXkiLCJkZWZhdWx0VmFsdWUiLCJ2YWx1ZSIsInJlc3BvbnNpdmVDb25maWciLCJkZWZhdWx0U2xpZGVzQ291bnQiLCJkZWZhdWx0TW92ZUNvdW50IiwiZGVmYXVsdEVuYWJsZWQiLCJicmVha3BvaW50Iiwic2xpZGVzQ291bnQiLCJtb3ZlQ291bnQiLCJlbmFibGVkIiwiZGlzYWJsZSIsImluaXRTbGlkZXIiLCJlbmFibGVMb2FkTW9yZSIsImxvYWRNb3JlIiwic2xpZGVDb3VudCIsInNsaWNlIiwic2xpZGVSYW5nZSIsIm1vdmVSYW5nZSIsIml0ZW1zQ291bnQiLCJpbml0aWFsU2xpZGUiLCJzbGlkZXJFbCIsInByZXZCdG4iLCJuZXh0QnRuIiwiYWRkQ2xhc3MiLCJuYXYiLCJzdGFydEluZGV4IiwicmVzcG9uc2l2ZSIsInJlbW92ZUNsYXNzIiwid2lkdGgiXSwic291cmNlUm9vdCI6IiJ9