# porta frontend starter kit
***

Because of simple .htaccess routing, you need to have Apache webserver installed or use a Docker container with Apache and PHP.

## For twig templates compilation, install packages running
`composer install`

## Set up your environment and install global packages
+ install node.js and npm (include it to system PATH variable)
	- run `npm update -g npm`
	- run `npm install -g gulp`
+ optionally install livereload browser extension http://livereload.com/extensions/

## Install local project packages
+ npm install

## Start developing
+ gulp dev

## Build project for production
+ gulp prod

## The chain
+ js libraries are downloaded via npm into the node_modules with a lot of mess
+ the libraries are cherry-picked with the npm files gulp task and copied into static/js/lib and static/scss/lib folders
+ fancybox css is already commited in static/scss/src as _fancybox.scss because of image path dependencies
+ css is compiled from scss/styles.scss with the sass gulp task into static/css/styles.css (development) or static/css/styles.min.css (production)
+ js libraries and js partials are concatenated and minified with the uglify gulp task into static/js/scripts.js (development) or static/js/scripts.min.js (production)
+ the watch gulp task listens to changes of *.scss files in scss/src/ and *.js files in static/js/src/ and *.html files in root folder
