jQuery(function(){
	var body = $('body'),
		dropdownTriggers = $('.dropdown-trig'),
		menuTrigger = $('.menu-trigger');

	menuTrigger.on('click', function(e) {
		e.preventDefault();
		hideDropdowns();
		body.toggleClass('menu-open');
	});

	dropdownTriggers.each(function() {
		var trigger = $(this),
			elId = trigger.data('dropdown'),
			dropdown = $('#' + elId);
		if(dropdown.length) {
			trigger.on('click', function() {
				if(($(window).width() > 992)) {
					var wasOpened = dropdown.hasClass('dropdown-open');
					$('.dropdown').removeClass('dropdown-open').slideUp(100);
					$('.dropdown-trig').removeClass('dropdown-trig-active');
					if(!wasOpened) {
						dropdown.addClass('dropdown-open').slideDown(200);
						trigger.addClass('dropdown-trig-active');
					}
				}
				else {
					dropdown.toggleClass('dropdown-open').slideToggle(200);
					trigger.toggleClass('dropdown-trig-active');
				}
			});
		}
	});

	$(document).bind('click', function (e) {
		if (!$('.main-nav, .secondary-nav, .x-layer').is(e.target) && $('.main-nav, .secondary-nav, .x-layer').has(e.target).length === 0) {
			hideDropdowns();
		}
	});

	function hideDropdowns() {
		$('.dropdown').slideUp(200, function() { $('.dropdown').removeClass('dropdown-open'); });
		$('.dropdown-trig').removeClass('dropdown-trig-active');
	}
 });