var sliders = [];

$(document).ready(function ($) {

	// Sudo slider
	if ($.fn.sudoSlider) {

		// Item slider
		$('.item-slider').each(function (index) {
			var sliderId = 'itemSlider'.index,
				sliderWrapper = $(this);
			sliders[sliderId] = [];
			var el = $(this);

			sliders[sliderId]['slideNum'] = el.data('slides') ? el.data('slides') : 1;
			sliders[sliderId]['slideNumLg'] = el.data('slides-lg') ? el.data('slides-lg') : 1;
			sliders[sliderId]['slideNumMd'] = el.data('slides-md') ? el.data('slides-md') : 1;
			sliders[sliderId]['slideNumSm'] = el.data('slides-sm') ? el.data('slides-sm') : 1;
			sliders[sliderId]['slideNumXs'] = el.data('slides-xs') ? el.data('slides-xs') : 1;

			var panelNum = el.find('.panel').length,
				range = getSlideNumRange(),
				slidesCount = sliders[sliderId][range];
			if (panelNum > slidesCount) {
				sliders[sliderId]['slider'] = el.find('.slider').sudoSlider({
					//effect: 'fade',
					vertical: false,
					auto: false,
					autowidth: false,
					continuous: true,
					prevNext: true,
					numeric: true,
					slideCount: sliders[sliderId]['slideNum'],
					speed: 250,
					responsive: true,
					customLink: 'a.customLink',
					controlsAttr: 'class="slider-nav"',
					prevHtml: '<a href="#" class="prev"></a>',
					nextHtml: '<a href="#" class="next"></a>'
				});
			}
		});

		$(window).on("resizeEnd focus", function () {
			for (var i in sliders) {
				if (!sliders.hasOwnProperty(i) || !sliders[i]['slider'])
					continue;

				var orgSlideCount = sliders[i]['slider'].getOption("slideCount");
				var range = getSlideNumRange();
				slideCount = sliders[i][range];

				if (slideCount != orgSlideCount) {
					sliders[i]['slider'].setOption("slideCount", slideCount);
				}
			}
			;
		}).resize();

		function getSlideNumRange() {
			var width = $(window).width();

			if (width >= 1200) {
				return 'slideNum';
			} else if (width > 992) { 
				return 'slideNumLg';
			} else if (width > 768) { 
				return 'slideNumMd';
			} else if (width > 576) { 
				return 'slideNumSm';
			} else {
				return 'slideNumXs';
			}
		}

		// Teaser slider
		$('.teaser-slider').each(function (index) {
			var panelNum = $(this).find('.panel').length;

			if (panelNum > 1) {
				teaserSlider = $(this).find('.slider').sudoSlider({
					//effect: 'fade',
					vertical: false,
					auto: false,
					autowidth: false,
					continuous: true,
					prevNext: true,
					numeric: true,
					slideCount: 1,
					speed: 250,
					responsive: true,
					controlsAttr: 'class="slider-nav"',
					prevHtml: '<a href="#" class="prev"></a>',
					nextHtml: '<a href="#" class="next"></a>'
				});
			}
		});
	}

});
