# Funkcionalita do budúcnosti

* Integrácia Webpacku
* Integrácia Twigu
* Použitie ES6+ v knižniciach

---



```javascript
// task('bundle:dev', series('sass:dev', 'js:dev'))
// task('bundle:prod', series('sass:prod', 'js:prod'))
// task('dev', series('watch'))
// task('prod', series('sass:dev', 'js:dev', 'sass:prod', 'js:prod'))

task('js:dev:finalize', series('js:dev', combineJSDev))

const jsDevLib = async () => src(jsLibFilesOrdered)
  .pipe($.concat(`${cfg.js.bundle}.lib.js`))
  .pipe(dest(cfg.js.dst))
const jsDevSrc = async () => src(jsSrcFilesOrdered)
  .pipe($.concat(`${cfg.js.bundle}.src.js`))
  .pipe($.plumber())
  .pipe($.babel())
  .pipe(dest(cfg.js.dst))
const jsProdLib = async () => src(jsLibFilesOrdered)
  .pipe($.sourcemaps.init())
  .pipe($.concat(`${cfg.js.bundle}.lib.min.js`))
  .pipe($.uglify())
  .pipe($.sourcemaps.write('.'))
  .pipe(dest(cfg.js.dst))
const jsProdSrc = async () => src(jsSrcFilesOrdered)
  .pipe($.sourcemaps.init())
  .pipe($.concat(`${cfg.js.bundle}.src.min.js`))
  .pipe($.uglify())
  .pipe($.sourcemaps.write('.'))
  .pipe(dest(cfg.js.dst))
const combineJSDev = async () => src([ `./dist/${cfg.js.bundle}.lib.js`, `./dist/${cfg.js.bundle}.src.js` ])
  .pipe($.concat(`${cfg.js.bundle}.js`))
  .pipe(dest(cfg.js.dst))
  .pipe($.livereload())
const combineJSProd = async () => src([ `./dist/${cfg.js.bundle}.lib.min.js`, `./dist/${cfg.js.bundle}.src.min.js` ])
  .pipe($.concat(`${cfg.js.bundle}.min.js`))
  .pipe(dest(cfg.js.dst))
```

```
"@babel/core": "^7.11.1",
"@babel/plugin-transform-runtime": "^7.11.0",
"@babel/preset-env": "^7.11.0",
"@babel/register": "7.10.5",
"@babel/runtime": "^7.11.2",
"gulp-babel": "^8.0.0",
"gulp-plumber": "^1.2.1",
```

