import { task, src, dest, watch, series } from 'gulp' //const gulp = require('gulp');
import mainNPMFiles from 'npmfiles'
const $ = require('gulp-load-plugins')({ DEBUG: true })

// ---  ---  ---  ---  ---  ---  ---  ---  ---  ---  ---  ---  ---  --- 
// Configuration objects.
// ---  ---  ---  ---  ---  ---  ---  ---  ---  ---  ---  ---  ---  --- 

const cfg = {
  scss: {
    src: './src/scss',
    lib: './dist/lib-scss',
    dst: './dist',
    bundle: 'styles'
  },
  js: {
    src: './src/js',
    lib: './dist/lib-js',
    dst: './dist',
    bundle: 'scripts'
  }
}

/** List of sass stylesheets. */
const sassFilesOrdered = [
  `${cfg.scss.src}/_reset.scss`,
  `${cfg.scss.src}/_bootstrap-grid.scss`,
  `${cfg.scss.src}/_settings.scss`,
  `${cfg.scss.src}/_fancybox.scss`,
  `${cfg.scss.src}/_general.scss`,
  `${cfg.scss.src}/_typography.scss`,
  `${cfg.scss.src}/**/*.scss`,
	`${cfg.scss.lib}/**/*.scss`,
]

/** List of entrypoints to our & dependency libs */
const jsFilesOrdered = [
  `!${cfg.js.lib}/svg4everybody.legacy.js`,
  `${cfg.js.lib}/jquery.js`,
  `${cfg.js.lib}/jquery.validate.js`,
  `${cfg.js.lib}/**/*.js`,
  `${cfg.js.src}/**/*.js`
]

// ---  ---  ---  ---  ---  ---  ---  ---  ---  ---  ---  ---  ---  --- 

const jsFilter = $.filter('**/*.js', { restore: true });
const cssFilter = $.filter('**/*.css');

task('libcopy', () => src(mainNPMFiles({ showWarnings: true }))
  .pipe(jsFilter)
  .pipe(dest(cfg.js.lib))
  .pipe(jsFilter.restore)
  .pipe(cssFilter)
  .pipe($.rename({ extname: '.scss' }))
  .pipe(dest(cfg.scss.lib))
)

// ---  ---  ---  ---  ---  ---  ---  ---  ---  ---  ---  ---  ---  --- 
// Tasky pre balickovanie Sassu do CSS
// ---  ---  ---  ---  ---  ---  ---  ---  ---  ---  ---  ---  ---  --- 

/**  */
const sassDev = async () => src(sassFilesOrdered)
  .pipe($.sourcemaps.init())
  .pipe($.concat(`${cfg.scss.bundle}.css`))
  .pipe($.sass({outputStyle: 'expanded'}))
  .pipe($.autoprefixer({ cascade: false }))
  .pipe($.sourcemaps.write('.'))
  .pipe(dest(cfg.scss.dst))
  .pipe($.livereload())

const sassProd = async () => src(sassFilesOrdered)
  .pipe($.sourcemaps.init())
  .pipe($.concat(`${cfg.scss.bundle}.min.css`))
  .pipe($.sass({ outputStyle: 'compressed' }))
  .pipe($.autoprefixer({ cascade: false }))
  .pipe($.sourcemaps.write('.'))
  .pipe(dest(cfg.scss.dst))


task('sass:dev:watch', series(sassDev))
task('sass:dev', series('libcopy', sassDev))
task('sass:prod', series('libcopy', sassProd))

// ---  ---  ---  ---  ---  ---  ---  ---  ---  ---  ---  ---  ---  --- 
// Tasky pre balickovanie JS kniznic a nasho kodu
// ---  ---  ---  ---  ---  ---  ---  ---  ---  ---  ---  ---  ---  --- 

const jsDev = async () => src(jsFilesOrdered)
  .pipe($.concat(`${cfg.js.bundle}.js`))
  .pipe(dest(cfg.js.dst))
  
const jsProd = async () => src(jsFilesOrdered)
  .pipe($.sourcemaps.init())
  .pipe($.concat(`${cfg.js.bundle}.min.js`))
  .pipe($.uglify())
  .pipe($.sourcemaps.write('.'))
  .pipe(dest(cfg.js.dst))

task('js:dev:watch', jsDev)
task('js:dev', series('libcopy', jsDev))
task('js:prod', series('libcopy', jsProd))

// ---  ---  ---  ---  ---  ---  ---  ---  ---  ---  ---  ---  ---  ---
// Top-level tasky
// ---  ---  ---  ---  ---  ---  ---  ---  ---  ---  ---  ---  ---  ---

task('html:dev:watch', async () => 
	src(['./*.html']).pipe($.livereload())
)

task('watch', () => {
	$.livereload.listen()
	watch(['*.html'], series('html:dev:watch'))
	watch([`${cfg.scss.src}/*.scss`], series('sass:dev:watch'))
  watch([`${cfg.js.src}/*.js`], series('js:dev:watch'))
})

task('default', series('watch'))
