/** @type {import('tailwindcss').Config} */
module.exports = {
  content: ['./templates/**/*.{html,twig,js,scss}', './assets/**/*.{html,twig,js,scss}'],
  theme: {
    colors: {
      transparent: 'transparent',
      white: 'var(--white)',
      black: 'var(--black)',
      gray: 'var(--gray)',
      lightGray: 'var(--lightGray)',
      yellow: 'var(--yellow)',
      darkYellow: 'var(--darkYellow)',
      outline: 'var(--outline)',
    },
    // breakpoint definitions
    screens: {
      xxs: "420px",
      xs: "576px",
      sm: "768px",
      md: "992px",
      lg: "1200px",
      xl: "1370px",
      xxl: "1570px",
    },
    extend: {
      container: {
        center: true,
        padding: 'var(--container-padding)'
      },
    }
  },
  plugins: [],
}